/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.process;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.process.ProcessingComponent;
import org.modeshape.jcr.query.process.SetOperationComponent;

public class ExceptComponent
extends SetOperationComponent {
    private final Comparator<Object[]> comparator;

    public ExceptComponent(QueryContext context, QueryResults.Columns columns, Iterable<ProcessingComponent> sources, boolean alreadySorted, boolean all) {
        super(context, columns, sources, alreadySorted, all);
        this.comparator = this.createSortComparator(context, columns);
    }

    @Override
    public List<Object[]> execute() {
        Iterator<ProcessingComponent> sources = this.sources().iterator();
        if (!sources.hasNext()) {
            return this.emptyTuples();
        }
        LinkedList<List<Object[]>> allTuples = new LinkedList<List<Object[]>>();
        while (sources.hasNext()) {
            List<Object[]> tuples = sources.next().execute();
            if (tuples == null) continue;
            if (tuples.isEmpty()) {
                return this.emptyTuples();
            }
            allTuples.add(tuples);
        }
        if (allTuples.isEmpty()) {
            return this.emptyTuples();
        }
        if (allTuples.size() == 1) {
            return (List)allTuples.get(0);
        }
        Collections.sort(allTuples, new Comparator<List<Object[]>>(){

            @Override
            public int compare(List<Object[]> tuples1, List<Object[]> tuples2) {
                return tuples1.size() - tuples2.size();
            }
        });
        Iterator iter = allTuples.iterator();
        List tuples = (List)iter.next();
        assert (iter.hasNext());
        block1: while (iter.hasNext()) {
            List next = (List)iter.next();
            Iterator tupleIter = tuples.iterator();
            Iterator nextIter = next.iterator();
            Object[] tuple1 = (Object[])tupleIter.next();
            Object[] tuple2 = (Object[])nextIter.next();
            while (true) {
                int comparison;
                if ((comparison = this.comparator.compare(tuple1, tuple2)) == 0) {
                    tupleIter.remove();
                    if (!tupleIter.hasNext()) continue block1;
                    tuple1 = (Object[])tupleIter.next();
                    continue;
                }
                if (comparison < 0) {
                    if (!tupleIter.hasNext()) continue block1;
                    tuple1 = (Object[])tupleIter.next();
                    continue;
                }
                assert (comparison > 0);
                if (!nextIter.hasNext()) continue block1;
                tuple2 = (Object[])nextIter.next();
            }
        }
        this.removeDuplicatesIfRequested(tuples);
        return tuples;
    }
}

