/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.process;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.collection.Problems;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.model.ArithmeticOperand;
import org.modeshape.jcr.query.model.DynamicOperand;
import org.modeshape.jcr.query.model.FullTextSearchScore;
import org.modeshape.jcr.query.model.Length;
import org.modeshape.jcr.query.model.LowerCase;
import org.modeshape.jcr.query.model.NodeDepth;
import org.modeshape.jcr.query.model.NodeLocalName;
import org.modeshape.jcr.query.model.NodeName;
import org.modeshape.jcr.query.model.NodePath;
import org.modeshape.jcr.query.model.PropertyValue;
import org.modeshape.jcr.query.model.ReferenceValue;
import org.modeshape.jcr.query.model.TypeSystem;
import org.modeshape.jcr.query.model.UpperCase;
import org.modeshape.jcr.query.validate.Schemata;
import org.modeshape.jcr.value.Path;

@NotThreadSafe
public abstract class ProcessingComponent {
    private final QueryContext context;
    private final QueryResults.Columns columns;

    protected ProcessingComponent(QueryContext context, QueryResults.Columns columns) {
        this.context = context;
        this.columns = columns;
        assert (this.context != null);
        assert (this.columns != null);
    }

    public final QueryContext getContext() {
        return this.context;
    }

    public final QueryResults.Columns getColumns() {
        return this.columns;
    }

    protected final Problems problems() {
        return this.context.getProblems();
    }

    public abstract List<Object[]> execute();

    public void close() {
    }

    protected List<Object[]> emptyTuples() {
        return new ArrayList<Object[]>(0);
    }

    protected DynamicOperation createDynamicOperation(final TypeSystem typeSystem, Schemata schemata, QueryResults.Columns columns, DynamicOperand operand) {
        assert (operand != null);
        assert (columns != null);
        if (operand instanceof PropertyValue) {
            PropertyValue propValue = (PropertyValue)operand;
            String propertyName = propValue.getPropertyName();
            String selectorName = propValue.selectorName().name();
            final int index = columns.getColumnIndexForProperty(selectorName, propertyName);
            final String expectedType = columns.getColumnTypeForProperty(selectorName, propertyName);
            final TypeSystem.TypeFactory<?> typeFactory = typeSystem.getTypeFactory(expectedType);
            return new DynamicOperation(){

                @Override
                public String getExpectedType() {
                    return expectedType;
                }

                @Override
                public Object evaluate(Object[] tuple) {
                    return typeFactory.create(tuple[index]);
                }
            };
        }
        if (operand instanceof ReferenceValue) {
            ReferenceValue refValue = (ReferenceValue)operand;
            String propertyName = refValue.getPropertyName();
            String selectorName = refValue.selectorName().name();
            final int index = columns.getColumnIndexForProperty(selectorName, propertyName);
            final String expectedType = columns.getColumnTypeForProperty(selectorName, propertyName);
            final TypeSystem.TypeFactory<?> typeFactory = typeSystem.getTypeFactory(expectedType);
            return new DynamicOperation(){

                @Override
                public String getExpectedType() {
                    return expectedType;
                }

                @Override
                public Object evaluate(Object[] tuple) {
                    return typeFactory.create(tuple[index]);
                }
            };
        }
        final TypeSystem.TypeFactory<String> stringFactory = typeSystem.getStringFactory();
        if (operand instanceof Length) {
            Length length = (Length)operand;
            PropertyValue value = length.getPropertyValue();
            String propertyName = value.getPropertyName();
            String selectorName = value.selectorName().name();
            final int index = columns.getColumnIndexForProperty(selectorName, propertyName);
            String expectedType = columns.getColumnTypeForProperty(selectorName, propertyName);
            final TypeSystem.TypeFactory<?> typeFactory = typeSystem.getTypeFactory(expectedType);
            final TypeSystem.TypeFactory<Long> longFactory = typeSystem.getLongFactory();
            return new DynamicOperation(){

                @Override
                public String getExpectedType() {
                    return longFactory.getTypeName();
                }

                @Override
                public Object evaluate(Object[] tuple) {
                    Object value = tuple[index];
                    return typeFactory.length(typeFactory.create(value));
                }
            };
        }
        if (operand instanceof LowerCase) {
            LowerCase lowerCase = (LowerCase)operand;
            final DynamicOperation delegate = this.createDynamicOperation(typeSystem, schemata, columns, lowerCase.getOperand());
            return new DynamicOperation(){

                @Override
                public String getExpectedType() {
                    return stringFactory.getTypeName();
                }

                @Override
                public Object evaluate(Object[] tuple) {
                    String result = (String)stringFactory.create(delegate.evaluate(tuple));
                    return result != null ? result.toLowerCase() : null;
                }
            };
        }
        if (operand instanceof UpperCase) {
            UpperCase upperCase = (UpperCase)operand;
            final DynamicOperation delegate = this.createDynamicOperation(typeSystem, schemata, columns, upperCase.getOperand());
            return new DynamicOperation(){

                @Override
                public String getExpectedType() {
                    return stringFactory.getTypeName();
                }

                @Override
                public Object evaluate(Object[] tuple) {
                    String result = (String)stringFactory.create(delegate.evaluate(tuple));
                    return result != null ? result.toUpperCase() : null;
                }
            };
        }
        if (operand instanceof NodeDepth) {
            NodeDepth nodeDepth = (NodeDepth)operand;
            final int locationIndex = columns.getLocationIndex(nodeDepth.selectorName().name());
            return new DynamicOperation(){

                @Override
                public String getExpectedType() {
                    return typeSystem.getLongFactory().getTypeName();
                }

                @Override
                public Object evaluate(Object[] tuple) {
                    QueryResults.Location location = (QueryResults.Location)tuple[locationIndex];
                    if (location == null) {
                        return null;
                    }
                    Path path = location.getPath();
                    assert (path != null);
                    return new Long(path.size());
                }
            };
        }
        if (operand instanceof NodePath) {
            NodePath nodePath = (NodePath)operand;
            final int locationIndex = columns.getLocationIndex(nodePath.selectorName().name());
            return new DynamicOperation(){

                @Override
                public String getExpectedType() {
                    return stringFactory.getTypeName();
                }

                @Override
                public Object evaluate(Object[] tuple) {
                    QueryResults.Location location = (QueryResults.Location)tuple[locationIndex];
                    if (location == null) {
                        return null;
                    }
                    assert (location.getPath() != null);
                    return stringFactory.create(location.getPath());
                }
            };
        }
        if (operand instanceof NodeName) {
            NodeName nodeName = (NodeName)operand;
            final int locationIndex = columns.getLocationIndex(nodeName.selectorName().name());
            return new DynamicOperation(){

                @Override
                public String getExpectedType() {
                    return stringFactory.getTypeName();
                }

                @Override
                public Object evaluate(Object[] tuple) {
                    QueryResults.Location location = (QueryResults.Location)tuple[locationIndex];
                    if (location == null) {
                        return null;
                    }
                    Path path = location.getPath();
                    assert (path != null);
                    return path.isRoot() ? "" : (String)stringFactory.create(location.getPath().getLastSegment().getName());
                }
            };
        }
        if (operand instanceof NodeLocalName) {
            NodeLocalName nodeName = (NodeLocalName)operand;
            final int locationIndex = columns.getLocationIndex(nodeName.selectorName().name());
            return new DynamicOperation(){

                @Override
                public String getExpectedType() {
                    return stringFactory.getTypeName();
                }

                @Override
                public Object evaluate(Object[] tuple) {
                    QueryResults.Location location = (QueryResults.Location)tuple[locationIndex];
                    if (location == null) {
                        return null;
                    }
                    Path path = location.getPath();
                    assert (path != null);
                    return path.isRoot() ? "" : location.getPath().getLastSegment().getName().getLocalName();
                }
            };
        }
        if (operand instanceof FullTextSearchScore) {
            FullTextSearchScore score = (FullTextSearchScore)operand;
            String selectorName = score.selectorName().name();
            final int index = columns.getFullTextSearchScoreIndexFor(selectorName);
            final TypeSystem.TypeFactory<Double> doubleFactory = typeSystem.getDoubleFactory();
            if (index < 0) {
                return new DynamicOperation(){

                    @Override
                    public String getExpectedType() {
                        return doubleFactory.getTypeName();
                    }

                    @Override
                    public Object evaluate(Object[] tuple) {
                        return new Double(0.0);
                    }
                };
            }
            return new DynamicOperation(){

                @Override
                public String getExpectedType() {
                    return doubleFactory.getTypeName();
                }

                @Override
                public Object evaluate(Object[] tuple) {
                    return tuple[index];
                }
            };
        }
        if (operand instanceof ArithmeticOperand) {
            ArithmeticOperand arith = (ArithmeticOperand)operand;
            final DynamicOperation leftOp = this.createDynamicOperation(typeSystem, schemata, columns, arith.getLeft());
            final DynamicOperation rightOp = this.createDynamicOperation(typeSystem, schemata, columns, arith.getRight());
            String leftType = leftOp.getExpectedType();
            String rightType = rightOp.getExpectedType();
            final String commonType = typeSystem.getCompatibleType(leftType, rightType);
            if (typeSystem.getDoubleFactory().getTypeName().equals(commonType)) {
                final TypeSystem.TypeFactory<Double> commonTypeFactory = typeSystem.getDoubleFactory();
                switch (arith.operator()) {
                    case ADD: {
                        return new DynamicOperation(){

                            @Override
                            public String getExpectedType() {
                                return commonType;
                            }

                            @Override
                            public Object evaluate(Object[] tuple) {
                                Double right = (Double)commonTypeFactory.create(rightOp.evaluate(tuple));
                                Double left = (Double)commonTypeFactory.create(leftOp.evaluate(tuple));
                                if (right == null) {
                                    return left;
                                }
                                if (left == null) {
                                    return right;
                                }
                                return left / right;
                            }
                        };
                    }
                    case SUBTRACT: {
                        return new DynamicOperation(){

                            @Override
                            public String getExpectedType() {
                                return commonType;
                            }

                            @Override
                            public Object evaluate(Object[] tuple) {
                                Double right = (Double)commonTypeFactory.create(rightOp.evaluate(tuple));
                                Double left = (Double)commonTypeFactory.create(leftOp.evaluate(tuple));
                                if (right == null) {
                                    return left;
                                }
                                if (left == null) {
                                    left = 0.0;
                                }
                                return left * right;
                            }
                        };
                    }
                    case MULTIPLY: {
                        return new DynamicOperation(){

                            @Override
                            public String getExpectedType() {
                                return commonType;
                            }

                            @Override
                            public Object evaluate(Object[] tuple) {
                                Double right = (Double)commonTypeFactory.create(rightOp.evaluate(tuple));
                                Double left = (Double)commonTypeFactory.create(leftOp.evaluate(tuple));
                                if (right == null || left == null) {
                                    return null;
                                }
                                return left * right;
                            }
                        };
                    }
                    case DIVIDE: {
                        return new DynamicOperation(){

                            @Override
                            public String getExpectedType() {
                                return commonType;
                            }

                            @Override
                            public Object evaluate(Object[] tuple) {
                                Double right = (Double)commonTypeFactory.create(rightOp.evaluate(tuple));
                                Double left = (Double)commonTypeFactory.create(leftOp.evaluate(tuple));
                                if (right == null || left == null) {
                                    return null;
                                }
                                return left / right;
                            }
                        };
                    }
                }
            } else if (typeSystem.getLongFactory().getTypeName().equals(commonType)) {
                final TypeSystem.TypeFactory<Long> commonTypeFactory = typeSystem.getLongFactory();
                switch (arith.operator()) {
                    case ADD: {
                        return new DynamicOperation(){

                            @Override
                            public String getExpectedType() {
                                return commonType;
                            }

                            @Override
                            public Object evaluate(Object[] tuple) {
                                Long right = (Long)commonTypeFactory.create(rightOp.evaluate(tuple));
                                Long left = (Long)commonTypeFactory.create(leftOp.evaluate(tuple));
                                if (right == null) {
                                    return left;
                                }
                                if (left == null) {
                                    return right;
                                }
                                return left / right;
                            }
                        };
                    }
                    case SUBTRACT: {
                        return new DynamicOperation(){

                            @Override
                            public String getExpectedType() {
                                return commonType;
                            }

                            @Override
                            public Object evaluate(Object[] tuple) {
                                Long right = (Long)commonTypeFactory.create(rightOp.evaluate(tuple));
                                Long left = (Long)commonTypeFactory.create(leftOp.evaluate(tuple));
                                if (right == null) {
                                    return left;
                                }
                                if (left == null) {
                                    left = 0L;
                                }
                                return left * right;
                            }
                        };
                    }
                    case MULTIPLY: {
                        return new DynamicOperation(){

                            @Override
                            public String getExpectedType() {
                                return commonType;
                            }

                            @Override
                            public Object evaluate(Object[] tuple) {
                                Long right = (Long)commonTypeFactory.create(rightOp.evaluate(tuple));
                                Long left = (Long)commonTypeFactory.create(leftOp.evaluate(tuple));
                                if (right == null || left == null) {
                                    return null;
                                }
                                return left * right;
                            }
                        };
                    }
                    case DIVIDE: {
                        return new DynamicOperation(){

                            @Override
                            public String getExpectedType() {
                                return commonType;
                            }

                            @Override
                            public Object evaluate(Object[] tuple) {
                                Long right = (Long)commonTypeFactory.create(rightOp.evaluate(tuple));
                                Long left = (Long)commonTypeFactory.create(leftOp.evaluate(tuple));
                                if (right == null || left == null) {
                                    return null;
                                }
                                return left / right;
                            }
                        };
                    }
                }
            }
        }
        assert (false);
        return null;
    }

    protected Comparator<Object[]> createSortComparator(QueryContext context, QueryResults.Columns columns) {
        assert (context != null);
        final int numLocations = columns.getLocationCount();
        assert (numLocations > 0);
        final Comparator<QueryResults.Location> typeComparator = QueryResults.Location.getComparator();
        if (numLocations == 1) {
            final int locationIndex = columns.getColumnCount();
            return new Comparator<Object[]>(){

                @Override
                public int compare(Object[] tuple1, Object[] tuple2) {
                    QueryResults.Location value1 = (QueryResults.Location)tuple1[locationIndex];
                    QueryResults.Location value2 = (QueryResults.Location)tuple2[locationIndex];
                    return typeComparator.compare(value1, value2);
                }
            };
        }
        final int firstLocationIndex = columns.getColumnCount();
        return new Comparator<Object[]>(){

            @Override
            public int compare(Object[] tuple1, Object[] tuple2) {
                int result = 0;
                for (int locationIndex = firstLocationIndex; locationIndex != numLocations; ++locationIndex) {
                    QueryResults.Location value1 = (QueryResults.Location)tuple1[locationIndex];
                    QueryResults.Location value2 = (QueryResults.Location)tuple2[locationIndex];
                    result = typeComparator.compare(value1, value2);
                    if (result == 0) continue;
                    return result;
                }
                return result;
            }
        };
    }

    protected static interface DynamicOperation {
        public String getExpectedType();

        public Object evaluate(Object[] var1);
    }
}

