/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.modeshape.common.logging.Logger;

public class InfinispanUtil {
    protected static final Logger LOGGER = Logger.getLogger(InfinispanUtil.class);

    private InfinispanUtil() {
    }

    public static <K, V> Sequence<K> getAllKeys(Cache<K, V> cache) throws CacheLoaderException, InterruptedException, ExecutionException {
        Set<K> cacheKeys;
        LOGGER.debug("getAllKeys of {0}", new Object[]{cache.getName()});
        CacheLoader cacheLoader = null;
        CacheLoaderManager cacheLoaderManager = (CacheLoaderManager)cache.getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class);
        if (cacheLoaderManager != null) {
            cacheLoader = cacheLoaderManager.getCacheLoader();
        }
        if (cacheLoader == null) {
            if (cache.getCacheConfiguration().clustering().cacheMode().isDistributed()) {
                LOGGER.debug("Use distributed call to fetch all keys", new Object[0]);
                DefaultExecutorService distributedExecutor = new DefaultExecutorService(cache);
                List futures = distributedExecutor.submitEverywhere(new GetAllMemoryKeys());
                cacheKeys = InfinispanUtil.mergeResults(futures);
            } else {
                cacheKeys = cache.keySet();
            }
        } else {
            LOGGER.debug("Cache contains loader", new Object[0]);
            boolean shared = cache.getCacheConfiguration().loaders().shared();
            if (cache.getCacheConfiguration().clustering().cacheMode().isDistributed()) {
                if (!shared) {
                    LOGGER.debug("Use distributed call to fetch all keys", new Object[0]);
                    DefaultExecutorService distributedExecutor = new DefaultExecutorService(cache);
                    List futures = distributedExecutor.submitEverywhere(new GetAllKeys());
                    cacheKeys = InfinispanUtil.mergeResults(futures);
                } else {
                    LOGGER.debug("Load keys from loader", new Object[0]);
                    cacheKeys = new HashSet<K>(cache.keySet());
                    cacheKeys.addAll(cacheLoader.loadAllKeys(cacheKeys));
                }
            } else {
                LOGGER.debug("Load keys from loader", new Object[0]);
                cacheKeys = new HashSet<K>(cache.keySet());
                cacheKeys.addAll(cacheLoader.loadAllKeys(cacheKeys));
            }
        }
        return new IteratorSequence(cacheKeys.iterator());
    }

    private static <K> Set<K> mergeResults(List<Future<Set<K>>> futures) throws InterruptedException, ExecutionException {
        HashSet<K> allKeys = new HashSet<K>();
        do {
            Iterator<Future<Set<K>>> futureIter = futures.iterator();
            while (futureIter.hasNext()) {
                Future<Set<K>> future = futureIter.next();
                try {
                    Set<K> keys = future.get(100L, TimeUnit.MILLISECONDS);
                    futureIter.remove();
                    allKeys.addAll(keys);
                }
                catch (TimeoutException e) {}
            }
        } while (!futures.isEmpty());
        return allKeys;
    }

    private static final class GetAllKeys<K, V>
    implements DistributedCallable<K, V, Set<K>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Cache<K, V> cache;

        private GetAllKeys() {
        }

        public void setEnvironment(Cache<K, V> cache, Set<K> inputKeys) {
            this.cache = cache;
        }

        public Set<K> call() throws Exception {
            CacheLoaderManager cacheLoaderManager = (CacheLoaderManager)this.cache.getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class);
            if (cacheLoaderManager == null) {
                return this.cache.keySet();
            }
            CacheLoader cacheLoader = cacheLoaderManager.getCacheLoader();
            if (cacheLoader == null) {
                return this.cache.keySet();
            }
            HashSet cacheKeys = new HashSet(this.cache.keySet());
            cacheKeys.addAll(cacheLoader.loadAllKeys(cacheKeys));
            return cacheKeys;
        }
    }

    private static final class GetAllMemoryKeys<K, V>
    implements DistributedCallable<K, V, Set<K>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Cache<K, V> cache;

        private GetAllMemoryKeys() {
        }

        public void setEnvironment(Cache<K, V> cache, Set<K> inputKeys) {
            this.cache = cache;
        }

        public Set<K> call() throws Exception {
            return this.cache.keySet();
        }
    }

    private static final class IteratorSequence<T>
    implements Sequence<T> {
        private final Iterator<T> iterator;

        public IteratorSequence(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public T next() {
            return this.iterator.hasNext() ? (T)this.iterator.next() : null;
        }
    }

    public static interface Sequence<T> {
        public T next() throws ExecutionException, CancellationException, InterruptedException;
    }
}

