/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.modeshape.common.util.CheckArg;

class JcrNodeListIterator
implements NodeIterator {
    private final long size;
    private final Iterator<? extends Node> nodes;
    private Node nextNode;
    private long position = 0L;

    protected JcrNodeListIterator(Iterator<? extends Node> nodeIter, long size) {
        this.nodes = nodeIter;
        this.size = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node nextNode() {
        if (this.hasNext()) {
            assert (this.nextNode != null);
            try {
                ++this.position;
                Node node = this.nextNode;
                return node;
            }
            finally {
                this.nextNode = null;
            }
        }
        throw new NoSuchElementException();
    }

    public long getPosition() {
        return this.position;
    }

    public long getSize() {
        return this.size;
    }

    public void skip(long skipNum) {
        CheckArg.isNonNegative((long)skipNum, (String)"skipNum");
        if (skipNum == 0L) {
            return;
        }
        for (long i = 0L; i != skipNum; ++i) {
            if (!this.hasNext()) {
                return;
            }
            this.next();
        }
    }

    public boolean hasNext() {
        while (this.nextNode == null && this.nodes.hasNext()) {
            this.nextNode = this.nodes.next();
        }
        return this.nextNode != null;
    }

    public Object next() {
        return this.nextNode();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

