/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.Iterator;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.document.AbstractChildReferences;
import org.modeshape.jcr.cache.document.ImmutableChildReferences;
import org.modeshape.jcr.cache.document.MutableChildReferences;
import org.modeshape.jcr.cache.document.SessionNode;
import org.modeshape.jcr.cache.document.UnionIterator;
import org.modeshape.jcr.value.Name;

@ThreadSafe
public class SessionChildReferences
extends AbstractChildReferences {
    private final ChildReferences persisted;
    private final MutableChildReferences appended;
    private final SessionNode.ChangedChildren changedChildren;

    public SessionChildReferences(ChildReferences persisted, MutableChildReferences appended, SessionNode.ChangedChildren changedChildren) {
        this.persisted = persisted != null ? persisted : ImmutableChildReferences.EMPTY_CHILD_REFERENCES;
        this.appended = appended;
        this.changedChildren = changedChildren;
    }

    @Override
    public long size() {
        return this.persisted.size() + (this.appended != null ? this.appended.size() : 0L);
    }

    @Override
    public int getChildCount(Name name) {
        return this.persisted.getChildCount(name) + (this.appended != null ? this.appended.getChildCount(name) : 0);
    }

    @Override
    public ChildReference getChild(Name name, int snsIndex, ChildReferences.Context context) {
        ChildReference ref;
        if (this.changedChildren != null) {
            context = new ChildReferences.WithChanges(context, this.changedChildren);
        }
        if ((ref = this.persisted.getChild(name, snsIndex, context)) == null && this.appended != null) {
            ref = this.appended.getChild(name, snsIndex, context);
        }
        return ref;
    }

    @Override
    public boolean hasChild(NodeKey key) {
        return this.getChild(key, new ChildReferences.BasicContext()) != null;
    }

    @Override
    public ChildReference getChild(NodeKey key) {
        return this.getChild(key, new ChildReferences.BasicContext());
    }

    @Override
    public ChildReference getChild(NodeKey key, ChildReferences.Context context) {
        int numSnsInPersisted;
        ChildReference ref;
        if (this.changedChildren != null) {
            context = new ChildReferences.WithChanges(context, this.changedChildren);
        }
        if ((ref = this.persisted.getChild(key, context)) == null && this.appended != null && (ref = this.appended.getChild(key, context)) != null && (numSnsInPersisted = this.persisted.getChildCount(ref.getName())) != 0) {
            int numSnsInRemoved = this.changedChildren != null && this.changedChildren.getRemovals().contains(key) ? 1 : 0;
            ref = ref.with(numSnsInPersisted + ref.getSnsIndex() - numSnsInRemoved);
        }
        return ref;
    }

    @Override
    public Iterator<ChildReference> iterator() {
        return this.iterator(new ChildReferences.BasicContext());
    }

    @Override
    public Iterator<ChildReference> iterator(Name name, ChildReferences.Context context) {
        if (this.changedChildren != null) {
            context = new ChildReferences.WithChanges(context, this.changedChildren);
        }
        return this.createIterator(name, context);
    }

    protected Iterator<ChildReference> createIterator(Name name, final ChildReferences.Context context) {
        UnionIterator<ChildReference> firstIter = this.persisted.iterator(name, context);
        final MutableChildReferences appended = this.appended;
        Iterable<ChildReference> second = new Iterable<ChildReference>(){

            @Override
            public Iterator<ChildReference> iterator() {
                return appended.iterator(context);
            }
        };
        return appended == null ? firstIter : new UnionIterator<ChildReference>(firstIter, second);
    }

    @Override
    public Iterator<ChildReference> iterator(ChildReferences.Context context) {
        if (this.changedChildren != null) {
            context = new ChildReferences.WithChanges(context, this.changedChildren);
        }
        return this.createIterator(context);
    }

    protected Iterator<ChildReference> createIterator(final ChildReferences.Context context) {
        UnionIterator<ChildReference> firstIter = this.persisted.iterator(context);
        final MutableChildReferences appended = this.appended;
        Iterable<ChildReference> second = new Iterable<ChildReference>(){

            @Override
            public Iterator<ChildReference> iterator() {
                return appended.iterator(context);
            }
        };
        return appended == null ? firstIter : new UnionIterator<ChildReference>(firstIter, second);
    }

    @Override
    public Iterator<NodeKey> getAllKeys() {
        UnionIterator<NodeKey> firstIter = this.persisted.getAllKeys();
        final MutableChildReferences appended = this.appended;
        Iterable<NodeKey> second = new Iterable<NodeKey>(){

            @Override
            public Iterator<NodeKey> iterator() {
                return appended.getAllKeys();
            }
        };
        return appended == null ? firstIter : new UnionIterator<NodeKey>(firstIter, second);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        Iterator<ChildReference> iter = this.iterator();
        if (iter.hasNext()) {
            sb.append(iter.next());
            while (iter.hasNext()) {
                sb.append(", ");
                sb.append(iter.next());
            }
        }
        return sb;
    }
}

