/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.model;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.jcr.query.model.JoinCondition;
import org.modeshape.jcr.query.model.JoinType;
import org.modeshape.jcr.query.model.Source;
import org.modeshape.jcr.query.model.Visitor;
import org.modeshape.jcr.query.model.Visitors;

@Immutable
public class Join
implements Source,
javax.jcr.query.qom.Join {
    private static final long serialVersionUID = 1L;
    private final Source left;
    private final Source right;
    private final JoinType type;
    private final JoinCondition joinCondition;
    private final int hc;

    public Join(Source left, JoinType type, Source right, JoinCondition joinCondition) {
        CheckArg.isNotNull((Object)left, (String)"left");
        CheckArg.isNotNull((Object)right, (String)"right");
        CheckArg.isNotNull((Object)type, (String)"type");
        CheckArg.isNotNull((Object)joinCondition, (String)"joinCondition");
        this.left = left;
        this.right = right;
        this.type = type;
        this.joinCondition = joinCondition;
        this.hc = HashCode.compute((Object[])new Object[]{this.left, this.right, this.type, this.joinCondition});
    }

    public Source getLeft() {
        return this.left;
    }

    public Source getRight() {
        return this.right;
    }

    public String getJoinType() {
        switch (this.type()) {
            case CROSS: {
                return "jcr.join.type.cross";
            }
            case INNER: {
                return "jcr.join.type.inner";
            }
            case FULL_OUTER: {
                return "jcr.join.type.full.outer";
            }
            case LEFT_OUTER: {
                return "jcr.join.type.left.outer";
            }
            case RIGHT_OUTER: {
                return "jcr.join.type.right.outer";
            }
        }
        assert (false);
        return null;
    }

    public final JoinType type() {
        return this.type;
    }

    public JoinCondition getJoinCondition() {
        return this.joinCondition;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Join) {
            Join that = (Join)obj;
            if (this.hc != that.hc) {
                return false;
            }
            if (!this.type.equals(that.type)) {
                return false;
            }
            if (!this.left.equals(that.left)) {
                return false;
            }
            if (!this.right.equals(that.right)) {
                return false;
            }
            return this.joinCondition.equals(that.joinCondition);
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

