/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.process;

import java.util.List;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.api.query.QueryCancelledException;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.model.BindVariableName;
import org.modeshape.jcr.query.model.Column;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.QueryCommand;
import org.modeshape.jcr.query.model.Visitors;
import org.modeshape.jcr.query.optimize.Optimizer;
import org.modeshape.jcr.query.optimize.RuleBasedOptimizer;
import org.modeshape.jcr.query.plan.CanonicalPlanner;
import org.modeshape.jcr.query.plan.PlanHints;
import org.modeshape.jcr.query.plan.PlanNode;
import org.modeshape.jcr.query.plan.Planner;
import org.modeshape.jcr.query.process.Processor;
import org.modeshape.jcr.query.process.QueryResultColumns;
import org.modeshape.jcr.query.process.QueryResults;

@ThreadSafe
public class QueryEngine {
    protected final Planner planner;
    protected final Optimizer optimizer;
    protected final Processor processor;

    public QueryEngine(Planner planner, Optimizer optimizer, Processor processor) {
        CheckArg.isNotNull((Object)processor, (String)"processor");
        this.planner = planner != null ? planner : new CanonicalPlanner();
        this.optimizer = optimizer != null ? optimizer : new RuleBasedOptimizer();
        this.processor = processor;
    }

    private void checkCancelled(QueryContext context) throws QueryCancelledException {
        if (context.isCancelled()) {
            throw new QueryCancelledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.modeshape.jcr.query.QueryResults execute(final QueryContext context, QueryCommand query) throws QueryCancelledException, RepositoryException {
        CheckArg.isNotNull((Object)context, (String)"context");
        CheckArg.isNotNull((Object)query, (String)"query");
        this.checkCancelled(context);
        Visitors.visitAll(query, new Visitors.AbstractVisitor(){

            @Override
            public void visit(BindVariableName obj) {
                if (!context.getVariables().keySet().contains(obj.getBindVariableName())) {
                    context.getProblems().addError(GraphI18n.missingVariableValue, new Object[]{obj.getBindVariableName()});
                }
            }
        });
        long start = System.nanoTime();
        PlanNode plan = this.planner.createPlan(context, query);
        long duration = Math.abs(System.nanoTime() - start);
        QueryResults.Statistics stats = new QueryResults.Statistics(duration);
        this.checkCancelled(context);
        QueryResultColumns resultColumns = QueryResultColumns.empty();
        if (!context.getProblems().hasErrors()) {
            start = System.nanoTime();
            PlanNode optimizedPlan = this.optimizer.optimize(context, plan);
            duration = Math.abs(System.nanoTime() - start);
            stats = stats.withOptimizationTime(duration);
            start = System.nanoTime();
            resultColumns = this.determineQueryResultColumns(optimizedPlan, context.getHints());
            duration = Math.abs(System.nanoTime() - start);
            stats = stats.withResultsFormulationTime(duration);
            if (!context.getProblems().hasErrors()) {
                this.checkCancelled(context);
                try {
                    start = System.nanoTime();
                    org.modeshape.jcr.query.QueryResults queryResults = this.processor.execute(context, query, stats, optimizedPlan);
                    return queryResults;
                }
                finally {
                    duration = Math.abs(System.nanoTime() - start);
                    stats = stats.withExecutionTime(duration);
                }
            }
        }
        this.checkCancelled(context);
        return new QueryResults((QueryResults.Columns)resultColumns, stats, context.getProblems());
    }

    protected QueryResultColumns determineQueryResultColumns(PlanNode optimizedPlan, PlanHints hints) {
        PlanNode project = optimizedPlan.findAtOrBelow(PlanNode.Traversal.LEVEL_ORDER, PlanNode.Type.PROJECT);
        if (project != null) {
            List<Column> columns = project.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
            List<String> columnTypes = project.getPropertyAsList(PlanNode.Property.PROJECT_COLUMN_TYPES, String.class);
            boolean includeFullTextSearchScores = hints.hasFullTextSearch;
            if (!includeFullTextSearchScores) {
                for (PlanNode select : optimizedPlan.findAllAtOrBelow(PlanNode.Type.SELECT)) {
                    Constraint constraint = select.getProperty(PlanNode.Property.SELECT_CRITERIA, Constraint.class);
                    if (!QueryResultColumns.includeFullTextScores(constraint)) continue;
                    includeFullTextSearchScores = true;
                    break;
                }
            }
            return new QueryResultColumns(columns, columnTypes, includeFullTextSearchScores);
        }
        return QueryResultColumns.empty();
    }
}

