/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.IoException;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.ValueFormatException;
import org.modeshape.jcr.value.basic.AbstractValueFactory;

@Immutable
public class DecimalValueFactory
extends AbstractValueFactory<BigDecimal> {
    public DecimalValueFactory(TextDecoder decoder, ValueFactories factories) {
        super(PropertyType.DECIMAL, decoder, factories);
    }

    @Override
    public ValueFactory<BigDecimal> with(ValueFactories valueFactories) {
        return this.valueFactories == valueFactories ? this : new DecimalValueFactory(super.getDecoder(), valueFactories);
    }

    @Override
    public BigDecimal create(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new BigDecimal(value.trim());
        }
        catch (NumberFormatException err) {
            throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{String.class.getSimpleName(), BigDecimal.class.getSimpleName(), value}), err);
        }
    }

    @Override
    public BigDecimal create(String value, TextDecoder decoder) {
        return this.create(this.getDecoder(decoder).decode(value.trim()));
    }

    @Override
    public BigDecimal create(int value) {
        return BigDecimal.valueOf(value);
    }

    @Override
    public BigDecimal create(long value) {
        return BigDecimal.valueOf(value);
    }

    @Override
    public BigDecimal create(boolean value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Boolean.class.getSimpleName(), value}));
    }

    @Override
    public BigDecimal create(float value) {
        return BigDecimal.valueOf(value);
    }

    @Override
    public BigDecimal create(double value) {
        return BigDecimal.valueOf(value);
    }

    @Override
    public BigDecimal create(BigDecimal value) {
        return value;
    }

    @Override
    public BigDecimal create(Calendar value) {
        if (value == null) {
            return null;
        }
        return this.create(value.getTimeInMillis());
    }

    @Override
    public BigDecimal create(Date value) {
        if (value == null) {
            return null;
        }
        return this.create(value.getTime());
    }

    @Override
    public BigDecimal create(DateTime value) throws ValueFormatException {
        if (value == null) {
            return null;
        }
        return this.create(value.getMilliseconds());
    }

    @Override
    public BigDecimal create(Name value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Name.class.getSimpleName(), value}));
    }

    @Override
    public BigDecimal create(Path value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.class.getSimpleName(), value}));
    }

    @Override
    public BigDecimal create(Path.Segment value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.Segment.class.getSimpleName(), value}));
    }

    @Override
    public BigDecimal create(Reference value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Reference.class.getSimpleName(), value}));
    }

    @Override
    public BigDecimal create(URI value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), URI.class.getSimpleName(), value}));
    }

    @Override
    public BigDecimal create(UUID value) throws IoException {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), UUID.class.getSimpleName(), value}));
    }

    @Override
    public BigDecimal create(NodeKey value) throws ValueFormatException {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), NodeKey.class.getSimpleName(), value}));
    }

    @Override
    public BigDecimal create(byte[] value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public BigDecimal create(BinaryValue value) throws ValueFormatException, IoException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public BigDecimal create(InputStream stream) throws IoException {
        return this.create(this.getStringValueFactory().create(stream));
    }

    protected BigDecimal[] createEmptyArray(int length) {
        return new BigDecimal[length];
    }
}

