/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary.infinispan;

import java.io.IOException;
import org.modeshape.common.logging.Logger;

abstract class RetryOperation {
    private final Logger logger = Logger.getLogger(this.getClass());
    private static final int RETRIES = 3;
    private static final long SLEEP_BETWEEN_RETRIES = 2000L;

    public boolean doTry() throws IOException {
        boolean sleepInterrupted = false;
        int failures = 0;
        IOException lastException = null;
        while (!sleepInterrupted && failures <= 3) {
            try {
                return this.call();
            }
            catch (IOException ex) {
                lastException = ex;
            }
            catch (Exception ex) {
                lastException = new IOException(ex);
            }
            this.logger.debug((Throwable)lastException, "Failed to execute cache operation.", new Object[0]);
            if (++failures > 3) continue;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
                sleepInterrupted = true;
                this.logger.debug("Retry interrupted. ", new Object[0]);
            }
        }
        assert (lastException != null);
        throw lastException;
    }

    protected abstract boolean call() throws IOException;
}

