/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene.basic;

import java.math.BigDecimal;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.engine.impl.LuceneOptionsImpl;
import org.modeshape.jcr.query.lucene.FieldUtil;
import org.modeshape.jcr.query.lucene.basic.DynamicField;

public class DynamicFieldBridge
implements FieldBridge {
    private static final Integer TRUE_INT = 1;
    private static final Integer FALSE_INT = 0;
    private static final LuceneOptions STORED_NOT_ANALYZED = new LuceneOptionsImpl(Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.NO, 1.0f);
    private static final LuceneOptions NOT_STORED_NOT_ANALYZED = new LuceneOptionsImpl(Store.NO, Field.Index.NOT_ANALYZED, Field.TermVector.NO, 1.0f);

    public final void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        for (DynamicField field = (DynamicField)value; field != null; field = field.getNext()) {
            this.addField(field, document, luceneOptions);
        }
    }

    protected final void addField(DynamicField field, Document document, LuceneOptions analyzedOptions) {
        boolean analyzed = field.isAnalyzed();
        boolean stored = analyzed ? field.isStored() : true;
        LuceneOptions options = analyzed ? analyzedOptions : STORED_NOT_ANALYZED;
        Object value = field.getValue();
        String name = field.getFieldName();
        if (value instanceof Object[]) {
            for (Object arrayValue : (Object[])value) {
                this.addField(options, name, arrayValue, document, stored);
            }
        } else {
            this.addField(options, name, value, document, stored);
        }
    }

    protected final void addField(LuceneOptions options, String fieldName, Object value, Document document, boolean stored) {
        if (value instanceof String) {
            options.addFieldToDocument(fieldName, (String)value, document);
            return;
        }
        LuceneOptions luceneOptions = options = stored ? STORED_NOT_ANALYZED : NOT_STORED_NOT_ANALYZED;
        if (value instanceof Boolean) {
            Boolean bValue = (Boolean)value;
            Integer iValue = bValue != false ? TRUE_INT : FALSE_INT;
            options.addNumericFieldToDocument(fieldName, (Object)iValue, document);
        } else if (value instanceof Integer) {
            options.addNumericFieldToDocument(fieldName, (Object)((Integer)value), document);
        } else if (value instanceof Long) {
            options.addNumericFieldToDocument(fieldName, value, document);
        } else if (value instanceof Float) {
            options.addNumericFieldToDocument(fieldName, (Object)((Float)value).floatValue(), document);
        } else if (value instanceof Double) {
            options.addNumericFieldToDocument(fieldName, value, document);
        } else if (value instanceof BigDecimal) {
            String strValue = FieldUtil.decimalToString((BigDecimal)value);
            options.addFieldToDocument(fieldName, strValue, document);
        } else {
            assert (value != null);
            assert (false) : "Unexpected field value of type " + value.getClass() + ": " + value;
        }
    }
}

