/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.TextExtractors;
import org.modeshape.jcr.mimetype.MimeTypeDetector;
import org.modeshape.jcr.mimetype.NullMimeTypeDetector;
import org.modeshape.jcr.text.TextExtractorContext;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.InMemoryBinaryValue;
import org.modeshape.jcr.value.binary.StoredBinaryValue;

@ThreadSafe
public abstract class AbstractBinaryStore
implements BinaryStore {
    static final long DEFAULT_MINIMUM_BINARY_SIZE_IN_BYTES = 4096L;
    private static final long DEFAULT_LATCH_WAIT_IN_SECONDS = 10L;
    private static final long LARGE_SIZE = 0x2000000L;
    private static final long MEDIUM_FILE_SIZE = 0x100000L;
    private static final long SMALL_FILE_SIZE = 32768L;
    private static final long TINY_FILE_SIZE = 1024L;
    private static final int LARGE_BUFFER_SIZE = 0x100000;
    protected static final int MEDIUM_BUFFER_SIZE = 65536;
    private static final int SMALL_BUFFER_SIZE = 4096;
    private static final int TINY_BUFFER_SIZE = 2048;
    protected Logger logger = Logger.getLogger(this.getClass());
    private final AtomicLong minBinarySizeInBytes = new AtomicLong(4096L);
    private volatile TextExtractors extractors;
    private volatile MimeTypeDetector detector = NullMimeTypeDetector.INSTANCE;

    public static int bestBufferSize(long fileSize) {
        assert (fileSize >= 0L);
        if (fileSize < 1024L) {
            return (int)fileSize + 2;
        }
        if (fileSize < 32768L) {
            return 2048;
        }
        if (fileSize < 0x100000L) {
            return 4096;
        }
        if (fileSize < 0x2000000L) {
            return 65536;
        }
        return 0x100000;
    }

    @Override
    public long getMinimumBinarySizeInBytes() {
        return this.minBinarySizeInBytes.get();
    }

    @Override
    public void setMinimumBinarySizeInBytes(long minSizeInBytes) {
        CheckArg.isNonNegative((long)minSizeInBytes, (String)"minSizeInBytes");
        this.minBinarySizeInBytes.set(minSizeInBytes);
    }

    @Override
    public void setTextExtractors(TextExtractors textExtractors) {
        CheckArg.isNotNull((Object)textExtractors, (String)"textExtractors");
        this.extractors = textExtractors;
    }

    @Override
    public void setMimeTypeDetector(MimeTypeDetector mimeTypeDetector) {
        this.detector = mimeTypeDetector != null ? mimeTypeDetector : NullMimeTypeDetector.INSTANCE;
    }

    @Override
    public final String getText(BinaryValue binary) throws BinaryStoreException {
        String extractedText;
        if (binary instanceof StoredBinaryValue && (extractedText = this.getExtractedText(binary)) != null) {
            return extractedText;
        }
        if (this.extractors == null || !this.extractors.extractionEnabled()) {
            return null;
        }
        if (binary instanceof InMemoryBinaryValue) {
            return this.extractors.extract((InMemoryBinaryValue)binary, new TextExtractorContext(this.detector()));
        }
        try {
            CountDownLatch latch = this.extractors.getWorkerLatch(binary.getKey(), false);
            if (latch == null) {
                latch = this.extractors.extract(this, binary, new TextExtractorContext(this.detector()));
            }
            if (latch != null && latch.await(10L, TimeUnit.SECONDS)) {
                return this.getExtractedText(binary);
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new BinaryStoreException(e);
        }
    }

    @Override
    public String getMimeType(BinaryValue binary, String name) throws IOException, BinaryStoreException, RepositoryException {
        String storedMimeType;
        if (binary instanceof StoredBinaryValue && !StringUtil.isBlank((String)(storedMimeType = this.getStoredMimeType(binary)))) {
            return storedMimeType;
        }
        if (this.detector == null) {
            return null;
        }
        String detectedMimeType = this.detector().mimeTypeOf(name, (Binary)binary);
        if (binary instanceof InMemoryBinaryValue) {
            return detectedMimeType;
        }
        if (!StringUtil.isBlank((String)detectedMimeType)) {
            this.storeMimeType(binary, detectedMimeType);
        }
        return detectedMimeType;
    }

    protected abstract String getStoredMimeType(BinaryValue var1) throws BinaryStoreException;

    protected abstract void storeMimeType(BinaryValue var1, String var2) throws BinaryStoreException;

    public abstract void storeExtractedText(BinaryValue var1, String var2) throws BinaryStoreException;

    public abstract String getExtractedText(BinaryValue var1) throws BinaryStoreException;

    protected final TextExtractors extractors() {
        return this.extractors;
    }

    protected final MimeTypeDetector detector() {
        return this.detector;
    }

    public void start() {
    }

    public void shutdown() {
    }
}

