/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;

public class AllPathsCache {
    protected final NodeCache cache;
    protected final NodeCache removedCache;
    private final Map<NodeKey, List<Path>> paths = new HashMap<NodeKey, List<Path>>();
    protected final PathFactory pathFactory;

    public AllPathsCache(NodeCache cache, NodeCache removedCache, ExecutionContext context) {
        this.cache = cache;
        this.removedCache = removedCache;
        this.pathFactory = context.getValueFactories().getPathFactory();
    }

    public NodeCache getCache() {
        return this.cache;
    }

    public Iterable<Path> getPaths(CachedNode node) {
        NodeKey key = node.getKey();
        List<Path> pathList = this.paths.get(key);
        if (pathList == null) {
            Path.Segment nodeSegment = node.getSegment(this.cache);
            NodeKey parentKey = node.getParentKey(this.cache);
            if (parentKey == null) {
                pathList = Collections.singletonList(node.getPath(this.cache));
            } else {
                CachedNode parent = this.cache.getNode(parentKey);
                if (parent == null && this.removedCache != null) {
                    parent = this.removedCache.getNode(parentKey);
                }
                pathList = new LinkedList<Path>();
                for (Path parentPath : this.getPaths(parent)) {
                    Path path = this.pathFactory.create(parentPath, nodeSegment);
                    pathList.add(path);
                }
                Set<NodeKey> additionalParentKeys = this.getAdditionalParentKeys(node, this.cache);
                for (NodeKey additionalParentKey : additionalParentKeys) {
                    parent = this.cache.getNode(additionalParentKey);
                    for (Path parentPath : this.getPaths(parent)) {
                        Path path = this.pathFactory.create(parentPath, nodeSegment);
                        pathList.add(path);
                    }
                }
            }
            assert (pathList != null);
            pathList = Collections.unmodifiableList(pathList);
            this.paths.put(key, pathList);
        }
        return pathList;
    }

    public boolean removePath(NodeKey key) {
        return this.paths.remove(key) != null;
    }

    protected Set<NodeKey> getAdditionalParentKeys(CachedNode node, NodeCache cache) {
        return node.getAdditionalParentKeys(cache);
    }
}

