/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.cache.document.TransactionalWorkspaceCache;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.txn.Transactions;

public class TransactionalWorkspaceCaches {
    private TransactionManager txnMgr;
    private Map<Transaction, Map<String, TransactionalWorkspaceCache>> transactionalCachesByTransaction = new HashMap<Transaction, Map<String, TransactionalWorkspaceCache>>();

    public TransactionalWorkspaceCaches(Transactions transactions) {
        this.txnMgr = transactions != null ? transactions.getTransactionManager() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkspaceCache getTransactionalWorkspaceCache(WorkspaceCache sharedWorkspaceCache) throws SystemException, RollbackException {
        if (this.txnMgr == null) {
            return sharedWorkspaceCache;
        }
        Transaction txn = this.txnMgr.getTransaction();
        if (txn == null || txn.getStatus() != 0) {
            return sharedWorkspaceCache;
        }
        TransactionalWorkspaceCaches transactionalWorkspaceCaches = this;
        synchronized (transactionalWorkspaceCaches) {
            String workspaceName = sharedWorkspaceCache.getWorkspaceName();
            Map<String, TransactionalWorkspaceCache> workspaceCachesForTransaction = this.transactionalCachesByTransaction.get(txn);
            if (workspaceCachesForTransaction == null) {
                workspaceCachesForTransaction = new HashMap<String, TransactionalWorkspaceCache>();
                this.transactionalCachesByTransaction.put(txn, workspaceCachesForTransaction);
                TransactionalWorkspaceCache newCache = this.createCache(sharedWorkspaceCache, txn);
                workspaceCachesForTransaction.put(workspaceName, newCache);
                return newCache;
            }
            TransactionalWorkspaceCache cache = workspaceCachesForTransaction.get(workspaceName);
            if (cache != null) {
                return cache;
            }
            cache = this.createCache(sharedWorkspaceCache, txn);
            workspaceCachesForTransaction.put(workspaceName, cache);
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(String workspaceName) {
        if (this.txnMgr == null) {
            return;
        }
        HashSet<Transaction> transactions = new HashSet<Transaction>();
        TransactionalWorkspaceCaches transactionalWorkspaceCaches = this;
        synchronized (transactionalWorkspaceCaches) {
            for (Map.Entry<Transaction, Map<String, TransactionalWorkspaceCache>> entry : this.transactionalCachesByTransaction.entrySet()) {
                if (!entry.getValue().containsKey(workspaceName)) continue;
                transactions.add(entry.getKey());
            }
        }
        for (Transaction transaction : transactions) {
            try {
                transaction.rollback();
            }
            catch (SystemException e) {
                Logger.getLogger(this.getClass()).error((I18nResource)JcrI18n.errorWhileRollingBackActiveTransactionUsingWorkspaceThatIsBeingDeleted, new Object[]{workspaceName, e.getMessage()});
            }
        }
    }

    protected synchronized void remove(Transaction txn) {
        this.transactionalCachesByTransaction.remove(txn);
    }

    synchronized void onAllWorkspacesInTransaction(Transaction txn, OnEachTransactionalCache operation) {
        assert (operation != null);
        assert (txn != null);
        Map<String, TransactionalWorkspaceCache> cachesForTxn = this.transactionalCachesByTransaction.get(txn);
        if (cachesForTxn != null) {
            for (TransactionalWorkspaceCache cache : cachesForTxn.values()) {
                if (cache == null) continue;
                operation.execute(cache);
            }
        }
    }

    protected TransactionalWorkspaceCache createCache(WorkspaceCache sharedWorkspaceCache, final Transaction txn) throws SystemException, RollbackException {
        TransactionalWorkspaceCache cache = new TransactionalWorkspaceCache(sharedWorkspaceCache, this, txn);
        txn.registerSynchronization(new Synchronization(){

            public void beforeCompletion() {
            }

            public void afterCompletion(int status) {
                TransactionalWorkspaceCaches.this.remove(txn);
            }
        });
        return cache;
    }

    static interface OnEachTransactionalCache {
        public void execute(TransactionalWorkspaceCache var1);
    }
}

