/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.model;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.Visitor;
import org.modeshape.jcr.query.model.Visitors;

@Immutable
public class DescendantNode
implements Constraint,
javax.jcr.query.qom.DescendantNode {
    private static final long serialVersionUID = 1L;
    private final SelectorName selectorName;
    private final String ancestorPath;

    public DescendantNode(SelectorName selectorName, String ancestorPath) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotNull((Object)ancestorPath, (String)"ancestorPath");
        this.selectorName = selectorName;
        this.ancestorPath = ancestorPath;
    }

    public final SelectorName selectorName() {
        return this.selectorName;
    }

    public String getSelectorName() {
        return this.selectorName.getString();
    }

    public final String getAncestorPath() {
        return this.ancestorPath;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.selectorName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DescendantNode) {
            DescendantNode that = (DescendantNode)obj;
            if (!this.selectorName.equals(that.selectorName)) {
                return false;
            }
            return this.ancestorPath.equals(that.ancestorPath);
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

