/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.IoException;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.ValueFormatException;
import org.modeshape.jcr.value.basic.AbstractValueFactory;

@Immutable
public class LongValueFactory
extends AbstractValueFactory<Long> {
    public LongValueFactory(TextDecoder decoder, ValueFactories factories) {
        super(PropertyType.LONG, decoder, factories);
    }

    @Override
    public ValueFactory<Long> with(ValueFactories valueFactories) {
        return this.valueFactories == valueFactories ? this : new LongValueFactory(super.getDecoder(), valueFactories);
    }

    @Override
    public Long create(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Long.valueOf(value.trim());
        }
        catch (NumberFormatException err) {
            throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{String.class.getSimpleName(), Long.class.getSimpleName(), value}), err);
        }
    }

    @Override
    public Long create(String value, TextDecoder decoder) {
        return this.create(this.getDecoder(decoder).decode(value));
    }

    @Override
    public Long create(int value) {
        return value;
    }

    @Override
    public Long create(long value) {
        return value;
    }

    @Override
    public Long create(boolean value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Long.class.getSimpleName(), value}));
    }

    @Override
    public Long create(float value) {
        return (long)value;
    }

    @Override
    public Long create(double value) {
        return (long)value;
    }

    @Override
    public Long create(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.longValue();
    }

    @Override
    public Long create(Calendar value) {
        if (value == null) {
            return null;
        }
        return value.getTimeInMillis();
    }

    @Override
    public Long create(Date value) {
        if (value == null) {
            return null;
        }
        return value.getTime();
    }

    @Override
    public Long create(DateTime value) throws ValueFormatException {
        if (value == null) {
            return null;
        }
        return value.getMilliseconds();
    }

    @Override
    public Long create(Name value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Name.class.getSimpleName(), value}));
    }

    @Override
    public Long create(Path value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.class.getSimpleName(), value}));
    }

    @Override
    public Long create(Path.Segment value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.Segment.class.getSimpleName(), value}));
    }

    @Override
    public Long create(Reference value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Reference.class.getSimpleName(), value}));
    }

    @Override
    public Long create(URI value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), URI.class.getSimpleName(), value}));
    }

    @Override
    public Long create(UUID value) throws IoException {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), UUID.class.getSimpleName(), value}));
    }

    @Override
    public Long create(NodeKey value) throws ValueFormatException {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), NodeKey.class.getSimpleName(), value}));
    }

    @Override
    public Long create(byte[] value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Long create(BinaryValue value) throws ValueFormatException, IoException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Long create(InputStream stream) throws IoException {
        return this.create(this.getStringValueFactory().create(stream));
    }

    protected Long[] createEmptyArray(int length) {
        return new Long[length];
    }
}

