/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jcr.RepositoryException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.infinispan.schematic.document.ParsingException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.NoSuchRepositoryException;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.api.NamedRepository;
import org.modeshape.jcr.api.Repositories;
import org.modeshape.jcr.api.RepositoriesContainer;

@ThreadSafe
public final class JcrRepositoriesContainer
implements RepositoriesContainer {
    protected static final Logger LOG = Logger.getLogger(JcrRepositoriesContainer.class);
    protected static final String REPOSITORY_NAME_URL_PARAM = "repositoryName";
    protected static final String FILE_PROTOCOL = "file";
    protected static final String JNDI_PROTOCOL = "jndi";
    protected static final ModeShapeEngine ENGINE = new ModeShapeEngine();

    public JcrRepository getRepository(String repositoryName, Map parameters) throws RepositoryException {
        String protocol;
        URL repositoryURL;
        if (!StringUtil.isBlank((String)repositoryName)) {
            try {
                JcrRepository repository = this.engine().getRepository(repositoryName);
                if (repository.getState() == ModeShapeEngine.State.STARTING || repository.getState() == ModeShapeEngine.State.RUNNING) {
                    return repository;
                }
            }
            catch (NoSuchRepositoryException e) {
                // empty catch block
            }
        }
        if ((repositoryURL = this.repositoryURLFromParams(parameters)) == null) {
            return null;
        }
        HashMap<String, String> configParams = parameters;
        if (!StringUtil.isBlank((String)repositoryName)) {
            configParams = new HashMap<String, String>(parameters);
            configParams.put("org.modeshape.jcr.RepositoryName", repositoryName);
        }
        if (JNDI_PROTOCOL.equalsIgnoreCase(protocol = repositoryURL.getProtocol())) {
            return new JNDIRepositoryLookup().repository(configParams, repositoryURL);
        }
        return new FileRepositoryLookup().repository(configParams, repositoryURL);
    }

    public Set<String> getRepositoryNames(Map<?, ?> parameters) throws RepositoryException {
        Set<String> repositoryNames = this.engine().getRepositoryNames();
        URL repositoryURL = this.repositoryURLFromParams(parameters);
        if (repositoryURL == null) {
            return repositoryNames;
        }
        String protocol = repositoryURL.getProtocol();
        if (JNDI_PROTOCOL.equalsIgnoreCase(protocol)) {
            Set<String> jndiRepositories = new JNDIRepositoryLookup().repositoryNames(parameters, repositoryURL);
            repositoryNames.addAll(jndiRepositories);
        } else {
            JcrRepository repository = new FileRepositoryLookup().repository(parameters, repositoryURL);
            if (repository != null) {
                repositoryNames.add(repository.getName());
            }
        }
        return repositoryNames;
    }

    public Future<Boolean> shutdown() {
        return ENGINE.shutdown();
    }

    public boolean shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            return ENGINE.shutdown().get(timeout, unit);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e, (I18nResource)JcrI18n.errorShuttingDownJcrRepositoryFactory, new Object[0]);
            return false;
        }
        catch (TimeoutException e) {
            LOG.warn((Throwable)e, (I18nResource)JcrI18n.timeoutWhileShuttingRepositoryDown, new Object[0]);
            return false;
        }
    }

    protected ModeShapeEngine engine() {
        switch (ENGINE.getState()) {
            case NOT_RUNNING: {
                ENGINE.start();
                break;
            }
            case STOPPING: {
                try {
                    ENGINE.shutdown().get(10L, TimeUnit.SECONDS);
                }
                catch (Exception exception) {}
                break;
            }
        }
        return ENGINE;
    }

    private URL repositoryURLFromParams(Map<?, ?> parameters) {
        if (parameters == null) {
            LOG.debug("The supplied parameters are null", new Object[0]);
            return null;
        }
        Object rawUrl = parameters.get("org.modeshape.jcr.URL");
        if (rawUrl == null) {
            LOG.debug("No parameter found with key: org.modeshape.jcr.URL", new Object[0]);
            return null;
        }
        URL url = null;
        if (rawUrl instanceof URL) {
            url = (URL)rawUrl;
        } else {
            try {
                url = new URL(rawUrl.toString());
            }
            catch (MalformedURLException e) {
                LOG.warn((Throwable)e, (I18nResource)JcrI18n.invalidUrl, new Object[]{rawUrl});
                return null;
            }
        }
        return url;
    }

    protected String repositoryNameFrom(URL url, Map<?, ?> parameters) {
        Object repoName = parameters.get("org.modeshape.jcr.RepositoryName");
        if (repoName != null) {
            return repoName.toString();
        }
        String query = url.getQuery();
        if (query != null) {
            for (String keyValuePair : query.split("&")) {
                String[] splitPair = keyValuePair.split("=");
                if (splitPair.length != 2 || !REPOSITORY_NAME_URL_PARAM.equals(splitPair[0])) continue;
                return splitPair[1];
            }
        }
        return null;
    }

    protected class JNDIRepositoryLookup {
        protected JNDIRepositoryLookup() {
        }

        private Object doJNDILookup(String jndiName, Map<?, ?> parameters) throws RepositoryException {
            if (jndiName == null) {
                return null;
            }
            try {
                InitialContext ic = new InitialContext(this.hashtable(parameters));
                return ic.lookup(jndiName);
            }
            catch (NamingException e) {
                throw new RepositoryException((Throwable)e);
            }
        }

        protected JcrRepository repository(Map<?, ?> parameters, URL repositoryURL) throws RepositoryException {
            String jndiName = repositoryURL.getPath();
            String repositoryName = JcrRepositoriesContainer.this.repositoryNameFrom(repositoryURL, parameters);
            Object jndiObject = this.doJNDILookup(jndiName, parameters);
            if (jndiObject instanceof ModeShapeEngine) {
                return this.repositoryFromEngine((ModeShapeEngine)jndiObject, jndiName, repositoryName);
            }
            if (jndiObject instanceof JcrRepository) {
                return (JcrRepository)jndiObject;
            }
            return null;
        }

        protected Set<String> repositoryNames(Map<?, ?> parameters, URL repositoryURL) throws RepositoryException {
            String jndiName = repositoryURL.getPath();
            Object jndiObject = this.doJNDILookup(jndiName, parameters);
            if (jndiObject instanceof NamedRepository) {
                return Collections.singleton(((NamedRepository)jndiObject).getName());
            }
            if (jndiObject instanceof Repositories) {
                return ((Repositories)jndiObject).getRepositoryNames();
            }
            return Collections.emptySet();
        }

        private JcrRepository repositoryFromEngine(ModeShapeEngine engine, String jndiName, String repositoryName) {
            switch (engine.getState()) {
                case NOT_RUNNING: 
                case STOPPING: {
                    LOG.error((I18nResource)JcrI18n.engineAtJndiLocationIsNotRunning, new Object[]{jndiName});
                    return null;
                }
            }
            if (repositoryName == null && engine.getRepositories().size() == 1) {
                repositoryName = engine.getRepositories().keySet().iterator().next();
            }
            if (StringUtil.isBlank((String)repositoryName)) {
                return null;
            }
            if (repositoryName != null) {
                repositoryName = repositoryName.trim();
            }
            try {
                JcrRepository repository = engine.getRepository(repositoryName);
                switch (repository.getState()) {
                    case RUNNING: 
                    case STARTING: {
                        return repository;
                    }
                }
                LOG.debug("The '{0}' repository in JNDI at '{1}' is not (yet) running, but may be (re)started when needed.", new Object[]{repositoryName, jndiName});
                return repository;
            }
            catch (NoSuchRepositoryException e) {
                LOG.warn((I18nResource)JcrI18n.repositoryNotFoundInEngineAtJndiLocation, new Object[]{repositoryName, jndiName});
                return null;
            }
        }

        private Hashtable<String, String> hashtable(Map<?, ?> map) {
            if (map == null) {
                return new Hashtable<String, String>();
            }
            Hashtable<String, String> hash = new Hashtable<String, String>(map.size());
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                Object value = entry.getValue();
                hash.put(entry.getKey().toString(), value != null ? value.toString() : null);
            }
            return hash;
        }
    }

    protected class FileRepositoryLookup {
        protected FileRepositoryLookup() {
        }

        protected JcrRepository repository(Map<?, ?> parameters, URL repositoryURL) throws RepositoryException {
            String repositoryName = JcrRepositoriesContainer.this.repositoryNameFrom(repositoryURL, parameters);
            JcrRepository repository = this.lookForAlreadyDeployedRepositoryKey((repositoryURL = this.postProcessRepositoryURL(repositoryURL)).toString());
            if (repository != null) {
                return repository;
            }
            RepositoryConfiguration configuration = this.loadRepositoryConfigurationFrom(repositoryURL);
            repository = this.lookForAlreadyDeployedRepositoryName(configuration.getName());
            if (repository != null) {
                return StringUtil.isBlank((String)repositoryName) || configuration.getName().equalsIgnoreCase(repositoryName) ? repository : null;
            }
            try {
                repository = ENGINE.deploy(configuration);
                repository.start();
                if (StringUtil.isBlank((String)repositoryName) || repository.getName().equals(repositoryName)) {
                    return repository;
                }
                LOG.warn((I18nResource)JcrI18n.repositoryNotFound, new Object[]{repositoryName, repositoryURL, parameters});
                return null;
            }
            catch (RepositoryException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }

        private JcrRepository lookForAlreadyDeployedRepositoryKey(String key) {
            if (JcrRepositoriesContainer.this.engine().getRepositoryKeys().contains(key)) {
                try {
                    return JcrRepositoriesContainer.this.engine().getRepository(key);
                }
                catch (NoSuchRepositoryException noSuchRepositoryException) {
                    // empty catch block
                }
            }
            return null;
        }

        private JcrRepository lookForAlreadyDeployedRepositoryName(String name) {
            if (JcrRepositoriesContainer.this.engine().getRepositoryNames().contains(name)) {
                try {
                    return JcrRepositoriesContainer.this.engine().getRepository(name);
                }
                catch (NoSuchRepositoryException noSuchRepositoryException) {
                    // empty catch block
                }
            }
            return null;
        }

        private URL postProcessRepositoryURL(URL repositoryURL) {
            if (JcrRepositoriesContainer.FILE_PROTOCOL.equalsIgnoreCase(repositoryURL.getProtocol())) {
                try {
                    return new URL(repositoryURL.getProtocol(), repositoryURL.getHost(), repositoryURL.getPort(), repositoryURL.getPath());
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return repositoryURL;
        }

        private RepositoryConfiguration loadRepositoryConfigurationFrom(URL repositoryURL) throws RepositoryException {
            try {
                if (JcrRepositoriesContainer.FILE_PROTOCOL.equalsIgnoreCase(repositoryURL.getProtocol())) {
                    try {
                        return RepositoryConfiguration.read(repositoryURL);
                    }
                    catch (ParsingException pe) {
                        String path = this.classpathResource(repositoryURL);
                        return RepositoryConfiguration.read(path);
                    }
                }
                return RepositoryConfiguration.read(repositoryURL);
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }

        private String classpathResource(URL url) {
            String path = url.getPath();
            while (path.startsWith("/") && path.length() > 1) {
                path = path.substring(1);
            }
            return path.length() != 0 ? path : null;
        }
    }
}

