/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache;

import java.util.Collections;
import java.util.Set;
import org.modeshape.jcr.cache.NodeKey;

public class ReferentialIntegrityException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final Set<NodeKey> referrers;
    private final Set<NodeKey> removedNodes;

    public ReferentialIntegrityException(Set<NodeKey> removedNodes, Set<NodeKey> referrers) {
        this.referrers = Collections.unmodifiableSet(referrers);
        this.removedNodes = Collections.unmodifiableSet(removedNodes);
        assert (this.removedNodes != null);
        assert (this.referrers != null);
        assert (!this.referrers.isEmpty());
        assert (!this.removedNodes.isEmpty());
    }

    public Set<NodeKey> getReferrers() {
        return this.referrers;
    }

    public Set<NodeKey> getRemovedNodes() {
        return this.removedNodes;
    }
}

