/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.nodetype.ItemDefinition;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.api.Namespaced;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.Name;

@Immutable
abstract class JcrItemDefinition
implements ItemDefinition,
Namespaced {
    protected final ExecutionContext context;
    protected final JcrNodeType declaringNodeType;
    protected final Name name;
    private final int onParentVersion;
    private final boolean autoCreated;
    private final boolean mandatory;
    private final boolean protectedItem;

    JcrItemDefinition(ExecutionContext context, JcrNodeType declaringNodeType, Name name, int onParentVersion, boolean autoCreated, boolean mandatory, boolean protectedItem) {
        this.context = context;
        this.declaringNodeType = declaringNodeType;
        this.name = name != null ? name : (Name)context.getValueFactories().getNameFactory().create("*");
        this.onParentVersion = onParentVersion;
        this.autoCreated = autoCreated;
        this.mandatory = mandatory;
        this.protectedItem = protectedItem;
    }

    abstract NodeKey key();

    final Name getInternalName() {
        return this.name;
    }

    public String getLocalName() {
        return this.name.getLocalName();
    }

    public String getNamespaceURI() {
        return this.name.getNamespaceUri();
    }

    public boolean isResidual() {
        return this.name.getLocalName().equals("*");
    }

    public JcrNodeType getDeclaringNodeType() {
        return this.declaringNodeType;
    }

    public String getName() {
        if (this.name == null) {
            return "*";
        }
        return this.name.getString(this.context.getNamespaceRegistry());
    }

    public int getOnParentVersion() {
        return this.onParentVersion;
    }

    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isProtected() {
        return this.protectedItem;
    }
}

