/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrItemDefinitionTemplate;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;

class JcrPropertyDefinitionTemplate
extends JcrItemDefinitionTemplate
implements PropertyDefinitionTemplate {
    private boolean multiple = false;
    private Value[] defaultValues = null;
    private int requiredType = 1;
    private String[] valueConstraints = null;
    private boolean fullTextSearchable = true;
    private boolean queryOrderable = true;
    private String[] availableQueryOperators;

    JcrPropertyDefinitionTemplate(ExecutionContext context) {
        super(context);
    }

    JcrPropertyDefinitionTemplate(JcrPropertyDefinitionTemplate original, ExecutionContext context) {
        super(original, context);
        this.multiple = original.multiple;
        this.requiredType = original.requiredType;
        this.valueConstraints = original.valueConstraints;
        this.fullTextSearchable = original.fullTextSearchable;
        this.queryOrderable = original.queryOrderable;
        this.availableQueryOperators = original.availableQueryOperators;
        Value[] valueArray = this.defaultValues = original.defaultValues != null ? new Value[original.defaultValues.length] : null;
        if (original.defaultValues != null) {
            block4: for (int i = 0; i != original.defaultValues.length; ++i) {
                Value originalValue = original.defaultValues[i];
                assert (originalValue instanceof JcrValue);
                JcrValue jcrValue = (JcrValue)originalValue;
                this.defaultValues[i] = new JcrValue(jcrValue.factories(), jcrValue.getType(), jcrValue.value());
                switch (jcrValue.getType()) {
                    case 7: {
                        Name nameValue = (Name)original.getContext().getValueFactories().getNameFactory().create(jcrValue.value());
                        JcrItemDefinitionTemplate.registerMissingNamespaces(original.getContext(), context, nameValue);
                        continue block4;
                    }
                    case 8: {
                        Path pathValue = (Path)original.getContext().getValueFactories().getPathFactory().create(jcrValue.value());
                        JcrItemDefinitionTemplate.registerMissingNamespaces(original.getContext(), context, pathValue);
                    }
                }
            }
        }
    }

    JcrPropertyDefinitionTemplate with(ExecutionContext context) {
        return context == super.getContext() ? this : new JcrPropertyDefinitionTemplate(this, context);
    }

    public void setDefaultValues(Value[] defaultValues) {
        this.defaultValues = defaultValues;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public void setRequiredType(int requiredType) {
        assert (requiredType == 2 || requiredType == 6 || requiredType == 5 || requiredType == 4 || requiredType == 12 || requiredType == 3 || requiredType == 7 || requiredType == 8 || requiredType == 9 || requiredType == 10 || requiredType == 11 || requiredType == 1 || requiredType == 0 || requiredType == 100);
        this.requiredType = requiredType;
    }

    public void setValueConstraints(String[] constraints) {
        this.valueConstraints = constraints;
    }

    public Value[] getDefaultValues() {
        return this.defaultValues;
    }

    public int getRequiredType() {
        return this.requiredType;
    }

    public String[] getValueConstraints() {
        return this.valueConstraints;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public boolean isFullTextSearchable() {
        return this.fullTextSearchable;
    }

    public void setFullTextSearchable(boolean fullTextSearchable) {
        this.fullTextSearchable = fullTextSearchable;
    }

    public String[] getAvailableQueryOperators() {
        return this.availableQueryOperators;
    }

    public void setAvailableQueryOperators(String[] queryOperators) {
        this.availableQueryOperators = queryOperators;
    }

    public boolean isQueryOrderable() {
        return this.queryOrderable;
    }

    public void setQueryOrderable(boolean queryOrderable) {
        this.queryOrderable = queryOrderable;
    }

    @Override
    public void setName(String name) throws ConstraintViolationException {
        super.setName(name);
    }

    @Override
    public void setAutoCreated(boolean autoCreated) {
        super.setAutoCreated(autoCreated);
    }

    @Override
    public void setMandatory(boolean mandatory) {
        super.setMandatory(mandatory);
    }

    @Override
    public void setOnParentVersion(int onParentVersion) {
        super.setOnParentVersion(onParentVersion);
    }

    @Override
    public void setProtected(boolean isProtected) {
        super.setProtected(isProtected);
    }
}

