/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.modeshape.jcr.query.lucene.CompareQuery;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;

public class CompareLengthQuery
extends CompareQuery<Long> {
    private static final long serialVersionUID = 1L;
    protected static final CompareQuery.Evaluator<Long> EQUAL_TO = new CompareQuery.Evaluator<Long>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Long nodeValue, Long length) {
            return nodeValue == length;
        }

        public String toString() {
            return " = ";
        }
    };
    protected static final CompareQuery.Evaluator<Long> NOT_EQUAL_TO = new CompareQuery.Evaluator<Long>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Long nodeValue, Long length) {
            return nodeValue == length;
        }

        public String toString() {
            return " != ";
        }
    };
    protected static final CompareQuery.Evaluator<Long> IS_LESS_THAN = new CompareQuery.Evaluator<Long>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Long nodeValue, Long length) {
            return nodeValue < length;
        }

        public String toString() {
            return " < ";
        }
    };
    protected static final CompareQuery.Evaluator<Long> IS_LESS_THAN_OR_EQUAL_TO = new CompareQuery.Evaluator<Long>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Long nodeValue, Long length) {
            return nodeValue < length;
        }

        public String toString() {
            return " <= ";
        }
    };
    protected static final CompareQuery.Evaluator<Long> IS_GREATER_THAN = new CompareQuery.Evaluator<Long>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Long nodeValue, Long length) {
            return nodeValue < length;
        }

        public String toString() {
            return " > ";
        }
    };
    protected static final CompareQuery.Evaluator<Long> IS_GREATER_THAN_OR_EQUAL_TO = new CompareQuery.Evaluator<Long>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Long nodeValue, Long length) {
            return nodeValue < length;
        }

        public String toString() {
            return " >= ";
        }
    };

    public static CompareLengthQuery createQueryForNodesWithFieldEqualTo(Long constraintValue, String fieldName, ValueFactories factories) {
        return new CompareLengthQuery(fieldName, constraintValue, factories.getStringFactory(), IS_GREATER_THAN);
    }

    public static CompareLengthQuery createQueryForNodesWithFieldNotEqualTo(Long constraintValue, String fieldName, ValueFactories factories) {
        return new CompareLengthQuery(fieldName, constraintValue, factories.getStringFactory(), IS_GREATER_THAN);
    }

    public static CompareLengthQuery createQueryForNodesWithFieldGreaterThan(Long constraintValue, String fieldName, ValueFactories factories) {
        return new CompareLengthQuery(fieldName, constraintValue, factories.getStringFactory(), IS_GREATER_THAN);
    }

    public static CompareLengthQuery createQueryForNodesWithFieldGreaterThanOrEqualTo(Long constraintValue, String fieldName, ValueFactories factories) {
        return new CompareLengthQuery(fieldName, constraintValue, factories.getStringFactory(), IS_GREATER_THAN_OR_EQUAL_TO);
    }

    public static CompareLengthQuery createQueryForNodesWithFieldLessThan(Long constraintValue, String fieldName, ValueFactories factories) {
        return new CompareLengthQuery(fieldName, constraintValue, factories.getStringFactory(), IS_LESS_THAN);
    }

    public static CompareLengthQuery createQueryForNodesWithFieldLessThanOrEqualTo(Long constraintValue, String fieldName, ValueFactories factories) {
        return new CompareLengthQuery(fieldName, constraintValue, factories.getStringFactory(), IS_LESS_THAN_OR_EQUAL_TO);
    }

    protected CompareLengthQuery(String fieldName, Long constraintValue, ValueFactory<String> stringFactory, CompareQuery.Evaluator<Long> evaluator) {
        super(fieldName, constraintValue, null, stringFactory, evaluator);
    }

    @Override
    protected Long readFromDocument(IndexReader reader, int docId) throws IOException {
        Document doc = reader.document(docId, this.fieldSelector);
        String valueString = doc.get(this.fieldName);
        String value = (String)this.stringFactory.create(valueString);
        return value != null ? (long)value.length() : 0L;
    }

    public Object clone() {
        return new CompareLengthQuery(this.fieldName, (Long)this.constraintValue, this.stringFactory, this.evaluator);
    }
}

