/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.optimize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.ArrayListMultimap;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.model.Between;
import org.modeshape.jcr.query.model.BindVariableName;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.DynamicOperand;
import org.modeshape.jcr.query.model.Literal;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.StaticOperand;
import org.modeshape.jcr.query.model.Visitor;
import org.modeshape.jcr.query.optimize.OptimizerRule;
import org.modeshape.jcr.query.optimize.PushSelectCriteria;
import org.modeshape.jcr.query.optimize.RemoveEmptyAccessNodes;
import org.modeshape.jcr.query.plan.PlanNode;
import org.modeshape.jcr.value.ValueComparators;

@Immutable
public class RewriteAsRangeCriteria
implements OptimizerRule {
    protected static final Constraint CONFLICTING_CONSTRAINT = new Constraint(){
        private static final long serialVersionUID = 1L;

        @Override
        public void accept(Visitor visitor) {
            throw new UnsupportedOperationException();
        }
    };
    public static final RewriteAsRangeCriteria INSTANCE = new RewriteAsRangeCriteria();

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        boolean rewritten = false;
        boolean foundNoResults = false;
        block0: for (PlanNode access : plan.findAllAtOrBelow(PlanNode.Type.ACCESS)) {
            ArrayListMultimap selectNodeByOperand = ArrayListMultimap.create();
            for (PlanNode select : access.findAllAtOrBelow(PlanNode.Type.SELECT)) {
                Comparison comparison;
                Constraint constraint = select.getProperty(PlanNode.Property.SELECT_CRITERIA, Constraint.class);
                if (!(constraint instanceof Comparison) || !(comparison = (Comparison)constraint).operator().isRangeOperator()) continue;
                selectNodeByOperand.put((Object)comparison.getOperand1(), (Object)select);
            }
            if (selectNodeByOperand.isEmpty()) continue;
            for (DynamicOperand operand : selectNodeByOperand.keySet()) {
                Collection nodes = selectNodeByOperand.get((Object)operand);
                if (nodes.size() <= 1) continue;
                ArrayList<Comparison> rangeConstraints = new ArrayList<Comparison>(nodes.size());
                ArrayList<PlanNode> selectNodes = new ArrayList<PlanNode>(nodes.size());
                Set<SelectorName> selectors = null;
                for (PlanNode select : nodes) {
                    selectNodes.add(select);
                    Comparison constraint = select.getProperty(PlanNode.Property.SELECT_CRITERIA, Comparison.class);
                    rangeConstraints.add(constraint);
                    if (selectors == null) {
                        selectors = select.getSelectors();
                        continue;
                    }
                    assert (selectors.equals(select.getSelectors()));
                }
                Constraint merged = this.rewrite(context, rangeConstraints);
                if (merged == CONFLICTING_CONSTRAINT) {
                    access.setProperty(PlanNode.Property.ACCESS_NO_RESULTS, Boolean.TRUE);
                    foundNoResults = true;
                    continue block0;
                }
                if (merged != null) {
                    PlanNode newSelect = new PlanNode(PlanNode.Type.SELECT);
                    newSelect.getSelectors().addAll(selectors);
                    newSelect.setProperty(PlanNode.Property.SELECT_CRITERIA, merged);
                    assert (access.getChildCount() == 1);
                    access.getFirstChild().insertAsParent(newSelect);
                    rewritten = true;
                }
                Iterator nodeIter = selectNodes.iterator();
                Iterator constraintIter = rangeConstraints.iterator();
                while (nodeIter.hasNext()) {
                    assert (constraintIter.hasNext());
                    PlanNode node = (PlanNode)nodeIter.next();
                    Comparison comparison = (Comparison)constraintIter.next();
                    if (comparison != null) continue;
                    node.extractFromParent();
                    nodeIter.remove();
                }
                assert (!constraintIter.hasNext());
            }
        }
        if (rewritten) {
            ruleStack.addFirst(PushSelectCriteria.INSTANCE);
        }
        if (foundNoResults) {
            ruleStack.addFirst(RemoveEmptyAccessNodes.INSTANCE);
        }
        return plan;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Constraint rewrite(QueryContext context, List<Comparison> comparisons) {
        void var7_11;
        Comparison lessThan = null;
        Comparison greaterThan = null;
        LinkedList<Comparison> notNeeded = new LinkedList<Comparison>();
        boolean inclusive = false;
        block6: for (Comparison comparison : comparisons) {
            switch (comparison.operator()) {
                case GREATER_THAN_OR_EQUAL_TO: {
                    inclusive = true;
                }
                case GREATER_THAN: {
                    if (greaterThan != null) {
                        Comparison newGreaterThan = this.getComparison(context, greaterThan, comparison, true);
                        notNeeded.add(newGreaterThan == greaterThan ? comparison : greaterThan);
                        greaterThan = newGreaterThan;
                        continue block6;
                    }
                    greaterThan = comparison;
                    continue block6;
                }
                case LESS_THAN_OR_EQUAL_TO: {
                    inclusive = true;
                }
                case LESS_THAN: {
                    if (lessThan != null) {
                        Comparison newLessThan = this.getComparison(context, lessThan, comparison, false);
                        notNeeded.add(newLessThan == lessThan ? comparison : lessThan);
                        greaterThan = newLessThan;
                        continue block6;
                    }
                    lessThan = comparison;
                    continue block6;
                }
            }
            assert (false);
            return null;
        }
        if (lessThan == null || greaterThan == null) {
            return null;
        }
        Object var7_8 = null;
        int diff = this.compareStaticOperands(context, greaterThan, lessThan);
        if (diff == 0) {
            if (!inclusive) return CONFLICTING_CONSTRAINT;
            Comparison comparison = new Comparison(lessThan.getOperand1(), Operator.EQUAL_TO, lessThan.getOperand2());
            notNeeded.add(lessThan);
            notNeeded.add(greaterThan);
        } else {
            if (diff >= 0) return CONFLICTING_CONSTRAINT;
            boolean lowerInclusive = greaterThan.operator() == Operator.GREATER_THAN_OR_EQUAL_TO;
            boolean upperInclusive = lessThan.operator() == Operator.LESS_THAN_OR_EQUAL_TO;
            Between between = new Between(lessThan.getOperand1(), greaterThan.getOperand2(), lessThan.getOperand2(), lowerInclusive, upperInclusive);
            notNeeded.add(lessThan);
            notNeeded.add(greaterThan);
        }
        this.nullReference(comparisons, notNeeded);
        return var7_11;
    }

    protected void nullReference(List<Comparison> comparisons, Comparison comparisonToNull) {
        if (comparisonToNull != null) {
            for (int i = 0; i != comparisons.size(); ++i) {
                if (comparisons.get(i) != comparisonToNull) continue;
                comparisons.set(i, null);
            }
        }
    }

    protected void nullReference(List<Comparison> comparisons, Iterable<Comparison> comparisonsToNull) {
        for (Comparison comparisonToNull : comparisonsToNull) {
            this.nullReference(comparisons, comparisonToNull);
        }
    }

    protected int compareStaticOperands(QueryContext context, Comparison comparison1, Comparison comparison2) {
        Object value1 = this.getValue(context, comparison1.getOperand2());
        Object value2 = this.getValue(context, comparison2.getOperand2());
        return ValueComparators.OBJECT_COMPARATOR.compare(value1, value2);
    }

    protected Comparison getComparison(QueryContext context, Comparison comparison1, Comparison comparison2, boolean smallest) {
        int diff = this.compareStaticOperands(context, comparison1, comparison2);
        if (diff == 0) {
            return comparison1;
        }
        if (!smallest) {
            diff = -1 * diff;
        }
        return diff < 1 ? comparison1 : comparison2;
    }

    protected Object getValue(QueryContext context, StaticOperand operand) {
        if (operand instanceof Literal) {
            Literal literal = (Literal)operand;
            return literal.value();
        }
        BindVariableName variable = (BindVariableName)operand;
        return context.getVariables().get(variable.getBindVariableName());
    }
}

