/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.process;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.lucene.CompareStringQuery;
import org.modeshape.jcr.query.model.And;
import org.modeshape.jcr.query.model.BindVariableName;
import org.modeshape.jcr.query.model.ChildNode;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.DescendantNode;
import org.modeshape.jcr.query.model.FullTextSearch;
import org.modeshape.jcr.query.model.Literal;
import org.modeshape.jcr.query.model.Not;
import org.modeshape.jcr.query.model.Or;
import org.modeshape.jcr.query.model.PropertyExistence;
import org.modeshape.jcr.query.model.Relike;
import org.modeshape.jcr.query.model.SameNode;
import org.modeshape.jcr.query.model.SetCriteria;
import org.modeshape.jcr.query.model.StaticOperand;
import org.modeshape.jcr.query.model.TypeSystem;
import org.modeshape.jcr.query.process.DelegatingComponent;
import org.modeshape.jcr.query.process.ProcessingComponent;
import org.modeshape.jcr.query.validate.Schemata;
import org.modeshape.jcr.value.Path;

public class SelectComponent
extends DelegatingComponent {
    private final Constraint constraint;
    private final ConstraintChecker checker;
    private final Map<String, Object> variables;

    public SelectComponent(ProcessingComponent delegate, Constraint constraint, Map<String, Object> variables) {
        super(delegate);
        this.constraint = constraint;
        this.variables = variables != null ? variables : Collections.emptyMap();
        TypeSystem types = delegate.getContext().getTypeSystem();
        Schemata schemata = delegate.getContext().getSchemata();
        this.checker = this.createChecker(types, schemata, delegate.getColumns(), this.constraint, this.variables);
    }

    @Override
    public List<Object[]> execute() {
        List<Object[]> tuples = this.delegate().execute();
        if (!tuples.isEmpty()) {
            Iterator<Object[]> iter = tuples.iterator();
            while (iter.hasNext()) {
                if (this.checker.satisfiesConstraints(iter.next())) continue;
                iter.remove();
            }
        }
        return tuples;
    }

    protected ConstraintChecker createChecker(TypeSystem types, Schemata schemata, QueryResults.Columns columns, Constraint constraint, Map<String, Object> variables) {
        if (constraint instanceof Or) {
            Or orConstraint = (Or)constraint;
            final ConstraintChecker left = this.createChecker(types, schemata, columns, orConstraint.left(), variables);
            final ConstraintChecker right = this.createChecker(types, schemata, columns, orConstraint.right(), variables);
            return new ConstraintChecker(){

                @Override
                public boolean satisfiesConstraints(Object[] tuple) {
                    return left.satisfiesConstraints(tuple) || right.satisfiesConstraints(tuple);
                }
            };
        }
        if (constraint instanceof Not) {
            Not notConstraint = (Not)constraint;
            final ConstraintChecker original = this.createChecker(types, schemata, columns, notConstraint.getConstraint(), variables);
            return new ConstraintChecker(){

                @Override
                public boolean satisfiesConstraints(Object[] tuple) {
                    return !original.satisfiesConstraints(tuple);
                }
            };
        }
        if (constraint instanceof And) {
            And andConstraint = (And)constraint;
            final ConstraintChecker left = this.createChecker(types, schemata, columns, andConstraint.left(), variables);
            final ConstraintChecker right = this.createChecker(types, schemata, columns, andConstraint.right(), variables);
            return new ConstraintChecker(){

                @Override
                public boolean satisfiesConstraints(Object[] tuple) {
                    return left.satisfiesConstraints(tuple) && right.satisfiesConstraints(tuple);
                }
            };
        }
        if (constraint instanceof ChildNode) {
            ChildNode childConstraint = (ChildNode)constraint;
            final int locationIndex = columns.getLocationIndex(childConstraint.selectorName().name());
            final Path parentPath = (Path)types.getPathFactory().create(childConstraint.getParentPath());
            return new ConstraintChecker(){

                @Override
                public boolean satisfiesConstraints(Object[] tuple) {
                    QueryResults.Location location = (QueryResults.Location)tuple[locationIndex];
                    return location.getPath().getParent().equals(parentPath);
                }
            };
        }
        if (constraint instanceof DescendantNode) {
            DescendantNode descendantNode = (DescendantNode)constraint;
            final int locationIndex = columns.getLocationIndex(descendantNode.selectorName().name());
            final Path ancestorPath = (Path)types.getPathFactory().create(descendantNode.getAncestorPath());
            return new ConstraintChecker(){

                @Override
                public boolean satisfiesConstraints(Object[] tuple) {
                    QueryResults.Location location = (QueryResults.Location)tuple[locationIndex];
                    return location.getPath().isDescendantOf(ancestorPath);
                }
            };
        }
        if (constraint instanceof SameNode) {
            SameNode sameNode = (SameNode)constraint;
            final int locationIndex = columns.getLocationIndex(sameNode.selectorName().name());
            final String path = sameNode.getPath();
            return new ConstraintChecker(){

                @Override
                public boolean satisfiesConstraints(Object[] tuple) {
                    QueryResults.Location location = (QueryResults.Location)tuple[locationIndex];
                    return location.toString().equals(path);
                }
            };
        }
        if (constraint instanceof PropertyExistence) {
            PropertyExistence propertyExistance = (PropertyExistence)constraint;
            String selectorName = propertyExistance.selectorName().name();
            String propertyName = propertyExistance.getPropertyName();
            final int columnIndex = columns.getColumnIndexForProperty(selectorName, propertyName);
            return new ConstraintChecker(){

                @Override
                public boolean satisfiesConstraints(Object[] tuple) {
                    return tuple[columnIndex] != null;
                }
            };
        }
        if (constraint instanceof FullTextSearch) {
            return new ConstraintChecker(){

                @Override
                public boolean satisfiesConstraints(Object[] tuple) {
                    return true;
                }
            };
        }
        if (constraint instanceof Relike) {
            return new ConstraintChecker(){

                @Override
                public boolean satisfiesConstraints(Object[] tuple) {
                    return true;
                }
            };
        }
        if (constraint instanceof Comparison) {
            Comparison comparison = (Comparison)constraint;
            ProcessingComponent.DynamicOperation dynamicOperation = this.createDynamicOperation(types, schemata, columns, comparison.getOperand1());
            Operator operator = comparison.operator();
            StaticOperand staticOperand = comparison.getOperand2();
            return this.createChecker(types, schemata, columns, dynamicOperation, operator, staticOperand);
        }
        if (constraint instanceof SetCriteria) {
            SetCriteria setCriteria = (SetCriteria)constraint;
            ProcessingComponent.DynamicOperation dynamicOperation = this.createDynamicOperation(types, schemata, columns, setCriteria.leftOperand());
            Operator operator = Operator.EQUAL_TO;
            final LinkedList<ConstraintChecker> checkers = new LinkedList<ConstraintChecker>();
            for (StaticOperand staticOperand : setCriteria.rightOperands()) {
                ConstraintChecker rightChecker = this.createChecker(types, schemata, columns, dynamicOperation, operator, staticOperand);
                assert (rightChecker != null);
                checkers.add(rightChecker);
            }
            if (checkers.isEmpty()) {
                return new ConstraintChecker(){

                    @Override
                    public boolean satisfiesConstraints(Object[] tuple) {
                        return false;
                    }
                };
            }
            return new ConstraintChecker(){

                @Override
                public boolean satisfiesConstraints(Object[] tuple) {
                    for (ConstraintChecker checker : checkers) {
                        if (!checker.satisfiesConstraints(tuple)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        assert (false);
        return null;
    }

    protected ConstraintChecker createChecker(final TypeSystem types, Schemata schemata, QueryResults.Columns columns, final ProcessingComponent.DynamicOperation dynamicOperation, Operator operator, StaticOperand staticOperand) {
        String expectedType = dynamicOperation.getExpectedType();
        Object literalValue = null;
        if (staticOperand instanceof BindVariableName) {
            BindVariableName bindVariable = (BindVariableName)staticOperand;
            String variableName = bindVariable.getBindVariableName();
            literalValue = this.variables.get(variableName);
        } else {
            Literal literal = (Literal)staticOperand;
            literalValue = literal.value();
        }
        TypeSystem.TypeFactory<?> typeFactory = types.getTypeFactory(expectedType);
        assert (typeFactory != null);
        final Comparator<?> comparator = typeFactory.getComparator();
        assert (comparator != null);
        TypeSystem.TypeFactory<?> literalFactory = types.getTypeFactory(expectedType);
        final Object rhs = literalFactory.create(literalValue);
        switch (operator) {
            case EQUAL_TO: {
                return new ConstraintChecker(){

                    @Override
                    public boolean satisfiesConstraints(Object[] tuples) {
                        return comparator.compare(dynamicOperation.evaluate(tuples), rhs) == 0;
                    }
                };
            }
            case GREATER_THAN: {
                return new ConstraintChecker(){

                    @Override
                    public boolean satisfiesConstraints(Object[] tuples) {
                        return comparator.compare(dynamicOperation.evaluate(tuples), rhs) > 0;
                    }
                };
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return new ConstraintChecker(){

                    @Override
                    public boolean satisfiesConstraints(Object[] tuples) {
                        return comparator.compare(dynamicOperation.evaluate(tuples), rhs) >= 0;
                    }
                };
            }
            case LESS_THAN: {
                return new ConstraintChecker(){

                    @Override
                    public boolean satisfiesConstraints(Object[] tuples) {
                        return comparator.compare(dynamicOperation.evaluate(tuples), rhs) < 0;
                    }
                };
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return new ConstraintChecker(){

                    @Override
                    public boolean satisfiesConstraints(Object[] tuples) {
                        return comparator.compare(dynamicOperation.evaluate(tuples), rhs) <= 0;
                    }
                };
            }
            case NOT_EQUAL_TO: {
                return new ConstraintChecker(){

                    @Override
                    public boolean satisfiesConstraints(Object[] tuples) {
                        return comparator.compare(dynamicOperation.evaluate(tuples), rhs) != 0;
                    }
                };
            }
            case LIKE: {
                String regex = CompareStringQuery.toRegularExpression(types.asString(rhs));
                final Pattern pattern = Pattern.compile(regex);
                return new ConstraintChecker(){

                    @Override
                    public boolean satisfiesConstraints(Object[] tuples) {
                        Object tupleValue = dynamicOperation.evaluate(tuples);
                        if (tupleValue == null) {
                            return false;
                        }
                        String value = types.asString(tupleValue);
                        return pattern.matcher(value).matches();
                    }
                };
            }
        }
        assert (false);
        return null;
    }

    protected static interface CompareOperation {
        public boolean evaluate(Object var1, Object var2);
    }

    public static interface ConstraintChecker {
        public boolean satisfiesConstraints(Object[] var1);
    }
}

