/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.modeshape.common.util.IoUtil;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.binary.AbstractBinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.FileSystemBinaryStore;
import org.modeshape.jcr.value.binary.StoredBinaryValue;
import org.modeshape.jcr.value.binary.TransientBinaryStore;

public class CassandraBinaryStore
extends AbstractBinaryStore {
    private static final boolean ALIVE = true;
    private static final boolean UNUSED = false;
    private Session session;
    private String address;
    private FileSystemBinaryStore cache;

    public CassandraBinaryStore(String address) {
        this.address = address;
        this.cache = TransientBinaryStore.get();
    }

    @Override
    protected String getStoredMimeType(BinaryValue source) throws BinaryStoreException {
        try {
            this.checkContentExists(source);
            ResultSet rs = this.session.execute("SELECT mime_type FROM modeshape.binary WHERE cid = '" + source.getKey() + "';");
            Row row = rs.one();
            if (row == null) {
                throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{source.getKey(), this.session}));
            }
            return row.getString("mime_type");
        }
        catch (BinaryStoreException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new BinaryStoreException(e);
        }
    }

    private void checkContentExists(BinaryValue source) throws BinaryStoreException {
        if (!this.contentExists(source.getKey(), true)) {
            throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{source.getKey(), this.session}));
        }
    }

    @Override
    protected void storeMimeType(BinaryValue source, String mimeType) throws BinaryStoreException {
        try {
            this.session.execute("UPDATE modeshape.binary SET mime_type='" + mimeType + "' where cid='" + source.getKey() + "';");
        }
        catch (RuntimeException e) {
            throw new BinaryStoreException(e);
        }
    }

    @Override
    public void storeExtractedText(BinaryValue source, String extractedText) throws BinaryStoreException {
        try {
            this.session.execute("UPDATE modeshape.binary SET ext_text='" + extractedText + "' where cid='" + source.getKey() + "';");
        }
        catch (RuntimeException e) {
            throw new BinaryStoreException(e);
        }
    }

    @Override
    public String getExtractedText(BinaryValue source) throws BinaryStoreException {
        try {
            this.checkContentExists(source);
            ResultSet rs = this.session.execute("SELECT ext_text FROM modeshape.binary WHERE cid = '" + source.getKey() + "';");
            Row row = rs.one();
            if (row == null) {
                throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{source.getKey(), this.session}));
            }
            return row.getString("ext_text");
        }
        catch (BinaryStoreException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new BinaryStoreException(e);
        }
    }

    @Override
    public BinaryValue storeValue(InputStream stream, boolean markAsUnused) throws BinaryStoreException {
        BinaryValue temp = this.cache.storeValue(stream, markAsUnused);
        try {
            String stmt;
            BinaryKey key = new BinaryKey(temp.getKey().toString());
            if (this.contentExists(key, true)) {
                StoredBinaryValue storedBinaryValue = new StoredBinaryValue(this, key, temp.getSize());
                return storedBinaryValue;
            }
            if (this.contentExists(key, false)) {
                if (!markAsUnused) {
                    this.session.execute("UPDATE modeshape.binary SET usage=1 WHERE cid='" + key + "';");
                }
                StoredBinaryValue storedBinaryValue = new StoredBinaryValue(this, key, temp.getSize());
                return storedBinaryValue;
            }
            if (!markAsUnused) {
                stmt = "INSERT INTO modeshape.binary (cid, payload, usage) VALUES (?,?,1)";
                PreparedStatement preparedStatement = this.session.prepare(stmt);
                BoundStatement statement = new BoundStatement(preparedStatement);
                this.session.execute((Query)statement.bind(new Object[]{key.toString(), this.buffer(stream)}));
            } else {
                stmt = "INSERT INTO modeshape.binary (cid, usage_time, payload, usage) VALUES (?,?,?,0)";
                PreparedStatement preparedStatement = this.session.prepare(stmt);
                BoundStatement statement = new BoundStatement(preparedStatement);
                this.session.execute((Query)statement.bind(new Object[]{key.toString(), new Date(), this.buffer(stream)}));
            }
            StoredBinaryValue storedBinaryValue = new StoredBinaryValue(this, key, temp.getSize());
            return storedBinaryValue;
        }
        catch (BinaryStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BinaryStoreException(e);
        }
        finally {
            this.cache.markAsUnused(temp.getKey());
        }
    }

    @Override
    public InputStream getInputStream(BinaryKey key) throws BinaryStoreException {
        try {
            ResultSet rs = this.session.execute("SELECT payload FROM modeshape.binary WHERE cid='" + key.toString() + "'");
            Row row = rs.one();
            if (row == null) {
                throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{key, this.session}));
            }
            ByteBuffer buffer = row.getBytes("payload");
            return new BufferedInputStream(buffer);
        }
        catch (BinaryStoreException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new BinaryStoreException(e);
        }
    }

    @Override
    public void markAsUsed(Iterable<BinaryKey> keys) throws BinaryStoreException {
        try {
            for (BinaryKey key : keys) {
                this.session.execute("UPDATE modeshape.binary SET usage=1 where cid='" + key + "';");
            }
        }
        catch (RuntimeException e) {
            throw new BinaryStoreException(e);
        }
    }

    @Override
    public void markAsUnused(Iterable<BinaryKey> keys) throws BinaryStoreException {
        PreparedStatement preparedStatement = this.session.prepare("UPDATE modeshape.binary SET usage = ?, usage_time = ? WHERE cid = ?");
        try {
            for (BinaryKey key : keys) {
                BoundStatement statement = new BoundStatement(preparedStatement);
                this.session.execute((Query)statement.bind(new Object[]{0, new Date(), key.toString()}));
            }
        }
        catch (RuntimeException e) {
            throw new BinaryStoreException(e);
        }
    }

    @Override
    public void removeValuesUnusedLongerThan(long minimumAge, TimeUnit unit) throws BinaryStoreException {
        try {
            Date deadline = new Date(System.currentTimeMillis() - unit.toMillis(minimumAge));
            ResultSet rs = this.session.execute("SELECT cid from modeshape.binary where usage=0 and usage_time < " + deadline.getTime() + " allow filtering;");
            Iterator rows = rs.iterator();
            while (rows.hasNext()) {
                this.session.execute("DELETE from modeshape.binary where cid = '" + ((Row)rows.next()).getString("cid") + "';");
            }
            rs = this.session.execute("SELECT cid from modeshape.binary where usage=1 and usage_time < " + deadline.getTime() + " allow filtering;");
            rows = rs.iterator();
            while (rows.hasNext()) {
                this.session.execute("DELETE from modeshape.binary where cid = '" + ((Row)rows.next()).getString("cid") + "';");
            }
        }
        catch (RuntimeException e) {
            throw new BinaryStoreException(e);
        }
    }

    @Override
    public Iterable<BinaryKey> getAllBinaryKeys() throws BinaryStoreException {
        try {
            ResultSet rs = this.session.execute("SELECT cid from modeshape.binary WHERE usage=1;");
            Iterator it = rs.iterator();
            HashSet<BinaryKey> keys = new HashSet<BinaryKey>();
            while (it.hasNext()) {
                keys.add(new BinaryKey(((Row)it.next()).getString("cid")));
            }
            return keys;
        }
        catch (RuntimeException e) {
            throw new BinaryStoreException(e);
        }
    }

    @Override
    public void start() {
        Cluster cluster = Cluster.builder().addContactPoint(this.address).build();
        Metadata metadata = cluster.getMetadata();
        System.out.printf("Connected to cluster: %s\n", metadata.getClusterName());
        for (Host host : metadata.getAllHosts()) {
            System.out.printf("Datacenter: %s; Host: %s; Rack: %s\n", host.getDatacenter(), host.getAddress(), host.getRack());
        }
        this.session = cluster.connect();
        try {
            this.session.execute("CREATE KEYSPACE modeshape WITH replication = {'class':'SimpleStrategy', 'replication_factor':3};");
        }
        catch (AlreadyExistsException e) {
            // empty catch block
        }
        this.session.execute("USE modeshape;");
        try {
            this.session.execute("CREATE TABLE modeshape.binary(cid text PRIMARY KEY,mime_type text,ext_text text,usage int,usage_time timestamp,payload blob)");
        }
        catch (AlreadyExistsException e) {
            // empty catch block
        }
        try {
            this.session.execute("CREATE INDEX USAGE_IDX ON modeshape.binary (usage);");
        }
        catch (InvalidQueryException e) {
            // empty catch block
        }
        try {
            this.session.execute("CREATE INDEX EXPIRE_IDX ON modeshape.binary (usage_time);");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    private boolean contentExists(BinaryKey key, boolean alive) throws BinaryStoreException {
        try {
            String query = "SELECT payload from modeshape.binary where cid='" + key.toString() + "'";
            query = alive ? query + " and usage=1;" : query + " and usage = 0;";
            ResultSet rs = this.session.execute(query);
            return rs.iterator().hasNext();
        }
        catch (RuntimeException e) {
            throw new BinaryStoreException(e);
        }
    }

    private ByteBuffer buffer(InputStream stream) throws IOException {
        stream.reset();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        IoUtil.write((InputStream)stream, (OutputStream)bout);
        return ByteBuffer.wrap(bout.toByteArray());
    }

    protected final class BufferedInputStream
    extends InputStream {
        private ByteBuffer buffer;

        protected BufferedInputStream(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public int read() {
            return this.buffer.position() < this.buffer.limit() ? this.buffer.get() & 0xFF : -1;
        }
    }
}

