/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrItemDefinitionTemplate;
import org.modeshape.jcr.JcrNodeDefinitionTemplate;
import org.modeshape.jcr.JcrPropertyDefinitionTemplate;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.ValueFormatException;

@NotThreadSafe
public class JcrNodeTypeTemplate
implements NodeTypeTemplate {
    private final ExecutionContext context;
    private final List<NodeDefinitionTemplate> nodeDefinitionTemplates = new ArrayList<NodeDefinitionTemplate>();
    private final List<PropertyDefinitionTemplate> propertyDefinitionTemplates = new ArrayList<PropertyDefinitionTemplate>();
    private final boolean createdFromExistingDefinition;
    private boolean isAbstract;
    private boolean queryable = true;
    private boolean mixin;
    private boolean orderableChildNodes;
    private Name[] declaredSupertypeNames;
    private Name name;
    private Name primaryItemName;

    JcrNodeTypeTemplate(ExecutionContext context) {
        this(context, false);
    }

    JcrNodeTypeTemplate(ExecutionContext context, boolean createdFromExistingDefinition) {
        assert (context != null);
        this.context = context;
        this.createdFromExistingDefinition = createdFromExistingDefinition;
    }

    JcrNodeTypeTemplate(JcrNodeTypeTemplate original, ExecutionContext context) {
        this.context = context;
        this.isAbstract = original.isAbstract;
        this.queryable = original.queryable;
        this.mixin = original.mixin;
        this.name = original.name;
        this.orderableChildNodes = original.orderableChildNodes;
        this.declaredSupertypeNames = original.declaredSupertypeNames;
        this.primaryItemName = original.primaryItemName;
        JcrItemDefinitionTemplate.registerMissingNamespaces(original.context, context, this.name);
        JcrItemDefinitionTemplate.registerMissingNamespaces(original.context, context, this.declaredSupertypeNames);
        JcrItemDefinitionTemplate.registerMissingNamespaces(original.context, context, this.primaryItemName);
        for (NodeDefinitionTemplate childDefn : original.nodeDefinitionTemplates) {
            this.nodeDefinitionTemplates.add(((JcrNodeDefinitionTemplate)childDefn).with(context));
        }
        for (PropertyDefinitionTemplate propDefn : original.propertyDefinitionTemplates) {
            this.propertyDefinitionTemplates.add(((JcrPropertyDefinitionTemplate)propDefn).with(context));
        }
        this.createdFromExistingDefinition = original.createdFromExistingDefinition;
    }

    JcrNodeTypeTemplate with(ExecutionContext context) {
        return context == this.context ? this : new JcrNodeTypeTemplate(this, context);
    }

    ExecutionContext getExecutionContext() {
        return this.context;
    }

    private String string(Name name) {
        if (name == null) {
            return null;
        }
        return name.getString(this.context.getNamespaceRegistry());
    }

    Name[] declaredSupertypeNames() {
        return this.declaredSupertypeNames;
    }

    public List<NodeDefinitionTemplate> getNodeDefinitionTemplates() {
        return this.nodeDefinitionTemplates;
    }

    public List<PropertyDefinitionTemplate> getPropertyDefinitionTemplates() {
        return this.propertyDefinitionTemplates;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setDeclaredSuperTypeNames(String[] names) throws ConstraintViolationException {
        if (names == null) {
            throw new ConstraintViolationException(JcrI18n.badNodeTypeName.text(new Object[]{"names"}));
        }
        Name[] supertypeNames = new Name[names.length];
        for (int i = 0; i < names.length; ++i) {
            CheckArg.isNotEmpty((String)names[i], (String)("names[" + i + ""));
            try {
                supertypeNames[i] = (Name)this.context.getValueFactories().getNameFactory().create(names[i]);
                continue;
            }
            catch (ValueFormatException vfe) {
                throw new ConstraintViolationException((Throwable)vfe);
            }
        }
        this.declaredSupertypeNames = supertypeNames;
    }

    public void setMixin(boolean mixin) {
        this.mixin = mixin;
    }

    public void setName(String name) throws ConstraintViolationException {
        CheckArg.isNotEmpty((String)name, (String)"name");
        try {
            this.name = (Name)this.context.getValueFactories().getNameFactory().create(name);
        }
        catch (ValueFormatException vfe) {
            throw new ConstraintViolationException((Throwable)vfe);
        }
    }

    public void setOrderableChildNodes(boolean orderable) {
        this.orderableChildNodes = orderable;
    }

    public void setPrimaryItemName(String name) throws ConstraintViolationException {
        if (name == null || name.trim().length() == 0) {
            this.primaryItemName = null;
        } else {
            try {
                this.primaryItemName = (Name)this.context.getValueFactories().getNameFactory().create(name);
            }
            catch (ValueFormatException vfe) {
                throw new ConstraintViolationException((Throwable)vfe);
            }
        }
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        if (!this.createdFromExistingDefinition && this.nodeDefinitionTemplates.isEmpty()) {
            return null;
        }
        return this.nodeDefinitionTemplates.toArray(new NodeDefinition[this.nodeDefinitionTemplates.size()]);
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        if (!this.createdFromExistingDefinition && this.propertyDefinitionTemplates.isEmpty()) {
            return null;
        }
        return this.propertyDefinitionTemplates.toArray(new PropertyDefinition[this.propertyDefinitionTemplates.size()]);
    }

    public String[] getDeclaredSupertypeNames() {
        if (this.declaredSupertypeNames == null) {
            return new String[0];
        }
        String[] names = new String[this.declaredSupertypeNames.length];
        for (int i = 0; i < this.declaredSupertypeNames.length; ++i) {
            names[i] = this.declaredSupertypeNames[i].getString(this.context.getNamespaceRegistry());
        }
        return names;
    }

    public String getName() {
        return this.string(this.name);
    }

    public String getPrimaryItemName() {
        return this.string(this.primaryItemName);
    }

    public boolean hasOrderableChildNodes() {
        return this.orderableChildNodes;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isMixin() {
        return this.mixin;
    }

    public boolean isQueryable() {
        return this.queryable;
    }

    public void setQueryable(boolean queryable) {
        this.queryable = queryable;
    }

    public String toString() {
        return this.getName();
    }
}

