/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.Base64;
import org.modeshape.common.xml.XmlCharacters;
import org.modeshape.jcr.AbstractJcrExporter;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrMultiValueProperty;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrSharedNode;
import org.modeshape.jcr.JcrSvLexicon;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.api.PropertyType;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.ValueFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@NotThreadSafe
class JcrSystemViewExporter
extends AbstractJcrExporter {
    private static final int BASE_64_BUFFER_SIZE = 1024;
    private static final List<Name> SPECIAL_PROPERTY_NAMES = Arrays.asList(JcrLexicon.PRIMARY_TYPE, JcrLexicon.MIXIN_TYPES, JcrLexicon.UUID);

    JcrSystemViewExporter(JcrSession session) {
        super(session, Arrays.asList("xml"));
    }

    @Override
    public void exportNode(Node node, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws RepositoryException, SAXException {
        this.exportNode(node, contentHandler, skipBinary, noRecurse, node.getDepth() == 0);
    }

    protected void exportNode(Node node, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse, boolean isRoot) throws RepositoryException, SAXException {
        AttributesImpl atts = new AttributesImpl();
        String nodeName = node.getName();
        if (isRoot && node.getDepth() == 0) {
            nodeName = "jcr:root";
        }
        atts.addAttribute(JcrSvLexicon.NAME.getNamespaceUri(), JcrSvLexicon.NAME.getLocalName(), this.getPrefixedName(JcrSvLexicon.NAME), PropertyType.nameFromValue((int)1), nodeName);
        this.startElement(contentHandler, JcrSvLexicon.NODE, atts);
        JcrSharedNode sharedNode = this.asSharedNode(node);
        if (sharedNode != null) {
            this.emitProperty(JcrLexicon.PRIMARY_TYPE, 7, JcrNtLexicon.SHARE, contentHandler, skipBinary);
            this.emitProperty(JcrLexicon.UUID, 1, sharedNode.getIdentifier(), contentHandler, skipBinary);
        } else {
            this.exporting(node);
            for (Name specialPropertyName : SPECIAL_PROPERTY_NAMES) {
                AbstractJcrProperty specialProperty = ((AbstractJcrNode)node).getProperty(specialPropertyName);
                if (specialProperty == null) continue;
                this.emitProperty((Property)specialProperty, contentHandler, skipBinary);
            }
            PropertyIterator properties = node.getProperties();
            while (properties.hasNext()) {
                this.exportProperty(properties.nextProperty(), contentHandler, skipBinary);
            }
            if (!noRecurse) {
                NodeIterator nodes = node.getNodes();
                while (nodes.hasNext()) {
                    this.exportNode(nodes.nextNode(), contentHandler, skipBinary, noRecurse, false);
                }
            }
        }
        this.endElement(contentHandler, JcrSvLexicon.NODE);
    }

    private void exportProperty(Property property, ContentHandler contentHandler, boolean skipBinary) throws RepositoryException, SAXException {
        assert (property instanceof AbstractJcrProperty) : "Illegal attempt to use " + this.getClass().getName() + " on non-ModeShape property";
        AbstractJcrProperty prop = (AbstractJcrProperty)property;
        Name propertyName = prop.name();
        if (SPECIAL_PROPERTY_NAMES.contains(propertyName)) {
            return;
        }
        this.emitProperty(property, contentHandler, skipBinary);
    }

    private void emitProperty(Property property, ContentHandler contentHandler, boolean skipBinary) throws RepositoryException, SAXException {
        assert (property instanceof AbstractJcrProperty) : "Illegal attempt to use " + this.getClass().getName() + " on non-ModeShape property";
        AbstractJcrProperty prop = (AbstractJcrProperty)property;
        AttributesImpl propAtts = new AttributesImpl();
        propAtts.addAttribute(JcrSvLexicon.NAME.getNamespaceUri(), JcrSvLexicon.NAME.getLocalName(), this.getPrefixedName(JcrSvLexicon.NAME), javax.jcr.PropertyType.nameFromValue((int)1), prop.getName());
        propAtts.addAttribute(JcrSvLexicon.TYPE.getNamespaceUri(), JcrSvLexicon.TYPE.getLocalName(), this.getPrefixedName(JcrSvLexicon.TYPE), javax.jcr.PropertyType.nameFromValue((int)1), PropertyType.nameFromValue((int)prop.getType()));
        if (prop.isMultiple()) {
            propAtts.addAttribute(JcrSvLexicon.TYPE.getNamespaceUri(), JcrSvLexicon.TYPE.getLocalName(), this.getPrefixedName(JcrSvLexicon.MULTIPLE), javax.jcr.PropertyType.nameFromValue((int)6), Boolean.TRUE.toString());
        }
        this.startElement(contentHandler, JcrSvLexicon.PROPERTY, propAtts);
        if (prop instanceof JcrMultiValueProperty) {
            JcrValue[] values = prop.getValues();
            for (int i = 0; i < values.length; ++i) {
                this.emitValue(values[i], contentHandler, property.getType(), skipBinary);
            }
        } else {
            this.emitValue(property.getValue(), contentHandler, property.getType(), skipBinary);
        }
        this.endElement(contentHandler, JcrSvLexicon.PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitValue(Value value, ContentHandler contentHandler, int propertyType, boolean skipBinary) throws RepositoryException, SAXException {
        if (2 == propertyType) {
            this.startElement(contentHandler, JcrSvLexicon.VALUE, null);
            if (!skipBinary) {
                byte[] bytes = new byte[1024];
                Binary binary = value.getBinary();
                try (Base64.InputStream stream = new Base64.InputStream(binary.getStream(), 1);){
                    int len;
                    while (-1 != (len = stream.read(bytes))) {
                        contentHandler.characters(new String(bytes, 0, len).toCharArray(), 0, len);
                    }
                }
                catch (IOException ioe) {
                    throw new RepositoryException((Throwable)ioe);
                }
                finally {
                    binary.dispose();
                }
            }
            this.endElement(contentHandler, JcrSvLexicon.VALUE);
        } else {
            this.emitValue(value.getString(), contentHandler);
        }
    }

    private void emitValue(String value, ContentHandler contentHandler) throws RepositoryException, SAXException {
        char[] chars = value.toCharArray();
        boolean allCharsAreValidXml = true;
        for (int i = 0; i < chars.length; ++i) {
            if (XmlCharacters.isValid((int)chars[i])) continue;
            allCharsAreValidXml = false;
            break;
        }
        if (allCharsAreValidXml) {
            this.startElement(contentHandler, JcrSvLexicon.VALUE, null);
            contentHandler.characters(chars, 0, chars.length);
            this.endElement(contentHandler, JcrSvLexicon.VALUE);
        } else {
            AttributesImpl valueAtts = new AttributesImpl();
            NamespaceRegistry namespaceRegistry = this.session.getWorkspace().getNamespaceRegistry();
            String xsiPrefix = null;
            try {
                xsiPrefix = namespaceRegistry.getPrefix("\u201chttp://www.w3.org/2001/XMLSchema-instance");
            }
            catch (NamespaceException e) {
                xsiPrefix = "xsi";
            }
            String xsdPrefix = null;
            try {
                xsdPrefix = namespaceRegistry.getPrefix("http://www.w3.org/2001/XMLSchema");
            }
            catch (RepositoryException e) {
                xsdPrefix = "xsd";
            }
            valueAtts.addAttribute(xsiPrefix, "type", xsiPrefix + ":type", "STRING", xsdPrefix + ":base64Binary");
            this.startElement(contentHandler, JcrSvLexicon.VALUE, valueAtts);
            try {
                chars = Base64.encodeBytes((byte[])value.getBytes("UTF-8")).toCharArray();
            }
            catch (IOException ioe) {
                throw new RepositoryException((Throwable)ioe);
            }
            contentHandler.characters(chars, 0, chars.length);
            this.endElement(contentHandler, JcrSvLexicon.VALUE);
        }
    }

    private void emitProperty(Name propertyName, int propertyType, Object value, ContentHandler contentHandler, boolean skipBinary) throws RepositoryException, SAXException {
        ValueFactory<String> strings = this.session.stringFactory();
        AttributesImpl propAtts = new AttributesImpl();
        propAtts.addAttribute(JcrSvLexicon.NAME.getNamespaceUri(), JcrSvLexicon.NAME.getLocalName(), this.getPrefixedName(JcrSvLexicon.NAME), javax.jcr.PropertyType.nameFromValue((int)1), strings.create(propertyName));
        propAtts.addAttribute(JcrSvLexicon.TYPE.getNamespaceUri(), JcrSvLexicon.TYPE.getLocalName(), this.getPrefixedName(JcrSvLexicon.TYPE), javax.jcr.PropertyType.nameFromValue((int)1), PropertyType.nameFromValue((int)propertyType));
        this.startElement(contentHandler, JcrSvLexicon.PROPERTY, propAtts);
        this.emitValue(strings.create(value), contentHandler);
        this.endElement(contentHandler, JcrSvLexicon.PROPERTY);
    }
}

