/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.SystemContent;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.basic.SimpleNamespaceRegistry;

@ThreadSafe
public class SystemNamespaceRegistry
implements NamespaceRegistry {
    public static final Name URI_PROPERTY_NAME = ModeShapeLexicon.URI;
    public static final Name GENERATED_PROPERTY_NAME = ModeShapeLexicon.GENERATED;
    private final JcrRepository.RunningState repository;
    private final SimpleNamespaceRegistry cache;
    private ExecutionContext context;
    private final ReadWriteLock namespacesLock = new ReentrantReadWriteLock();
    private final Logger logger = Logger.getLogger(this.getClass());

    SystemNamespaceRegistry(JcrRepository.RunningState repository) {
        this.repository = repository;
        this.cache = new SimpleNamespaceRegistry();
        this.cache.register(new ExecutionContext().getNamespaceRegistry().getNamespaces());
    }

    void setContext(ExecutionContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean refreshFromSystem() {
        Lock lock = this.namespacesLock.writeLock();
        try {
            lock.lock();
            SessionCache systemCache = this.repository.createSystemSession(this.context, false);
            SystemContent system = new SystemContent(systemCache);
            Collection<NamespaceRegistry.Namespace> namespaces = system.readAllNamespaces();
            if (namespaces.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this.cache.clear();
            this.cache.register(namespaces);
        }
        catch (Throwable e) {
            this.logger.error(e, (I18nResource)JcrI18n.errorRefreshingNodeTypes, new Object[]{this.repository.name()});
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    private final SystemContent systemContent(boolean readOnly) {
        SessionCache systemCache = this.repository.createSystemSession(this.context, readOnly);
        return new SystemContent(systemCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNamespaceForPrefix(String prefix) {
        Lock lock = this.namespacesLock.readLock();
        try {
            lock.lock();
            CheckArg.isNotNull((Object)prefix, (String)"prefix");
            String string = this.cache.getNamespaceForPrefix(prefix);
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPrefixForNamespaceUri(String namespaceUri, boolean generateIfMissing) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        Lock lock = this.namespacesLock.readLock();
        try {
            SystemContent systemContent;
            lock.lock();
            String prefix = this.cache.getPrefixForNamespaceUri(namespaceUri, false);
            if (prefix == null && generateIfMissing && (prefix = (systemContent = this.systemContent(!generateIfMissing)).readNamespacePrefix(namespaceUri, generateIfMissing)) != null) {
                systemContent.save();
                this.cache.register(prefix, namespaceUri);
            }
            String string = prefix;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRegisteredNamespaceUri(String namespaceUri) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        Lock lock = this.namespacesLock.readLock();
        try {
            lock.lock();
            boolean bl = this.cache.isRegisteredNamespaceUri(namespaceUri);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public String getDefaultNamespaceUri() {
        return this.getNamespaceForPrefix("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Iterable<NamespaceRegistry.Namespace> namespaces) {
        Lock lock = this.namespacesLock.writeLock();
        try {
            lock.lock();
            HashMap<String, String> urisByPrefix = new HashMap<String, String>();
            for (NamespaceRegistry.Namespace namespace : namespaces) {
                urisByPrefix.put(namespace.getPrefix(), namespace.getNamespaceUri());
            }
            this.register(urisByPrefix);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Map<String, String> namespaceUrisByPrefix) {
        if (namespaceUrisByPrefix == null || namespaceUrisByPrefix.isEmpty()) {
            return;
        }
        Lock lock = this.namespacesLock.writeLock();
        try {
            lock.lock();
            SystemContent systemContent = this.systemContent(false);
            systemContent.registerNamespaces(namespaceUrisByPrefix);
            systemContent.save();
            for (Map.Entry<String, String> entry : namespaceUrisByPrefix.entrySet()) {
                String prefix = entry.getKey().trim();
                String uri = entry.getValue().trim();
                if (prefix.length() == 0) continue;
                this.cache.register(prefix, uri);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String register(String prefix, String namespaceUri) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        namespaceUri = namespaceUri.trim();
        Lock lock = this.namespacesLock.writeLock();
        try {
            lock.lock();
            String previousCachedUriForPrefix = this.cache.register(prefix, namespaceUri);
            if (!namespaceUri.equals(previousCachedUriForPrefix)) {
                SystemContent systemContent = this.systemContent(false);
                systemContent.registerNamespaces(Collections.singletonMap(prefix, namespaceUri));
                systemContent.save();
            }
            String string = previousCachedUriForPrefix;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregister(String namespaceUri) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        namespaceUri = namespaceUri.trim();
        Lock lock = this.namespacesLock.writeLock();
        try {
            lock.lock();
            boolean found = this.cache.unregister(namespaceUri);
            SystemContent systemContent = this.systemContent(false);
            boolean foundPersistent = systemContent.unregisterNamespace(namespaceUri);
            systemContent.save();
            boolean bl = foundPersistent || found;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getRegisteredNamespaceUris() {
        Lock lock = this.namespacesLock.readLock();
        try {
            lock.lock();
            Set<String> set = this.cache.getRegisteredNamespaceUris();
            return set;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<NamespaceRegistry.Namespace> getNamespaces() {
        Lock lock = this.namespacesLock.readLock();
        try {
            lock.lock();
            Set<NamespaceRegistry.Namespace> set = this.cache.getNamespaces();
            return set;
        }
        finally {
            lock.unlock();
        }
    }

    public String toString() {
        ArrayList<NamespaceRegistry.Namespace> namespaces = new ArrayList<NamespaceRegistry.Namespace>(this.getNamespaces());
        Collections.sort(namespaces);
        return ((Object)namespaces).toString();
    }
}

