/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.bus;

import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.bus.ChangeBus;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.clustering.ClusteringService;
import org.modeshape.jcr.clustering.MessageConsumer;

@ThreadSafe
public final class ClusteredRepositoryChangeBus
extends MessageConsumer<ChangeSet>
implements ChangeBus {
    private static final Logger LOGGER = Logger.getLogger(ClusteredRepositoryChangeBus.class);
    private final ChangeBus delegate;
    private final ClusteringService clusteringService;

    public ClusteredRepositoryChangeBus(ChangeBus delegate, ClusteringService clusteringService) {
        super(ChangeSet.class);
        CheckArg.isNotNull((Object)delegate, (String)"delegate");
        CheckArg.isNotNull((Object)clusteringService, (String)"clusteringService");
        this.delegate = delegate;
        this.clusteringService = clusteringService;
    }

    @Override
    public void consume(ChangeSet changes) {
        if (this.hasObservers()) {
            this.delegate.notify(changes);
            this.logReceivedOperation(changes);
        }
    }

    @Override
    public synchronized void start() throws Exception {
        if (!this.clusteringService.isOpen()) {
            throw new IllegalStateException("The clustering service has not been started");
        }
        this.delegate.start();
        this.clusteringService.addConsumer(this);
    }

    @Override
    public boolean hasObservers() {
        return this.delegate.hasObservers();
    }

    @Override
    public synchronized void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public void notify(ChangeSet changeSet) {
        if (changeSet == null) {
            return;
        }
        if (!this.clusteringService.multipleMembersInCluster()) {
            this.consume(changeSet);
            return;
        }
        this.logSendOperation(changeSet);
        this.clusteringService.sendMessage(changeSet);
    }

    protected final void logSendOperation(ChangeSet changeSet) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Sending to cluster '{0}' {1} changes on workspace {2} made by {3} from process '{4}' at {5}", new Object[]{this.clusteringService.clusterName(), changeSet.size(), changeSet.getWorkspaceName(), changeSet.getUserData(), changeSet.getProcessKey(), changeSet.getTimestamp()});
        }
    }

    protected final void logReceivedOperation(ChangeSet changeSet) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Received from cluster '{0}' {1} changes on workspace {2} made by {3} from process '{4}' at {5}", new Object[]{this.clusteringService.clusterName(), changeSet.size(), changeSet.getWorkspaceName(), changeSet.getUserId(), changeSet.getProcessKey(), changeSet.getTimestamp()});
        }
    }

    @Override
    public boolean register(ChangeSetListener observer) {
        return this.delegate.register(observer);
    }

    @Override
    public boolean unregister(ChangeSetListener observer) {
        return this.delegate.unregister(observer);
    }
}

