/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Transaction;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.document.TransactionalWorkspaceCaches;
import org.modeshape.jcr.cache.document.WorkspaceCache;

public class TransactionalWorkspaceCache
extends WorkspaceCache {
    private final WorkspaceCache sharedWorkspaceCache;
    private final TransactionalWorkspaceCaches cacheManager;
    private final Transaction txn;

    protected TransactionalWorkspaceCache(WorkspaceCache sharedWorkspaceCache, TransactionalWorkspaceCaches cacheManager, Transaction txn) {
        super(sharedWorkspaceCache, new ConcurrentHashMap<NodeKey, CachedNode>(), null);
        this.sharedWorkspaceCache = sharedWorkspaceCache;
        this.txn = txn;
        this.cacheManager = cacheManager;
    }

    @Override
    public void changed(ChangeSet changes) {
        this.sharedWorkspaceCache.changed(changes);
        this.changedWithinTransaction(changes);
    }

    public void changedWithinTransaction(final ChangeSet changes) {
        this.cacheManager.onAllWorkspacesInTransaction(this.txn, new TransactionalWorkspaceCaches.OnEachTransactionalCache(){

            @Override
            public void execute(TransactionalWorkspaceCache cache) {
                cache.internalChangedWithinTransaction(changes);
            }
        });
    }

    @Override
    public void clear() {
        this.cacheManager.onAllWorkspacesInTransaction(this.txn, new TransactionalWorkspaceCaches.OnEachTransactionalCache(){

            @Override
            public void execute(TransactionalWorkspaceCache cache) {
                cache.internalClear();
            }
        });
    }

    void internalClear() {
        super.clear();
    }

    void internalChangedWithinTransaction(ChangeSet changes) {
        super.changed(changes);
    }

    @Override
    public void notify(ChangeSet changeSet) {
        this.sharedWorkspaceCache.notify(changeSet);
        super.notify(changeSet);
    }
}

