/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.binary.AbstractBinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.Database;
import org.modeshape.jcr.value.binary.FileSystemBinaryStore;
import org.modeshape.jcr.value.binary.StoredBinaryValue;
import org.modeshape.jcr.value.binary.TransientBinaryStore;

@ThreadSafe
public class DatabaseBinaryStore
extends AbstractBinaryStore {
    private static final boolean ALIVE = true;
    private static final boolean UNUSED = false;
    private FileSystemBinaryStore cache;
    private Database database;
    private final String driverClass;
    private final String connectionURL;
    private final String username;
    private final String password;
    private final String datasourceJNDILocation;

    public DatabaseBinaryStore(String driverClass, String connectionURL, String username, String password) {
        this.driverClass = driverClass;
        this.connectionURL = connectionURL;
        this.username = username;
        this.password = password;
        this.datasourceJNDILocation = null;
        this.cache = TransientBinaryStore.get();
    }

    public DatabaseBinaryStore(String datasourceJNDILocation) {
        this.driverClass = null;
        this.connectionURL = null;
        this.username = null;
        this.password = null;
        this.datasourceJNDILocation = datasourceJNDILocation;
        this.cache = TransientBinaryStore.get();
    }

    @Override
    public BinaryValue storeValue(InputStream stream) throws BinaryStoreException {
        BinaryValue temp = this.cache.storeValue(stream);
        try {
            BinaryKey key = new BinaryKey(temp.getKey().toString());
            if (this.contentExists(key, true)) {
                StoredBinaryValue storedBinaryValue = new StoredBinaryValue(this, key, temp.getSize());
                return storedBinaryValue;
            }
            if (this.contentExists(key, false)) {
                PreparedStatement sql = this.database.restoreContentSQL(key);
                Database.execute(sql);
                StoredBinaryValue storedBinaryValue = new StoredBinaryValue(this, key, temp.getSize());
                return storedBinaryValue;
            }
            PreparedStatement sql = this.database.insertContentSQL(key, temp.getStream());
            Database.execute(sql);
            StoredBinaryValue storedBinaryValue = new StoredBinaryValue(this, key, temp.getSize());
            return storedBinaryValue;
        }
        finally {
            this.cache.markAsUnused(temp.getKey());
        }
    }

    @Override
    public InputStream getInputStream(BinaryKey key) throws BinaryStoreException {
        ResultSet rs = Database.executeQuery(this.database.retrieveContentSQL(key, true));
        InputStream inputStream = Database.asStream(rs);
        if (inputStream == null) {
            try {
                throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{key, this.database.getConnection().getCatalog()}));
            }
            catch (SQLException e) {
                this.logger.debug((Throwable)e, "Unable to retrieve db information", new Object[0]);
            }
        }
        return inputStream;
    }

    @Override
    public void markAsUnused(Iterable<BinaryKey> keys) throws BinaryStoreException {
        for (BinaryKey key : keys) {
            PreparedStatement sql = this.database.markUnusedSQL(key);
            Database.executeUpdate(sql);
        }
    }

    @Override
    public void removeValuesUnusedLongerThan(long minimumAge, TimeUnit unit) throws BinaryStoreException {
        long deadline = System.currentTimeMillis() - unit.toMillis(minimumAge);
        PreparedStatement sql = this.database.removeExpiredContentSQL(deadline);
        Database.execute(sql);
    }

    @Override
    protected String getStoredMimeType(BinaryValue source) throws BinaryStoreException {
        this.checkContentExists(source);
        ResultSet rs = Database.executeQuery(this.database.retrieveMimeTypeSQL(source.getKey()));
        return Database.asString(rs);
    }

    private void checkContentExists(BinaryValue source) throws BinaryStoreException {
        if (!this.contentExists(source.getKey(), true)) {
            try {
                throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{source.getKey(), this.database.getConnection().getCatalog()}));
            }
            catch (SQLException e) {
                this.logger.debug("Cannot get catalog information", new Object[]{e});
            }
        }
    }

    @Override
    protected void storeMimeType(BinaryValue source, String mimeType) throws BinaryStoreException {
        PreparedStatement sql = this.database.updateMimeTypeSQL(source.getKey(), mimeType);
        Database.executeUpdate(sql);
    }

    @Override
    public String getExtractedText(BinaryValue source) throws BinaryStoreException {
        this.checkContentExists(source);
        ResultSet rs = Database.executeQuery(this.database.retrieveExtTextSQL(source.getKey()));
        return Database.asString(rs);
    }

    @Override
    public void storeExtractedText(BinaryValue source, String extractedText) throws BinaryStoreException {
        PreparedStatement sql = this.database.updateExtTextSQL(source.getKey(), extractedText);
        Database.executeUpdate(sql);
    }

    @Override
    public void start() {
        super.start();
        try {
            Connection connection = this.datasourceJNDILocation != null ? DatabaseBinaryStore.connect(this.datasourceJNDILocation) : DatabaseBinaryStore.connect(this.driverClass, this.connectionURL, this.username, this.password);
            this.database = new Database(connection);
            this.database.initialize();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Database doCreateDatabase(Connection connection) throws BinaryStoreException {
        return new Database(connection);
    }

    @Override
    public Iterable<BinaryKey> getAllBinaryKeys() throws BinaryStoreException {
        HashSet<BinaryKey> keys = new HashSet<BinaryKey>();
        try {
            PreparedStatement sql = this.database.retrieveBinaryKeys(keys);
            List<String> keysString = Database.asStringList(Database.executeQuery(sql));
            HashSet<BinaryKey> binaryKeys = new HashSet<BinaryKey>(keysString.size());
            for (String keyString : keysString) {
                binaryKeys.add(new BinaryKey(keyString));
            }
            return binaryKeys;
        }
        catch (Exception e) {
            throw new BinaryStoreException(e);
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.database != null) {
            this.database.disconnect();
        }
    }

    private boolean contentExists(BinaryKey key, boolean alive) throws BinaryStoreException {
        ResultSet rs = null;
        boolean error = false;
        try {
            rs = Database.executeQuery(this.database.retrieveContentSQL(key, alive));
            boolean bl = rs.next();
            return bl;
        }
        catch (SQLException e) {
            error = true;
            throw new BinaryStoreException(e);
        }
        catch (RuntimeException e) {
            error = true;
            throw e;
        }
        finally {
            block11: {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        if (error) break block11;
                        throw new BinaryStoreException(e);
                    }
                }
            }
        }
    }

    private static Connection connect(String jndiName) throws BinaryStoreException {
        DataSource dataSource = null;
        try {
            InitialContext context = new InitialContext();
            dataSource = (DataSource)context.lookup(jndiName);
        }
        catch (NamingException e) {
            throw new BinaryStoreException(e);
        }
        if (dataSource == null) {
            throw new BinaryStoreException("Datasource is not bound: " + jndiName);
        }
        try {
            return dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    private static Connection connect(String driverClass, String connectionURL, String username, String password) throws BinaryStoreException {
        try {
            Class.forName(driverClass);
        }
        catch (Exception e) {
            throw new BinaryStoreException(e);
        }
        try {
            return DriverManager.getConnection(connectionURL, username, password);
        }
        catch (Exception e) {
            throw new BinaryStoreException(e);
        }
    }
}

