/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary.infinispan;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.infinispan.Cache;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.value.binary.infinispan.RetryOperation;

class ChunkOutputStream
extends OutputStream {
    protected static final Logger LOGGER = Logger.getLogger(ChunkOutputStream.class);
    private static final int BUFFER_SIZE = 1024;
    protected final Cache<String, byte[]> blobCache;
    protected final String keyPrefix;
    protected int chunkIndex;
    private final ByteArrayOutputStream chunkBuffer;
    private final int chunkSize;
    private boolean closed;

    protected ChunkOutputStream(Cache<String, byte[]> blobCache, String keyPrefix) {
        this(blobCache, keyPrefix, 0x100000);
    }

    protected ChunkOutputStream(Cache<String, byte[]> blobCache, String keyPrefix, int chunkSize) {
        this.blobCache = blobCache;
        this.keyPrefix = keyPrefix;
        this.chunkIndex = 0;
        this.chunkBuffer = new ByteArrayOutputStream(1024);
        this.chunkSize = chunkSize;
    }

    protected int chunksCount() {
        return this.chunkIndex;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.chunkBuffer.size() == this.chunkSize) {
            this.storeBufferInBLOBCache();
        }
        this.chunkBuffer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len + this.chunkBuffer.size() <= this.chunkSize) {
            this.chunkBuffer.write(b, off, len);
        } else {
            int storeLength = this.chunkSize - this.chunkBuffer.size();
            this.write(b, off, storeLength);
            this.storeBufferInBLOBCache();
            this.write(b, off + storeLength, len - storeLength);
        }
    }

    @Override
    public void close() throws IOException {
        LOGGER.debug("Close. Buffer size at close: {0}", new Object[]{this.chunkBuffer.size()});
        if (this.closed) {
            LOGGER.debug("Stream already closed.", new Object[0]);
            return;
        }
        this.closed = true;
        if (this.chunkBuffer.size() > 0) {
            this.storeBufferInBLOBCache();
        }
    }

    private void storeBufferInBLOBCache() throws IOException {
        final byte[] chunk = this.chunkBuffer.toByteArray();
        try {
            new RetryOperation(){

                @Override
                protected boolean call() {
                    String chunkKey = ChunkOutputStream.this.keyPrefix + "-" + ChunkOutputStream.this.chunkIndex;
                    LOGGER.debug("Store chunk {0}", new Object[]{chunkKey});
                    ChunkOutputStream.this.blobCache.put((Object)chunkKey, (Object)chunk);
                    return true;
                }
            }.doTry();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        ++this.chunkIndex;
        this.chunkBuffer.reset();
    }
}

