/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.modeshape.common.collection.ReadOnlyIterator;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.RepositoryIndexColumnDefinition;
import org.modeshape.jcr.spi.index.IndexColumnDefinition;
import org.modeshape.jcr.spi.index.IndexDefinition;
import org.modeshape.jcr.spi.index.IndexDefinitionTemplate;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Property;

class RepositoryIndexDefinitionTemplate
implements IndexDefinitionTemplate {
    private String name;
    private String providerName;
    private IndexDefinition.IndexKind kind = IndexDefinition.IndexKind.DUPLICATES;
    private Name nodeTypeName = JcrNtLexicon.BASE;
    private String description = "";
    private boolean enabled = true;
    private List<IndexColumnDefinition> columnDefns = new ArrayList<IndexColumnDefinition>();
    private Map<Name, Property> extendedProperties = new HashMap<Name, Property>();

    RepositoryIndexDefinitionTemplate() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public IndexDefinition.IndexKind getKind() {
        return this.kind;
    }

    @Override
    public Name getNodeTypeName() {
        return this.nodeTypeName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean hasSingleColumn() {
        return this.columnDefns.size() == 1;
    }

    @Override
    public Property getProperty(Name propertyName) {
        return this.extendedProperties.get(propertyName);
    }

    @Override
    public Map<Name, Property> getProperties() {
        return this.extendedProperties;
    }

    @Override
    public Iterator<IndexColumnDefinition> iterator() {
        return new ReadOnlyIterator(this.columnDefns.iterator());
    }

    @Override
    public IndexDefinitionTemplate setName(String name) {
        CheckArg.isNotNull((Object)name, (String)"name");
        this.name = name;
        return this;
    }

    @Override
    public IndexDefinitionTemplate setProviderName(String providerName) {
        CheckArg.isNotNull((Object)providerName, (String)"providerName");
        this.providerName = providerName;
        return this;
    }

    @Override
    public IndexDefinitionTemplate setKind(IndexDefinition.IndexKind kind) {
        CheckArg.isNotNull((Object)((Object)kind), (String)"kind");
        this.kind = kind;
        return this;
    }

    @Override
    public IndexDefinitionTemplate setNodeTypeName(Name name) {
        this.nodeTypeName = name != null ? name : JcrNtLexicon.BASE;
        return this;
    }

    @Override
    public IndexDefinitionTemplate setDescription(String description) {
        this.description = description != null ? description : "";
        return this;
    }

    @Override
    public IndexDefinitionTemplate setColumnDefinitions(Iterable<? extends IndexColumnDefinition> columnDefinitions) {
        this.columnDefns.clear();
        for (IndexColumnDefinition indexColumnDefinition : columnDefinitions) {
            this.columnDefns.add(RepositoryIndexColumnDefinition.createFrom(indexColumnDefinition));
        }
        return this;
    }
}

