/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.transaction.Transaction;
import org.modeshape.jcr.NodeTypeSchemata;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.query.engine.NoOpQueryIndexWriter;
import org.modeshape.jcr.spi.index.provider.IndexProvider;
import org.modeshape.jcr.spi.index.provider.IndexWriter;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;

public class CompositeIndexWriter
implements IndexWriter {
    private final List<IndexWriter> writers;

    public static IndexWriter create(Iterable<IndexProvider> providers) {
        ArrayList<IndexWriter> writers = new ArrayList<IndexWriter>();
        for (IndexProvider provider : providers) {
            IndexWriter writer;
            if (provider == null || (writer = provider.getIndexWriter()) == null || writer.canBeSkipped()) continue;
            writers.add(writer);
        }
        if (writers.isEmpty()) {
            return NoOpQueryIndexWriter.INSTANCE;
        }
        if (writers.size() == 1) {
            return (IndexWriter)writers.get(0);
        }
        return new CompositeIndexWriter(writers);
    }

    protected CompositeIndexWriter(List<IndexWriter> writers) {
        this.writers = writers;
    }

    @Override
    public IndexWriter.IndexingContext createIndexingContext(Transaction txn) {
        return new Context(txn);
    }

    @Override
    public void clearAllIndexes() {
        for (IndexWriter writer : this.writers) {
            writer.clearAllIndexes();
        }
    }

    @Override
    public boolean canBeSkipped() {
        if (this.writers.isEmpty()) {
            return true;
        }
        for (IndexWriter writer : this.writers) {
            if (writer.canBeSkipped()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addToIndex(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, Iterator<Property> propertiesIterator, NodeTypeSchemata schemata, IndexWriter.IndexingContext txnCtx) {
        for (IndexWriter writer : this.writers) {
            writer.addToIndex(workspace, key, path, primaryType, mixinTypes, propertiesIterator, schemata, txnCtx);
        }
    }

    @Override
    public void updateIndex(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, Iterator<Property> properties, NodeTypeSchemata schemata, IndexWriter.IndexingContext txnCtx) {
        for (IndexWriter writer : this.writers) {
            writer.updateIndex(workspace, key, path, primaryType, mixinTypes, properties, schemata, txnCtx);
        }
    }

    @Override
    public void removeFromIndex(String workspace, Iterable<NodeKey> keys, IndexWriter.IndexingContext txnCtx) {
        for (IndexWriter writer : this.writers) {
            writer.removeFromIndex(workspace, keys, txnCtx);
        }
    }

    @Override
    public void addBinaryToIndex(Binary binary, IndexWriter.IndexingContext txnCtx) {
        for (IndexWriter writer : this.writers) {
            writer.addBinaryToIndex(binary, txnCtx);
        }
    }

    @Override
    public void removeBinariesFromIndex(Iterable<String> sha1s, IndexWriter.IndexingContext txnCtx) {
        for (IndexWriter writer : this.writers) {
            writer.removeBinariesFromIndex(sha1s, txnCtx);
        }
    }

    protected static final class Context
    implements IndexWriter.IndexingContext {
        private final Transaction txn;

        protected Context(Transaction txn) {
            this.txn = txn;
        }

        @Override
        public Transaction getTransaction() {
            return this.txn;
        }
    }
}

