/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.DynamicOperand;
import org.modeshape.jcr.query.model.StaticOperand;
import org.modeshape.jcr.query.model.Visitor;
import org.modeshape.jcr.query.model.Visitors;

@Immutable
public class SetCriteria
implements Constraint,
org.modeshape.jcr.api.query.qom.SetCriteria {
    private static final long serialVersionUID = 1L;
    private final DynamicOperand left;
    private final Collection<? extends StaticOperand> setOperands;

    public SetCriteria(DynamicOperand left, Collection<? extends StaticOperand> setOperands) {
        CheckArg.isNotNull((Object)left, (String)"left");
        CheckArg.isNotNull(setOperands, (String)"setOperands");
        CheckArg.isNotEmpty(setOperands, (String)"setOperands");
        this.left = left;
        this.setOperands = setOperands;
    }

    public SetCriteria(DynamicOperand left, StaticOperand ... setOperands) {
        CheckArg.isNotNull((Object)left, (String)"left");
        CheckArg.isNotNull((Object)setOperands, (String)"setOperands");
        CheckArg.isNotEmpty((Object[])setOperands, (String)"setOperands");
        this.left = left;
        this.setOperands = Collections.unmodifiableList(Arrays.asList(setOperands));
    }

    public final DynamicOperand leftOperand() {
        return this.left;
    }

    public final Collection<? extends StaticOperand> rightOperands() {
        return this.setOperands;
    }

    public DynamicOperand getOperand() {
        return this.leftOperand();
    }

    public Collection<? extends javax.jcr.query.qom.StaticOperand> getValues() {
        return this.rightOperands();
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.left.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SetCriteria) {
            SetCriteria that = (SetCriteria)obj;
            if (!this.left.equals(that.left)) {
                return false;
            }
            return this.setOperands.equals(that.setOperands);
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

