/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.bus;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.modeshape.common.collection.ring.RingBuffer;
import org.modeshape.common.collection.ring.RingBufferBuilder;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.bus.BusI18n;
import org.modeshape.jcr.bus.ChangeBus;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;

public final class RepositoryChangeBus
implements ChangeBus {
    protected static final Logger LOGGER = Logger.getLogger(RepositoryChangeBus.class);
    private static final int DEFAULT_SIZE = 1024;
    private final AtomicBoolean shutdown = new AtomicBoolean(true);
    private final Lock registrationLock = new ReentrantLock();
    private final Set<ChangeSetListener> inThreadListeners = new CopyOnWriteArraySet<ChangeSetListener>();
    private final RingBuffer<ChangeSet, ChangeSetListener> ringBuffer;

    public RepositoryChangeBus(String repositoryName, ExecutorService executor) {
        this.ringBuffer = RingBufferBuilder.withMultipleProducers((Executor)executor, (RingBuffer.ConsumerAdapter)new ChangeSetListenerConsumerAdapter()).ofSize(1024).named(repositoryName).garbageCollect(true).build();
    }

    @Override
    public boolean hasObservers() {
        if (this.shutdown.get()) {
            return false;
        }
        return !this.inThreadListeners.isEmpty() || this.ringBuffer.hasConsumers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean register(ChangeSetListener observer) {
        if (observer == null || this.shutdown.get()) {
            return false;
        }
        try {
            this.registrationLock.lock();
            boolean bl = this.ringBuffer.addConsumer((Object)observer);
            return bl;
        }
        finally {
            this.registrationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerInThread(ChangeSetListener observer) {
        if (observer == null || this.shutdown.get()) {
            return false;
        }
        try {
            this.registrationLock.lock();
            boolean bl = this.inThreadListeners.add(observer);
            return bl;
        }
        finally {
            this.registrationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregister(ChangeSetListener observer) {
        if (observer == null || this.shutdown.get()) {
            return false;
        }
        try {
            this.registrationLock.lock();
            boolean bl = this.ringBuffer.remove((Object)observer) || this.inThreadListeners.remove(observer);
            return bl;
        }
        finally {
            this.registrationLock.unlock();
        }
    }

    @Override
    public synchronized void start() throws Exception {
        this.shutdown.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        try {
            this.registrationLock.lock();
            this.inThreadListeners.clear();
            this.ringBuffer.shutdown();
        }
        finally {
            this.registrationLock.unlock();
        }
    }

    @Override
    public void notify(ChangeSet changeSet) {
        if (changeSet == null || !this.hasObservers()) {
            return;
        }
        if (this.shutdown.get()) {
            throw new IllegalStateException("Change bus has been already shut down, should not have any more observers");
        }
        this.ringBuffer.add((Object)changeSet);
        for (ChangeSetListener listener : this.inThreadListeners) {
            listener.notify(changeSet);
        }
    }

    protected class ChangeSetListenerConsumerAdapter
    implements RingBuffer.ConsumerAdapter<ChangeSet, ChangeSetListener> {
        protected ChangeSetListenerConsumerAdapter() {
        }

        public boolean consume(ChangeSetListener consumer, ChangeSet event, long position, long maxPosition) {
            consumer.notify(event);
            return true;
        }

        public void close(ChangeSetListener consumer) {
        }

        public void handleException(ChangeSetListener consumer, Throwable t, ChangeSet entry, long position, long maxPosition) {
            LOGGER.error(t, (I18nResource)BusI18n.errorProcessingEvent, new Object[]{entry.toString(), position});
        }
    }
}

