/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.util.concurrent.TimeoutException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.AllPathsCache;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.DocumentAlreadyExistsException;
import org.modeshape.jcr.cache.DocumentNotFoundException;
import org.modeshape.jcr.cache.LockFailureException;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.NodeNotFoundException;
import org.modeshape.jcr.cache.PathCache;
import org.modeshape.jcr.cache.ReferentialIntegrityException;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.SessionEnvironment;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.RecordingChanges;
import org.modeshape.jcr.cache.document.AbstractSessionCache;
import org.modeshape.jcr.cache.document.DocumentStore;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.cache.document.MutableChildReferences;
import org.modeshape.jcr.cache.document.SessionNode;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.txn.Transactions;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;

@ThreadSafe
public class WritableSessionCache
extends AbstractSessionCache {
    private static final AtomicInteger SAVE_NUMBER = new AtomicInteger(1);
    private static final int MAX_SAVE_NUMBER = 100;
    private static final Logger SAVE_LOGGER = Logger.getLogger((String)"org.modeshape.jcr.txn");
    private static final Logger LOGGER = Logger.getLogger(WritableSessionCache.class);
    private static final NodeKey REMOVED_KEY = new NodeKey("REMOVED_NODE_SHOULD_NEVER_BE_PERSISTED");
    private static final SessionNode REMOVED = new SessionNode(REMOVED_KEY, false);
    private static final int MAX_REPEAT_FOR_LOCK_ACQUISITION_TIMEOUT = 4;
    private static final long PAUSE_TIME_BEFORE_REPEAT_FOR_LOCK_ACQUISITION_TIMEOUT = 50L;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<NodeKey, SessionNode> changedNodes = new HashMap<NodeKey, SessionNode>();
    private Set<NodeKey> replacedNodes;
    private LinkedHashSet<NodeKey> changedNodesInOrder = new LinkedHashSet();
    private Map<NodeKey, SessionNode.ReferrerChanges> referrerChangesForRemovedNodes = new HashMap<NodeKey, SessionNode.ReferrerChanges>();
    private final Transactions txns;

    public WritableSessionCache(ExecutionContext context, WorkspaceCache workspaceCache, SessionEnvironment sessionContext) {
        super(context, workspaceCache, sessionContext);
        this.txns = sessionContext.getTransactions();
    }

    protected final void assertInSession(SessionNode node) {
        assert (this.changedNodes.get(node.getKey()) == node) : "Node " + node.getKey() + " is not in this session";
    }

    @Override
    protected Logger logger() {
        return LOGGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedNode getNode(NodeKey key) {
        CachedNode sessionNode = null;
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            sessionNode = this.changedNodes.get(key);
        }
        finally {
            lock.unlock();
        }
        if (sessionNode == REMOVED) {
            return null;
        }
        return sessionNode != null ? sessionNode : super.getNode(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SessionNode mutable(NodeKey key) {
        SessionNode sessionNode = null;
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            sessionNode = this.changedNodes.get(key);
        }
        finally {
            lock.unlock();
        }
        if (sessionNode == null || sessionNode == REMOVED) {
            sessionNode = new SessionNode(key, false);
            lock = this.lock.writeLock();
            try {
                lock.lock();
                sessionNode = this.changedNodes.get(key);
                if (sessionNode != null) return sessionNode;
                sessionNode = new SessionNode(key, false);
                this.changedNodes.put(key, sessionNode);
                this.changedNodesInOrder.add(key);
                return sessionNode;
            }
            finally {
                lock.unlock();
            }
        } else {
            if (this.changedNodesInOrder.contains(key)) return sessionNode;
            this.changedNodesInOrder.add(key);
        }
        return sessionNode;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClear() {
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            this.changedNodes.clear();
            this.changedNodesInOrder.clear();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClear(CachedNode node) {
        Path nodePath = node.getPath(this);
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            List<SessionNode> nodesToRemoveInOrder = this.getChangedNodesAtOrBelowChildrenFirst(nodePath);
            for (SessionNode nodeToRemove : nodesToRemoveInOrder) {
                NodeKey key = nodeToRemove.getKey();
                this.changedNodes.remove(key);
                this.changedNodesInOrder.remove(key);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private List<SessionNode> getChangedNodesAtOrBelowChildrenFirst(Path nodePath) {
        ArrayList<SessionNode> changedNodesChildrenFirst = new ArrayList<SessionNode>();
        for (NodeKey key : this.changedNodes.keySet()) {
            SessionNode changedNode = this.changedNodes.get(key);
            boolean isAtOrBelow = false;
            try {
                isAtOrBelow = changedNode.isAtOrBelow(this, nodePath);
            }
            catch (NodeNotFoundException e) {
                isAtOrBelow = false;
            }
            if (!isAtOrBelow) continue;
            int insertIndex = changedNodesChildrenFirst.size();
            Path changedNodePath = changedNode.getPath(this);
            for (int i = 0; i < changedNodesChildrenFirst.size(); ++i) {
                if (!((SessionNode)changedNodesChildrenFirst.get(i)).getPath(this).isAncestorOf(changedNodePath)) continue;
                insertIndex = i;
                break;
            }
            changedNodesChildrenFirst.add(insertIndex, changedNode);
        }
        return changedNodesChildrenFirst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<NodeKey> getChangedNodeKeys() {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            HashSet<NodeKey> hashSet = new HashSet<NodeKey>(this.changedNodes.keySet());
            return hashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<NodeKey> getChangedNodeKeysAtOrBelow(CachedNode srcNode) {
        CheckArg.isNotNull((Object)srcNode, (String)"srcNode");
        Path sourcePath = srcNode.getPath(this);
        WorkspaceCache workspaceCache = this.workspaceCache();
        AllPathsCache allPathsCache = new AllPathsCache(this, workspaceCache, this.context()){

            @Override
            protected Set<NodeKey> getAdditionalParentKeys(CachedNode node, NodeCache cache) {
                SessionNode sessionNode;
                SessionNode.ChangedAdditionalParents changed;
                Set<NodeKey> keys = super.getAdditionalParentKeys(node, cache);
                if (node instanceof SessionNode && (changed = (sessionNode = (SessionNode)node).additionalParents()) != null) {
                    keys = new HashSet<NodeKey>(keys);
                    keys.addAll(sessionNode.additionalParents().getRemovals());
                }
                return keys;
            }
        };
        Lock readLock = this.lock.readLock();
        HashSet<NodeKey> result = new HashSet<NodeKey>();
        try {
            readLock.lock();
            block3: for (Map.Entry<NodeKey, SessionNode> entry : this.changedNodes.entrySet()) {
                SessionNode changedNodeThisSession = entry.getValue();
                NodeKey changedNodeKey = entry.getKey();
                CachedNode changedNode = null;
                if (changedNodeThisSession == REMOVED) {
                    CachedNode persistentRemovedNode = workspaceCache.getNode(changedNodeKey);
                    if (persistentRemovedNode == null) {
                        result.add(changedNodeKey);
                        continue;
                    }
                    changedNode = persistentRemovedNode;
                } else {
                    changedNode = changedNodeThisSession;
                }
                for (Path validPath : allPathsCache.getPaths(changedNode)) {
                    if (!validPath.isAtOrBelow(sourcePath)) continue;
                    result.add(changedNodeKey);
                    continue block3;
                }
            }
            HashSet<NodeKey> hashSet = result;
            return hashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChanges() {
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            boolean bl = !this.changedNodesInOrder.isEmpty();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    protected final void logChangesBeingSaved(Iterable<NodeKey> firstNodesInOrder, Map<NodeKey, SessionNode> firstNodes, Iterable<NodeKey> secondNodesInOrder, Map<NodeKey, SessionNode> secondNodes) {
        if (SAVE_LOGGER.isTraceEnabled()) {
            SessionNode node;
            String txn = this.txns.currentTransactionId();
            int s = SAVE_NUMBER.getAndIncrement();
            if (s == 100) {
                SAVE_NUMBER.set(1);
            }
            int changes = 0;
            ExecutionContext context = this.getContext();
            String id = context.getId();
            String username = context.getSecurityContext().getUserName();
            NamespaceRegistry registry = context.getNamespaceRegistry();
            if (username == null) {
                username = "<anonymous>";
            }
            SAVE_LOGGER.trace("Save #{0} (part of transaction '{1}') by session {2}({3}) is persisting the following changes:", new Object[]{s, txn, username, id});
            for (NodeKey key : firstNodesInOrder) {
                node = this.changedNodes.get(key);
                if (node == null || !node.hasChanges()) continue;
                SAVE_LOGGER.trace(" #{0} {1}", new Object[]{s, node.getString(registry)});
                ++changes;
            }
            if (secondNodesInOrder != null) {
                for (NodeKey key : secondNodesInOrder) {
                    node = this.changedNodes.get(key);
                    if (node == null || !node.hasChanges()) continue;
                    SAVE_LOGGER.trace(" #{0} {1}", new Object[]{s, node.getString(registry)});
                    ++changes;
                }
            }
            SAVE_LOGGER.trace("Save #{0} (part of transaction '{1}') by session {2}({3}) completed persisting changes to {4} nodes", new Object[]{s, txn, username, id, changes});
        }
    }

    @Override
    public void save() {
        this.save(null);
    }

    /*
     * Exception decompiling
     */
    protected void save(SessionCache.PreSave preSaveOperation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void runPreSaveBeforeTransaction(SessionCache.PreSave preSaveOperation) throws Exception {
        if (preSaveOperation != null) {
            AbstractSessionCache.BasicSaveContext saveContext = new AbstractSessionCache.BasicSaveContext(this.context());
            for (MutableCachedNode mutableCachedNode : this.changedNodes.values()) {
                if (mutableCachedNode == REMOVED) continue;
                this.checkNodeNotRemovedByAnotherTransaction(mutableCachedNode);
                preSaveOperation.process(mutableCachedNode, saveContext);
            }
        }
    }

    private void runPreSaveAfterLocking(SessionCache.PreSave preSaveOperation, NodeCache persistedCache) throws Exception {
        if (preSaveOperation != null) {
            AbstractSessionCache.BasicSaveContext saveContext = new AbstractSessionCache.BasicSaveContext(this.context());
            for (MutableCachedNode mutableCachedNode : this.changedNodes.values()) {
                if (mutableCachedNode == REMOVED || mutableCachedNode.isNew()) continue;
                preSaveOperation.processAfterLocking(mutableCachedNode, saveContext, persistedCache);
            }
        }
    }

    protected void clearState() {
        this.changedNodes = new HashMap<NodeKey, SessionNode>();
        this.referrerChangesForRemovedNodes.clear();
        this.changedNodesInOrder.clear();
        this.replacedNodes = null;
        this.checkForTransaction();
    }

    protected void clearState(Iterable<NodeKey> savedNodesInOrder) {
        for (NodeKey savedNode : savedNodesInOrder) {
            this.changedNodes.remove(savedNode);
            this.changedNodesInOrder.remove(savedNode);
            if (this.replacedNodes == null) continue;
            this.replacedNodes.remove(savedNode);
        }
        this.checkForTransaction();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void save(SessionCache other, SessionCache.PreSave preSaveOperation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkNodeNotRemovedByAnotherTransaction(MutableCachedNode node) {
        String keyString = node.getKey().toString();
        if (!node.isNew() && !this.workspaceCache().documentStore().containsKey(keyString)) {
            throw new DocumentNotFoundException(keyString);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void save(Set<NodeKey> toBeSaved, SessionCache other, SessionCache.PreSave preSaveOperation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ChangeSet persistChanges(Iterable<NodeKey> changedNodesInOrder, WorkspaceCache persistedCache) {
        ExecutionContext context = this.context();
        String userId = context.getSecurityContext().getUserName();
        Map<String, String> userData = context.getData();
        DateTime timestamp = context.getValueFactories().getDateFactory().create();
        String workspaceName = persistedCache.getWorkspaceName();
        String repositoryKey = persistedCache.getRepositoryKey();
        RecordingChanges changes = new RecordingChanges(context.getId(), context.getProcessId(), repositoryKey, workspaceName, this.sessionContext().journalId());
        DocumentStore documentStore = persistedCache.documentStore();
        DocumentTranslator translator = persistedCache.translator();
        PathCache sessionPaths = new PathCache(this);
        PathCache workspacePaths = new PathCache(persistedCache);
        HashSet<NodeKey> removedNodes = null;
        HashSet<BinaryKey> unusedBinaryKeys = new HashSet<BinaryKey>();
        HashSet<NodeKey> renamedExternalNodes = new HashSet<NodeKey>();
        for (NodeKey nodeKey : changedNodesInOrder) {
            Path childPath;
            Path parentPath;
            ChildReference ref;
            EditableDocument doc;
            boolean isExternal;
            SessionNode node = this.changedNodes.get(nodeKey);
            String keyStr = nodeKey.toString();
            boolean bl = isExternal = !node.getKey().getSourceKey().equalsIgnoreCase(this.workspaceCache().getRootKey().getSourceKey());
            if (node == REMOVED) {
                CachedNode persisted = persistedCache.getNode(nodeKey);
                if (persisted == null) continue;
                if (removedNodes == null) {
                    removedNodes = new HashSet<NodeKey>();
                }
                Name primaryType = persisted.getPrimaryType(this);
                Set<Name> mixinTypes = persisted.getMixinTypes(this);
                Path path = workspacePaths.getPath(persisted);
                boolean queryable = persisted.isQueryable(this);
                changes.nodeRemoved(nodeKey, persisted.getParentKey(persistedCache), path, primaryType, mixinTypes, queryable);
                removedNodes.add(nodeKey);
                SessionNode.ReferrerChanges referrerChanges = this.referrerChangesForRemovedNodes.get(nodeKey);
                if (referrerChanges != null) {
                    doc = documentStore.get(keyStr).editDocumentContent();
                    translator.changeReferrers(doc, referrerChanges);
                }
                Iterator<Property> propertyIterator = persisted.getProperties(persistedCache);
                while (propertyIterator.hasNext()) {
                    Property property = propertyIterator.next();
                    if (!property.isBinary()) continue;
                    List<Object> value = property.isMultiple() ? Arrays.asList(property.getValuesAsArray()) : property.getFirstValue();
                    translator.decrementBinaryReferenceCount(value, unusedBinaryKeys);
                }
                continue;
            }
            Name primaryType = node.getPrimaryType(this);
            Set<Name> mixinTypes = node.getMixinTypes(this);
            boolean queryable = node.isQueryable(this);
            CachedNode persisted = null;
            Path newPath = sessionPaths.getPath(node);
            NodeKey newParent = node.newParent();
            doc = null;
            SessionNode.ChangedAdditionalParents additionalParents = node.additionalParents();
            if (node.isNew()) {
                doc = Schematic.newDocument();
                translator.setKey(doc, nodeKey);
                translator.setParents(doc, newParent, null, additionalParents);
                changes.nodeCreated(nodeKey, newParent, newPath, primaryType, mixinTypes, node.changedProperties(), queryable);
            } else {
                SchematicEntry nodeEntry = documentStore.get(keyStr);
                if (nodeEntry == null) {
                    if (isExternal && renamedExternalNodes.contains(nodeKey)) continue;
                    throw new DocumentNotFoundException(keyStr);
                }
                doc = nodeEntry.editDocumentContent();
                if (newParent != null) {
                    persisted = persistedCache.getNode(nodeKey);
                    Path oldPath = workspacePaths.getPath(persisted);
                    NodeKey oldParentKey = persisted.getParentKey(persistedCache);
                    if (!oldParentKey.equals(newParent) || additionalParents != null && !additionalParents.isEmpty()) {
                        translator.setParents(doc, node.newParent(), oldParentKey, additionalParents);
                    }
                    String workspaceKey = node.getKey().getWorkspaceKey();
                    boolean bl2 = persistedCache.getWorkspaceKey().equalsIgnoreCase(workspaceKey);
                    if (bl2) {
                        changes.nodeMoved(nodeKey, primaryType, mixinTypes, newParent, oldParentKey, newPath, oldPath, queryable);
                    }
                } else if (additionalParents != null) {
                    translator.setParents(doc, null, null, additionalParents);
                }
                SessionNode.MixinChanges mixinChanges = node.mixinChanges(false);
                if (mixinChanges != null && !mixinChanges.isEmpty()) {
                    Property oldProperty = translator.getProperty((Document)doc, JcrLexicon.MIXIN_TYPES);
                    translator.addPropertyValues(doc, JcrLexicon.MIXIN_TYPES, true, mixinChanges.getAdded(), unusedBinaryKeys);
                    translator.removePropertyValues(doc, JcrLexicon.MIXIN_TYPES, mixinChanges.getRemoved(), unusedBinaryKeys);
                    Property newProperty = translator.getProperty((Document)doc, JcrLexicon.MIXIN_TYPES);
                    if (oldProperty == null) {
                        changes.propertyAdded(nodeKey, primaryType, mixinTypes, newPath, newProperty, queryable);
                    } else if (newProperty == null) {
                        changes.propertyRemoved(nodeKey, primaryType, mixinTypes, newPath, oldProperty, queryable);
                    } else {
                        changes.propertyChanged(nodeKey, primaryType, mixinTypes, newPath, newProperty, oldProperty, queryable);
                    }
                }
            }
            SessionNode.LockChange lockChange = node.getLockChange();
            if (lockChange != null) {
                switch (lockChange) {
                    case LOCK_FOR_SESSION: 
                    case LOCK_FOR_NON_SESSION: {
                        if (!translator.isLocked(doc)) break;
                        throw new LockFailureException(nodeKey);
                    }
                }
            }
            boolean hasPropertyChanges = false;
            Set<Name> removedProperties = node.removedProperties();
            if (!removedProperties.isEmpty()) {
                assert (!node.isNew());
                if (persisted == null) {
                    persisted = persistedCache.getNode(nodeKey);
                }
                for (Name name : removedProperties) {
                    Property oldProperty = translator.removeProperty(doc, name, unusedBinaryKeys);
                    if (oldProperty == null) continue;
                    changes.propertyRemoved(nodeKey, primaryType, mixinTypes, newPath, oldProperty, queryable);
                    hasPropertyChanges = true;
                }
            }
            if (!node.changedProperties().isEmpty()) {
                if (!node.isNew() && persisted == null) {
                    persisted = persistedCache.getNode(nodeKey);
                }
                for (Map.Entry entry : node.changedProperties().entrySet()) {
                    Name name = (Name)entry.getKey();
                    Property prop = (Property)entry.getValue();
                    Property oldProperty = persisted != null ? persisted.getProperty(name, persistedCache) : null;
                    translator.setProperty(doc, prop, unusedBinaryKeys);
                    if (oldProperty == null) {
                        changes.propertyAdded(nodeKey, primaryType, mixinTypes, newPath, prop, queryable);
                        hasPropertyChanges = true;
                        continue;
                    }
                    if (!hasPropertyChanges && oldProperty.equals(prop)) continue;
                    changes.propertyChanged(nodeKey, primaryType, mixinTypes, newPath, prop, oldProperty, queryable);
                    hasPropertyChanges = true;
                }
            }
            SessionNode.ChangedChildren changedChildren = node.changedChildren();
            MutableChildReferences mutableChildReferences = node.appended(false);
            if ((changedChildren == null || changedChildren.isEmpty()) && mutableChildReferences != null && !mutableChildReferences.isEmpty()) {
                translator.changeChildren(doc, changedChildren, mutableChildReferences);
            } else if (changedChildren != null && !changedChildren.isEmpty()) {
                if (!changedChildren.getRemovals().isEmpty()) {
                    for (NodeKey removed : changedChildren.getRemovals()) {
                        CachedNode persistent = persistedCache.getNode(removed);
                        if (persistent == null || mutableChildReferences == null || !mutableChildReferences.hasChild(persistent.getKey())) continue;
                        ChildReference appendedChildRef = node.getChildReferences(this).getChild(persistent.getKey());
                        newPath = this.pathFactory().create(sessionPaths.getPath(node), appendedChildRef.getSegment());
                        Path oldPath = workspacePaths.getPath(persistent);
                        changes.nodeReordered(persistent.getKey(), primaryType, mixinTypes, node.getKey(), newPath, oldPath, null, queryable);
                    }
                }
                translator.changeChildren(doc, changedChildren, mutableChildReferences);
                Map<NodeKey, Name> newNames = changedChildren.getNewNames();
                if (!newNames.isEmpty()) {
                    for (Map.Entry<NodeKey, Name> renameEntry : newNames.entrySet()) {
                        NodeKey renamedKey = renameEntry.getKey();
                        CachedNode oldRenamedNode = persistedCache.getNode(renamedKey);
                        if (oldRenamedNode == null) continue;
                        Path renamedFromPath = workspacePaths.getPath(oldRenamedNode);
                        Path renamedToPath = this.pathFactory().create(renamedFromPath.getParent(), renameEntry.getValue());
                        changes.nodeRenamed(renamedKey, renamedToPath, renamedFromPath.getLastSegment(), primaryType, mixinTypes, queryable);
                        if (!isExternal) continue;
                        renamedExternalNodes.add(renamedKey);
                    }
                }
                Map<NodeKey, SessionNode.Insertions> insertionsByBeforeKey = changedChildren.getInsertionsByBeforeKey();
                for (SessionNode.Insertions insertion : insertionsByBeforeKey.values()) {
                    for (ChildReference insertedRef : insertion.inserted()) {
                        Path insertedBeforePath;
                        CachedNode insertedNodePersistent = persistedCache.getNode(insertedRef);
                        CachedNode insertedNode = this.getNode(insertedRef.getKey());
                        Path nodeNewPath = sessionPaths.getPath(insertedNode);
                        if (insertedNodePersistent != null) {
                            Path nodeOldPath = workspacePaths.getPath(insertedNodePersistent);
                            insertedBeforePath = null;
                            CachedNode insertedBeforeNode = persistedCache.getNode(insertion.insertedBefore());
                            if (insertedBeforeNode != null) {
                                insertedBeforePath = workspacePaths.getPath(insertedBeforeNode);
                                boolean isSnsReordering = nodeOldPath.getLastSegment().getName().equals(insertedBeforePath.getLastSegment().getName());
                                if (isSnsReordering) {
                                    nodeNewPath = insertedBeforePath;
                                }
                            }
                            changes.nodeReordered(insertedRef.getKey(), insertedNode.getPrimaryType(this), insertedNode.getMixinTypes(this), node.getKey(), nodeNewPath, nodeOldPath, insertedBeforePath, queryable);
                            continue;
                        }
                        CachedNode insertedBeforeNode = this.getNode(insertion.insertedBefore().getKey());
                        insertedBeforePath = sessionPaths.getPath(insertedBeforeNode);
                        changes.nodeReordered(insertedRef.getKey(), insertedNode.getPrimaryType(this), insertedNode.getMixinTypes(this), node.getKey(), nodeNewPath, null, insertedBeforePath, queryable);
                    }
                }
            }
            SessionNode.ReferrerChanges referrerChanges = node.getReferrerChanges();
            boolean nodeChanged = false;
            if (referrerChanges != null && !referrerChanges.isEmpty()) {
                translator.changeReferrers(doc, referrerChanges);
                changes.nodeChanged(nodeKey, newPath, primaryType, mixinTypes, queryable);
                nodeChanged = true;
            }
            for (Map.Entry<String, String> federatedSegment : node.getAddedFederatedSegments().entrySet()) {
                String externalNodeKey = federatedSegment.getKey();
                String childName = federatedSegment.getValue();
                translator.addFederatedSegment(doc, externalNodeKey, childName);
                if (nodeChanged) continue;
                changes.nodeChanged(nodeKey, newPath, primaryType, mixinTypes, queryable);
                nodeChanged = true;
            }
            Set<String> removedFederatedSegments = node.getRemovedFederatedSegments();
            if (!removedFederatedSegments.isEmpty()) {
                translator.removeFederatedSegments(doc, node.getRemovedFederatedSegments());
                if (!nodeChanged) {
                    changes.nodeChanged(nodeKey, newPath, primaryType, mixinTypes, queryable);
                    nodeChanged = true;
                }
            }
            if (!queryable) {
                translator.setQueryable(doc, false);
            }
            if (node.isNew()) {
                if (documentStore.storeDocument(keyStr, (Document)doc) != null) {
                    if (this.replacedNodes != null && this.replacedNodes.contains(nodeKey)) {
                        documentStore.localStore().put(keyStr, (Document)doc);
                    } else {
                        if (removedNodes == null || !removedNodes.contains(nodeKey)) throw new DocumentAlreadyExistsException(keyStr);
                        documentStore.localStore().put(keyStr, (Document)doc);
                        removedNodes.remove(nodeKey);
                    }
                }
            } else {
                boolean externalNodeChanged;
                boolean bl3 = externalNodeChanged = isExternal && (hasPropertyChanges || node.hasNonPropertyChanges() || node.changedChildren().renameCount() > 0);
                if (externalNodeChanged) {
                    documentStore.updateDocument(keyStr, (Document)doc, node);
                }
            }
            if (additionalParents == null) continue;
            for (NodeKey parentKey : additionalParents.getAdditions()) {
                SessionNode parent = this.changedNodes.get(parentKey);
                if (parent == null) continue;
                ref = parent.getChildReferences(this).getChild(nodeKey);
                parentPath = sessionPaths.getPath(parent);
                childPath = this.pathFactory().create(parentPath, ref.getSegment());
                changes.nodeCreated(nodeKey, parentKey, childPath, primaryType, mixinTypes, null, queryable);
            }
            for (NodeKey parentKey : additionalParents.getRemovals()) {
                CachedNode persistedParent = persistedCache.getNode(parentKey);
                if (persistedParent == null || (ref = persistedParent.getChildReferences(this).getChild(nodeKey)) == null) continue;
                parentPath = workspacePaths.getPath(persistedParent);
                childPath = this.pathFactory().create(parentPath, ref.getSegment());
                changes.nodeRemoved(nodeKey, parentKey, childPath, primaryType, mixinTypes, queryable);
            }
        }
        if (removedNodes != null) {
            assert (!removedNodes.isEmpty());
            HashSet<NodeKey> referrers = new HashSet<NodeKey>();
            for (NodeKey removedKey : removedNodes) {
                SchematicEntry entry = documentStore.get(removedKey.toString());
                if (entry == null) continue;
                Document doc = documentStore.get(removedKey.toString()).getContentAsDocument();
                referrers.addAll(translator.getReferrers(doc, CachedNode.ReferenceType.STRONG));
            }
            referrers.removeAll(removedNodes);
            if (!referrers.isEmpty()) {
                throw new ReferentialIntegrityException((Set<NodeKey>)removedNodes, referrers);
            }
            for (NodeKey removedKey : removedNodes) {
                documentStore.remove(removedKey.toString());
            }
        }
        if (!unusedBinaryKeys.isEmpty()) {
            for (BinaryKey binaryKey : unusedBinaryKeys) {
                changes.binaryValueNoLongerUsed(binaryKey);
            }
        }
        changes.setChangedNodes(this.changedNodes.keySet());
        changes.freeze(userId, userData, timestamp);
        return changes;
    }

    private WorkspaceCache lockNodes(Iterable<NodeKey> changedNodesInOrder) {
        DocumentStore documentStore = this.workspaceCache().documentStore();
        if (documentStore.updatesRequirePreparing()) {
            if (LOGGER.isDebugEnabled() && !this.changedNodes.isEmpty()) {
                LOGGER.debug("Attempting to lock nodes in Infinispan: {0}", new Object[]{this.changedNodes.keySet()});
            }
            HashSet<String> keysToLock = new HashSet<String>();
            for (NodeKey key : changedNodesInOrder) {
                SessionNode node = this.changedNodes.get(key);
                if (node == REMOVED || node.isNew()) continue;
                String keyStr = key.toString();
                keysToLock.add(keyStr);
            }
            if (!documentStore.prepareDocumentsForUpdate(keysToLock)) {
                if (!documentStore.prepareDocumentsForUpdate(keysToLock)) {
                    throw new TimeoutException("Unable to acquire storage locks: " + keysToLock);
                }
                if (LOGGER.isDebugEnabled() && !keysToLock.isEmpty()) {
                    LOGGER.debug("Locked the nodes: {0}", new Object[]{keysToLock});
                }
            } else if (LOGGER.isDebugEnabled() && !keysToLock.isEmpty()) {
                LOGGER.debug("Locked the nodes: {0}", new Object[]{keysToLock});
            }
        } else {
            LOGGER.debug("Infinispan is not configured with pessimistic locks, no nodes will be locked", new Object[0]);
        }
        return this.workspaceCache().persistedCache(changedNodesInOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionNode add(SessionNode newNode) {
        assert (newNode != REMOVED);
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            NodeKey key = newNode.getKey();
            SessionNode node = this.changedNodes.put(key, newNode);
            if (node != null) {
                if (node != REMOVED) {
                    this.changedNodes.put(key, node);
                    SessionNode sessionNode = node;
                    return sessionNode;
                }
                if (this.replacedNodes == null) {
                    this.replacedNodes = new HashSet<NodeKey>();
                }
                this.replacedNodes.add(key);
            }
            this.changedNodesInOrder.add(key);
            SessionNode sessionNode = newNode;
            return sessionNode;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(NodeKey key) {
        assert (key != null);
        WorkspaceCache workspace = this.workspaceCache();
        CachedNode topNode = this.getNode(key);
        if (topNode == null) {
            throw new NodeNotFoundException(key);
        }
        HashMap<NodeKey, SessionNode> removed = new HashMap<NodeKey, SessionNode>();
        LinkedHashSet<NodeKey> addToChangedNodes = new LinkedHashSet<NodeKey>();
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            LinkedList<NodeKey> keys = new LinkedList<NodeKey>();
            keys.add(key);
            while (!keys.isEmpty()) {
                NodeKey nodeKey = (NodeKey)keys.remove();
                SessionNode node = this.changedNodes.put(nodeKey, REMOVED);
                boolean cleanupReferences = false;
                ChildReferences children = null;
                if (node != null) {
                    if (node == REMOVED) continue;
                    children = node.getChildReferences(this);
                    removed.put(nodeKey, node);
                    this.referrerChangesForRemovedNodes.put(nodeKey, node.getReferrerChanges());
                    cleanupReferences = true;
                } else {
                    addToChangedNodes.add(nodeKey);
                    CachedNode persisted = workspace.getNode(nodeKey);
                    if (persisted == null) continue;
                    children = persisted.getChildReferences(workspace);
                    Iterator<Property> it = persisted.getProperties(workspace);
                    while (it.hasNext()) {
                        Property property = it.next();
                        if (property == null || !property.isReference()) continue;
                        this.changedNodes.remove(nodeKey);
                        node = this.mutable(nodeKey);
                        if (node != null) {
                            cleanupReferences = true;
                        }
                        this.changedNodes.put(nodeKey, REMOVED);
                    }
                }
                if (cleanupReferences) {
                    assert (node != null);
                    node.removeAllReferences(this);
                }
                assert (children != null);
                for (ChildReference child : children) {
                    NodeKey childKey = child.getKey();
                    if (!childKey.getSourceKey().equalsIgnoreCase(key.getSourceKey())) continue;
                    keys.add(childKey);
                }
            }
            this.changedNodesInOrder.addAll(addToChangedNodes);
        }
        catch (RuntimeException e) {
            try {
                this.changedNodes.putAll(removed);
            }
            catch (RuntimeException e2) {
                I18n msg = JcrI18n.failedWhileRollingBackDestroyToRuntimeError;
                LOGGER.error((Throwable)e2, (I18nResource)msg, new Object[]{e2.getMessage(), e.getMessage()});
            }
            finally {
                throw e;
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isDestroyed(NodeKey key) {
        return this.changedNodes.get(key) == REMOVED;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        NamespaceRegistry reg = this.context().getNamespaceRegistry();
        sb.append("Session ").append(this.context().getId()).append(" to workspace '").append(this.workspaceName());
        for (NodeKey key : this.changedNodesInOrder) {
            SessionNode changes = this.changedNodes.get(key);
            if (changes == null) continue;
            sb.append("\n ");
            sb.append(changes.getString(reg));
        }
        return sb.toString();
    }
}

