/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.util.Map;
import java.util.Set;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.AbstractPropertyChange;
import org.modeshape.jcr.cache.change.PropertyChanged;
import org.modeshape.jcr.index.local.LocalDuplicateIndex;
import org.modeshape.jcr.index.local.LocalEnumeratedIndex;
import org.modeshape.jcr.index.local.LocalIndex;
import org.modeshape.jcr.index.local.LocalUniqueIndex;
import org.modeshape.jcr.spi.index.provider.IndexChangeAdapter;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.ValueFactory;

public class IndexChangeAdapters {
    public static IndexChangeAdapter forNodeDepth(ExecutionContext context, String workspaceName, LocalDuplicateIndex<Long> index) {
        return new NodeDepthChangeAdapter(context, workspaceName, index);
    }

    public static IndexChangeAdapter forNodeName(ExecutionContext context, String workspaceName, LocalDuplicateIndex<Name> index) {
        return new NodeNameChangeAdapter(context, workspaceName, index);
    }

    public static IndexChangeAdapter forNodeLocalName(ExecutionContext context, String workspaceName, LocalDuplicateIndex<String> index) {
        return new NodeLocalNameChangeAdapter(context, workspaceName, index);
    }

    public static IndexChangeAdapter forNodePath(ExecutionContext context, String workspaceName, LocalDuplicateIndex<Path> index) {
        return new NodePathChangeAdapter(context, workspaceName, index);
    }

    public static IndexChangeAdapter forPrimaryType(ExecutionContext context, String workspaceName, LocalDuplicateIndex<Name> index) {
        return new PrimaryTypeChangeAdatper(context, workspaceName, index);
    }

    public static IndexChangeAdapter forMixinTypes(ExecutionContext context, String workspaceName, LocalDuplicateIndex<Name> index) {
        return new PrimaryTypeChangeAdatper(context, workspaceName, index);
    }

    public static <T> IndexChangeAdapter forSingleValuedProperty(ExecutionContext context, String workspaceName, Name propertyName, ValueFactory<T> factory, LocalDuplicateIndex<T> index) {
        return new SingleValuedPropertyChangeAdapter<T>(context, workspaceName, propertyName, factory, index);
    }

    public static <T> IndexChangeAdapter forMultiValuedProperty(ExecutionContext context, String workspaceName, Name propertyName, ValueFactory<T> factory, LocalDuplicateIndex<T> index) {
        return new MultiValuedPropertyChangeAdapter<T>(context, workspaceName, propertyName, factory, index);
    }

    public static <T> IndexChangeAdapter forUniqueValuedProperty(ExecutionContext context, String workspaceName, Name propertyName, ValueFactory<T> factory, LocalUniqueIndex<T> index) {
        return new UniquePropertyChangeAdapter<T>(context, workspaceName, propertyName, factory, index);
    }

    public static IndexChangeAdapter forSingleValuedEnumeratedProperty(ExecutionContext context, String workspaceName, Name propertyName, LocalEnumeratedIndex index) {
        return new SingleValuedEnumeratedPropertyChangeAdapter(context, workspaceName, propertyName, index);
    }

    public static IndexChangeAdapter forMultiValuedEnumeratedProperty(ExecutionContext context, String workspaceName, Name propertyName, LocalEnumeratedIndex index) {
        return new MultiValuedEnumeratedPropertyChangeAdapter(context, workspaceName, propertyName, index);
    }

    public static IndexChangeAdapter forNodeTypes(ExecutionContext context, String workspaceName, LocalIndex<String> index) {
        return new NodeTypesChangeAdapter(context, workspaceName, index);
    }

    private IndexChangeAdapters() {
    }

    protected static String nodeKey(NodeKey key) {
        return key.toString();
    }

    protected static final class NodeTypesChangeAdapter
    extends EnumeratedPropertyChangeAdapter {
        public NodeTypesChangeAdapter(ExecutionContext context, String workspaceName, LocalIndex<String> index) {
            super(context, workspaceName, null, index);
        }

        protected final void removeValues(NodeKey key, Property oldProperty) {
            for (Object value : oldProperty) {
                this.removeValue(key, value);
            }
        }

        protected final void removeValue(NodeKey key, Object value) {
            this.index.remove(IndexChangeAdapters.nodeKey(key), this.convert(value));
        }

        @Override
        protected void addNode(String workspaceName, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties, boolean queryable) {
            this.addValue(key, primaryType);
            if (!mixinTypes.isEmpty()) {
                for (Name mixinType : mixinTypes) {
                    this.addValue(key, mixinType);
                }
            }
        }

        @Override
        protected void modifyProperties(NodeKey key, Map<Name, AbstractPropertyChange> propChanges) {
            PropertyChanged change;
            AbstractPropertyChange propChange = propChanges.get(JcrLexicon.PRIMARY_TYPE);
            if (propChange instanceof PropertyChanged) {
                change = (PropertyChanged)propChange;
                this.addValue(key, change.getNewProperty().getFirstValue());
                this.removeValue(key, change.getOldProperty().getFirstValue());
            }
            if ((propChange = propChanges.get(JcrLexicon.MIXIN_TYPES)) instanceof PropertyChanged) {
                change = (PropertyChanged)propChange;
                this.removeValues(key, change.getOldProperty());
                this.addValues(key, change.getNewProperty());
            }
        }

        @Override
        protected void removeNode(String workspaceName, NodeKey key, NodeKey parentKey, Path path, Name primaryType, Set<Name> mixinTypes, boolean queryable) {
            this.removeValues(key);
        }
    }

    protected static final class MultiValuedEnumeratedPropertyChangeAdapter
    extends EnumeratedPropertyChangeAdapter {
        public MultiValuedEnumeratedPropertyChangeAdapter(ExecutionContext context, String workspaceName, Name propertyName, LocalEnumeratedIndex index) {
            super(context, workspaceName, propertyName, index);
        }
    }

    protected static final class SingleValuedEnumeratedPropertyChangeAdapter
    extends EnumeratedPropertyChangeAdapter {
        public SingleValuedEnumeratedPropertyChangeAdapter(ExecutionContext context, String workspaceName, Name propertyName, LocalEnumeratedIndex index) {
            super(context, workspaceName, propertyName, index);
        }

        @Override
        protected void addValues(NodeKey key, Property property) {
            this.index.add(IndexChangeAdapters.nodeKey(key), this.convert(property.getFirstValue()));
        }
    }

    protected static abstract class EnumeratedPropertyChangeAdapter
    extends AbstractPropertyChangeAdapter<String> {
        protected final LocalIndex<String> index;

        public EnumeratedPropertyChangeAdapter(ExecutionContext context, String workspaceName, Name propertyName, LocalIndex<String> index) {
            super(context, workspaceName, propertyName, context.getValueFactories().getStringFactory());
            this.index = index;
        }

        @Override
        protected void addValues(NodeKey key, Property property) {
            for (Object value : property) {
                this.index.add(IndexChangeAdapters.nodeKey(key), (String)this.convert(value));
            }
        }

        @Override
        protected final void addValue(NodeKey key, Object value) {
            this.index.add(IndexChangeAdapters.nodeKey(key), (String)this.convert(value));
        }

        @Override
        protected void removeValues(NodeKey key) {
            this.index.remove(IndexChangeAdapters.nodeKey(key));
        }
    }

    protected static final class UniquePropertyChangeAdapter<T>
    extends AbstractPropertyChangeAdapter<T> {
        protected final LocalUniqueIndex<T> index;

        public UniquePropertyChangeAdapter(ExecutionContext context, String workspaceName, Name propertyName, ValueFactory<T> valueFactory, LocalUniqueIndex<T> index) {
            super(context, workspaceName, propertyName, valueFactory);
            this.index = index;
        }

        @Override
        protected void addValues(NodeKey key, Property property) {
            this.index.add(IndexChangeAdapters.nodeKey(key), this.convert(property.getFirstValue()));
        }

        @Override
        protected final void addValue(NodeKey key, Object value) {
            this.index.add(IndexChangeAdapters.nodeKey(key), this.convert(value));
        }

        @Override
        protected void removeValues(NodeKey key) {
            this.index.remove(IndexChangeAdapters.nodeKey(key));
        }
    }

    protected static final class MixinTypesChangeAdatper
    extends PropertyChangeAdapter<Name> {
        public MixinTypesChangeAdatper(ExecutionContext context, String workspaceName, LocalDuplicateIndex<Name> index) {
            super(context, workspaceName, JcrLexicon.MIXIN_TYPES, context.getValueFactories().getNameFactory(), index);
        }

        @Override
        protected void addNode(String workspaceName, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties, boolean queryable) {
            if (mixinTypes != null && !mixinTypes.isEmpty()) {
                for (Name mixinType : mixinTypes) {
                    this.addValue(key, mixinType);
                }
            }
        }
    }

    protected static final class PrimaryTypeChangeAdatper
    extends PropertyChangeAdapter<Name> {
        public PrimaryTypeChangeAdatper(ExecutionContext context, String workspaceName, LocalDuplicateIndex<Name> index) {
            super(context, workspaceName, JcrLexicon.PRIMARY_TYPE, context.getValueFactories().getNameFactory(), index);
        }

        @Override
        protected void addNode(String workspaceName, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties, boolean queryable) {
            this.addValue(key, primaryType);
        }
    }

    protected static final class MultiValuedPropertyChangeAdapter<T>
    extends PropertyChangeAdapter<T> {
        public MultiValuedPropertyChangeAdapter(ExecutionContext context, String workspaceName, Name propertyName, ValueFactory<T> valueFactory, LocalDuplicateIndex<T> index) {
            super(context, workspaceName, propertyName, valueFactory, index);
        }
    }

    protected static final class SingleValuedPropertyChangeAdapter<T>
    extends PropertyChangeAdapter<T> {
        public SingleValuedPropertyChangeAdapter(ExecutionContext context, String workspaceName, Name propertyName, ValueFactory<T> valueFactory, LocalDuplicateIndex<T> index) {
            super(context, workspaceName, propertyName, valueFactory, index);
        }

        @Override
        protected void addValues(NodeKey key, Property property) {
            this.index.add(IndexChangeAdapters.nodeKey(key), this.convert(property.getFirstValue()));
        }
    }

    protected static abstract class PropertyChangeAdapter<T>
    extends AbstractPropertyChangeAdapter<T> {
        protected final LocalDuplicateIndex<T> index;

        public PropertyChangeAdapter(ExecutionContext context, String workspaceName, Name propertyName, ValueFactory<T> valueFactory, LocalDuplicateIndex<T> index) {
            super(context, workspaceName, propertyName, valueFactory);
            this.index = index;
        }

        @Override
        protected void addValues(NodeKey key, Property property) {
            for (Object value : property) {
                this.index.add(IndexChangeAdapters.nodeKey(key), this.convert(value));
            }
        }

        @Override
        protected final void addValue(NodeKey key, Object value) {
            this.index.add(IndexChangeAdapters.nodeKey(key), this.convert(value));
        }

        @Override
        protected void removeValues(NodeKey key) {
            this.index.remove(IndexChangeAdapters.nodeKey(key));
        }
    }

    protected static abstract class AbstractPropertyChangeAdapter<T>
    extends IndexChangeAdapter {
        protected final Name propertyName;
        protected final ValueFactory<T> valueFactory;

        public AbstractPropertyChangeAdapter(ExecutionContext context, String workspaceName, Name propertyName, ValueFactory<T> valueFactory) {
            super(context, workspaceName);
            this.propertyName = propertyName;
            this.valueFactory = valueFactory;
        }

        protected final T convert(Object value) {
            return this.valueFactory.create(value);
        }

        protected abstract void addValues(NodeKey var1, Property var2);

        protected abstract void addValue(NodeKey var1, Object var2);

        protected abstract void removeValues(NodeKey var1);

        @Override
        protected void addNode(String workspaceName, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties, boolean queryable) {
            Property prop = properties.getProperty(this.propertyName);
            if (prop != null) {
                this.addValues(key, prop);
            }
        }

        @Override
        protected void modifyProperties(NodeKey key, Map<Name, AbstractPropertyChange> propChanges) {
            AbstractPropertyChange propChange = propChanges.get(this.propertyName);
            if (propChange instanceof PropertyChanged) {
                PropertyChanged change = (PropertyChanged)propChange;
                this.removeValues(key);
                this.addValues(key, change.getNewProperty());
            }
        }

        @Override
        protected void removeNode(String workspaceName, NodeKey key, NodeKey parentKey, Path path, Name primaryType, Set<Name> mixinTypes, boolean queryable) {
            this.removeValues(key);
        }
    }

    protected static final class NodePathChangeAdapter
    extends PathBasedChangeAdapter<Path> {
        public NodePathChangeAdapter(ExecutionContext context, String workspaceName, LocalDuplicateIndex<Path> index) {
            super(context, workspaceName, index, true);
        }

        @Override
        protected Path convert(Path path) {
            return path;
        }

        @Override
        protected Path convertRoot(Path path) {
            return path;
        }
    }

    protected static final class NodeLocalNameChangeAdapter
    extends PathBasedChangeAdapter<String> {
        public NodeLocalNameChangeAdapter(ExecutionContext context, String workspaceName, LocalDuplicateIndex<String> index) {
            super(context, workspaceName, index, true);
        }

        @Override
        protected String convert(Path path) {
            return path.getLastSegment().getName().getLocalName();
        }

        @Override
        protected String convertRoot(Path path) {
            return "";
        }
    }

    protected static final class NodeNameChangeAdapter
    extends PathBasedChangeAdapter<Name> {
        public NodeNameChangeAdapter(ExecutionContext context, String workspaceName, LocalDuplicateIndex<Name> index) {
            super(context, workspaceName, index, true);
        }

        @Override
        protected Name convert(Path path) {
            return path.getLastSegment().getName();
        }

        @Override
        protected Name convertRoot(Path path) {
            return Path.ROOT_NAME;
        }
    }

    protected static final class NodeDepthChangeAdapter
    extends PathBasedChangeAdapter<Long> {
        public NodeDepthChangeAdapter(ExecutionContext context, String workspaceName, LocalDuplicateIndex<Long> index) {
            super(context, workspaceName, index, true);
        }

        @Override
        protected Long convert(Path path) {
            return path.size();
        }

        @Override
        protected Long convertRoot(Path path) {
            return path.size();
        }
    }

    protected static abstract class PathBasedChangeAdapter<T>
    extends IndexChangeAdapter {
        private final LocalDuplicateIndex<T> index;
        private final boolean includeRoot;

        protected PathBasedChangeAdapter(ExecutionContext context, String workspaceName, LocalDuplicateIndex<T> index, boolean includeRoot) {
            super(context, workspaceName);
            this.index = index;
            this.includeRoot = includeRoot;
        }

        protected abstract T convertRoot(Path var1);

        protected abstract T convert(Path var1);

        @Override
        protected void addNode(String workspaceName, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties, boolean queryable) {
            if (path.isRoot() && this.includeRoot) {
                this.index.add(IndexChangeAdapters.nodeKey(key), this.convertRoot(path));
            } else {
                this.index.add(IndexChangeAdapters.nodeKey(key), this.convert(path));
            }
        }

        @Override
        protected void moveNode(String workspaceName, NodeKey key, Name primaryType, Set<Name> mixinTypes, NodeKey oldParent, NodeKey newParent, Path newPath, Path oldPath, boolean queryable) {
            String nodeKey = IndexChangeAdapters.nodeKey(key);
            if (this.includeRoot) {
                if (oldPath.isRoot()) {
                    this.index.remove(nodeKey);
                }
                if (newPath.isRoot()) {
                    this.index.add(nodeKey, this.convertRoot(newPath));
                }
            } else {
                if (!oldPath.isRoot()) {
                    this.index.remove(nodeKey);
                }
                if (!newPath.isRoot()) {
                    this.index.add(nodeKey, this.convertRoot(newPath));
                }
            }
        }

        @Override
        protected void removeNode(String workspaceName, NodeKey key, NodeKey parentKey, Path path, Name primaryType, Set<Name> mixinTypes, boolean queryable) {
            if (this.includeRoot || path.isRoot()) {
                this.index.remove(IndexChangeAdapters.nodeKey(key));
            }
        }
    }
}

