/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.journal;

import java.io.File;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.RepositoryException;
import org.infinispan.schematic.document.ThreadSafe;
import org.joda.time.DateTime;
import org.mapdb.Atomic;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.common.util.TimeBasedKeys;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.journal.ChangeJournal;
import org.modeshape.jcr.journal.JournalRecord;

@ThreadSafe
public class LocalJournal
implements ChangeJournal {
    private static final Logger LOGGER = Logger.getLogger(LocalJournal.class);
    private static final ReadWriteLock RW_LOCK = new ReentrantReadWriteLock(true);
    private static final int DEFAULT_MAX_TIME_TO_KEEP_FILES = -1;
    private static final String RECORDS_FIELD = "records";
    private static final String JOURNAL_ID_FIELD = "journalId";
    private static final TimeBasedKeys TIME_BASED_KEYS = TimeBasedKeys.create();
    private static final long DEFAULT_LOCAL_SEARCH_DELTA = TimeUnit.SECONDS.toMillis(1L);
    private final String journalLocation;
    private final boolean asyncWritesEnabled;
    private final long maxTimeToKeepEntriesMillis;
    private String journalId;
    private DB journalDB;
    private BTreeMap<Long, JournalRecord> records;
    private long searchTimeDelta;
    private volatile boolean stopped = false;

    public LocalJournal(String journalLocation, boolean asyncWritesEnabled, int maxDaysToKeepEntries) {
        CheckArg.isNotNull((Object)journalLocation, (String)"journalLocation");
        this.journalLocation = journalLocation;
        this.asyncWritesEnabled = asyncWritesEnabled;
        this.maxTimeToKeepEntriesMillis = TimeUnit.DAYS.toMillis(maxDaysToKeepEntries);
        this.stopped = true;
        this.searchTimeDelta = DEFAULT_LOCAL_SEARCH_DELTA;
    }

    protected LocalJournal(String journalLocation) {
        this(journalLocation, false, -1);
    }

    @Override
    public void start() throws RepositoryException {
        if (!this.stopped) {
            return;
        }
        RW_LOCK.writeLock().lock();
        try {
            File journalFileLocation = new File(this.journalLocation);
            if (!journalFileLocation.exists()) {
                boolean folderHierarchyCreated = journalFileLocation.mkdirs();
                assert (folderHierarchyCreated);
            }
            DBMaker dbMaker = DBMaker.newFileDB((File)new File(journalFileLocation, RECORDS_FIELD)).compressionEnable().checksumEnable().mmapFileEnableIfSupported().snapshotEnable();
            if (this.asyncWritesEnabled) {
                dbMaker.asyncWriteEnable();
            }
            this.journalDB = dbMaker.make();
            this.records = this.journalDB.createTreeMap(RECORDS_FIELD).counterEnable().makeOrGet();
            Atomic.String journalAtomic = this.journalDB.getAtomicString(JOURNAL_ID_FIELD);
            if (StringUtil.isBlank((String)journalAtomic.get())) {
                journalAtomic.set("journal_" + UUID.randomUUID().toString());
            }
            this.journalId = journalAtomic.get();
            this.stopped = false;
        }
        catch (Exception e) {
            throw new RepositoryException(JcrI18n.cannotStartJournal.text(new Object[0]), (Throwable)e);
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this.stopped) {
            return;
        }
        RW_LOCK.writeLock().lock();
        this.stopped = true;
        try {
            this.journalDB.commit();
            this.journalDB.close();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e, (I18nResource)JcrI18n.cannotStopJournal, new Object[0]);
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
    }

    @Override
    public void notify(ChangeSet changeSet) {
        boolean systemWorkspaceChanges = "system".equalsIgnoreCase(changeSet.getWorkspaceName());
        if (changeSet.isEmpty() || systemWorkspaceChanges) {
            return;
        }
        this.addRecords(new JournalRecord(changeSet));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRecords(JournalRecord ... records) {
        if (this.stopped) {
            return;
        }
        RW_LOCK.writeLock().lock();
        try {
            LOGGER.debug("Adding {0} records", new Object[]{records.length});
            for (JournalRecord record : records) {
                if (record.getTimeBasedKey() < 0L) {
                    long createTimeMillisUTC = TIME_BASED_KEYS.nextKey();
                    record.withTimeBasedKey(createTimeMillisUTC);
                }
                this.records.put((Object)record.getTimeBasedKey(), (Object)record);
            }
            this.journalDB.commit();
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
    }

    @Override
    public void removeOldRecords() {
        this.removeRecordsOlderThan(System.currentTimeMillis() - this.maxTimeToKeepEntriesMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void removeRecordsOlderThan(long millisInUtc) {
        RW_LOCK.writeLock().lock();
        try {
            if (millisInUtc <= 0L || this.stopped) {
                return;
            }
            long searchBound = TIME_BASED_KEYS.getCounterEndingAt(millisInUtc);
            LOGGER.debug("Removing records older than " + searchBound, new Object[0]);
            ConcurrentNavigableMap toRemove = this.records.headMap((Object)searchBound);
            toRemove.clear();
            this.journalDB.commit();
            this.journalDB.compact();
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
    }

    protected String getJournalLocation() {
        return this.journalLocation;
    }

    @Override
    public ChangeJournal.Records allRecords(boolean descendingOrder) {
        return LocalJournal.recordsFrom(this.records, descendingOrder);
    }

    @Override
    public JournalRecord lastRecord() {
        return this.records == null || this.records.isEmpty() ? null : (JournalRecord)this.records.lastEntry().getValue();
    }

    @Override
    public ChangeJournal.Records recordsNewerThan(DateTime changeSetTime, boolean inclusive, boolean descendingOrder) {
        if (this.stopped) {
            return ChangeJournal.Records.EMPTY;
        }
        long changeSetMillisUTC = -1L;
        long searchBound = -1L;
        if (changeSetTime != null) {
            changeSetMillisUTC = changeSetTime.getMillis();
            searchBound = TIME_BASED_KEYS.getCounterStartingAt(changeSetMillisUTC - this.searchTimeDelta);
        }
        ConcurrentNavigableMap subMap = this.records.tailMap((Object)searchBound, true);
        long startKeyInSubMap = -1L;
        for (Long timeBasedKey : subMap.keySet()) {
            JournalRecord record = (JournalRecord)subMap.get(timeBasedKey);
            long recordChangeTimeMillisUTC = record.getChangeTimeMillis();
            if ((recordChangeTimeMillisUTC != changeSetMillisUTC || !inclusive) && recordChangeTimeMillisUTC <= changeSetMillisUTC) continue;
            startKeyInSubMap = timeBasedKey;
            break;
        }
        return startKeyInSubMap != -1L ? LocalJournal.recordsFrom(subMap.tailMap(startKeyInSubMap, true), descendingOrder) : ChangeJournal.Records.EMPTY;
    }

    @Override
    public String journalId() {
        return this.journalId;
    }

    protected LocalJournal withSearchTimeDelta(long searchTimeDelta) {
        this.searchTimeDelta = searchTimeDelta;
        return this;
    }

    private static ChangeJournal.Records recordsFrom(final NavigableMap<Long, JournalRecord> content, boolean descending) {
        final Iterator<Long> iterator = descending ? content.descendingKeySet().iterator() : content.keySet().iterator();
        return new ChangeJournal.Records(){

            @Override
            public int size() {
                return content.size();
            }

            @Override
            public Iterator<JournalRecord> iterator() {
                return new Iterator<JournalRecord>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public JournalRecord next() {
                        return (JournalRecord)content.get(iterator.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("This iterator is read-only");
                    }
                };
            }

            @Override
            public boolean isEmpty() {
                return this.size() == 0;
            }
        };
    }
}

