/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.optimize;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.query.qom.Constraint;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.engine.IndexPlan;
import org.modeshape.jcr.query.engine.IndexPlanners;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.optimize.OptimizerRule;
import org.modeshape.jcr.query.plan.PlanNode;
import org.modeshape.jcr.spi.index.IndexCostCalculator;

@Immutable
public class AddIndexes
implements OptimizerRule {
    private static final AddIndexes IMPLICIT_INDEXES = new AddIndexes(null);
    private final IndexPlanners planners;

    public static AddIndexes implicitIndexes() {
        return IMPLICIT_INDEXES;
    }

    public static AddIndexes with(IndexPlanners planners) {
        return new AddIndexes(planners);
    }

    protected AddIndexes(IndexPlanners planner) {
        this.planners = planner != null ? planner : IndexPlanners.implicit();
    }

    @Override
    public PlanNode execute(final QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        for (final PlanNode source : plan.findAllAtOrBelow(PlanNode.Type.SOURCE)) {
            final AtomicReference constraints = new AtomicReference();
            source.applyToAncestorsUpTo(PlanNode.Type.ACCESS, new PlanNode.Operation(){

                @Override
                public void apply(PlanNode node) {
                    Constraint constraint;
                    if (node.getType() == PlanNode.Type.SELECT && (constraint = node.getProperty(PlanNode.Property.SELECT_CRITERIA, Constraint.class)) != null) {
                        if (constraints.get() == null) {
                            constraints.set(new LinkedList());
                        }
                        ((List)constraints.get()).add(constraint);
                    }
                }
            });
            if (constraints.get() == null) continue;
            assert (source.getSelectors().size() == 1);
            final SelectorName selectorName = source.getSelectors().iterator().next();
            IndexCostCalculator calculator = new IndexCostCalculator(){

                @Override
                public String selectedNodeType() {
                    return selectorName.getString();
                }

                @Override
                public Collection<Constraint> andedConstraints() {
                    return (Collection)constraints.get();
                }

                @Override
                public Map<String, Object> getVariables() {
                    return context.getVariables();
                }

                @Override
                public void addIndex(String name, String workspaceName, String providerName, Collection<Constraint> constraints2, int costEstimate, long cardinalityEstimate, Float selectivityEstimate, Map<String, Object> parameters) {
                    PlanNode indexNode = new PlanNode(PlanNode.Type.INDEX, source.getSelectors());
                    IndexPlan indexPlan = new IndexPlan(name, workspaceName, providerName, constraints2, costEstimate, cardinalityEstimate, selectivityEstimate.floatValue(), parameters);
                    indexNode.setProperty(PlanNode.Property.INDEX_SPECIFICATION, indexPlan);
                    source.addLastChild(indexNode);
                }

                @Override
                public void addIndex(String name, String workspaceName, String providerName, Collection<Constraint> constraints2, int costEstimate, long cardinalityEstimate, Float selectivityEstimate) {
                    this.addIndex(name, workspaceName, providerName, constraints2, costEstimate, cardinalityEstimate, selectivityEstimate, null);
                }

                @Override
                public void addIndex(String name, String workspaceName, String providerName, Collection<Constraint> constraints2, int costEstimate, long cardinalityEstimate, Float selectivityEstimate, String parameterName, Object parameterValue) {
                    Map<String, Object> params = Collections.singletonMap(parameterName, parameterValue);
                    this.addIndex(name, workspaceName, providerName, constraints2, costEstimate, cardinalityEstimate, selectivityEstimate, params);
                }

                @Override
                public void addIndex(String name, String workspaceName, String providerName, Collection<Constraint> constraints2, int costEstimate, long cardinalityEstimate, Float selectivityEstimate, String parameterName1, Object parameterValue1, String parameterName2, Object parameterValue2) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put(parameterName1, parameterValue1);
                    params.put(parameterName2, parameterValue2);
                    this.addIndex(name, workspaceName, providerName, constraints2, costEstimate, cardinalityEstimate, selectivityEstimate, params);
                }
            };
            this.planners.applyIndexes(context, calculator);
        }
        return plan;
    }
}

