/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.BinaryFactory;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.IoException;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.ValueFormatException;
import org.modeshape.jcr.value.basic.AbstractValueFactory;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.InMemoryBinaryValue;
import org.modeshape.jcr.value.binary.StoredBinaryValue;

@Immutable
public class BinaryStoreValueFactory
extends AbstractValueFactory<BinaryValue>
implements BinaryFactory {
    private static final String CHAR_SET_NAME = "UTF-8";
    private final BinaryStore store;
    private final ValueFactory<String> stringFactory;

    public BinaryStoreValueFactory(BinaryStore store, TextDecoder decoder, ValueFactories factories, ValueFactory<String> stringFactory) {
        super(PropertyType.BINARY, decoder, factories);
        CheckArg.isNotNull((Object)store, (String)"store");
        this.store = store;
        this.stringFactory = stringFactory;
    }

    @Override
    public BinaryFactory with(ValueFactories valueFactories) {
        return this.valueFactories == valueFactories ? this : new BinaryStoreValueFactory(this.store, super.getDecoder(), valueFactories, this.stringFactory);
    }

    @Override
    public BinaryStoreValueFactory with(BinaryStore store) {
        if (this.store == store) {
            return this;
        }
        return new BinaryStoreValueFactory(store, super.getDecoder(), this.valueFactories, this.stringFactory);
    }

    @Override
    protected ValueFactory<String> getStringValueFactory() {
        return this.stringFactory != null ? this.stringFactory : super.getStringValueFactory();
    }

    public BinaryValue[] createEmptyArray(int length) {
        return new BinaryValue[length];
    }

    @Override
    public BinaryValue create(String value) {
        if (value == null) {
            return null;
        }
        try {
            return this.create(value.getBytes(CHAR_SET_NAME));
        }
        catch (UnsupportedEncodingException err) {
            throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{String.class.getSimpleName(), BinaryValue.class.getSimpleName(), value}), err);
        }
    }

    @Override
    public BinaryValue create(String value, TextDecoder decoder) {
        if (value == null) {
            return null;
        }
        return this.create(this.getDecoder(decoder).decode(value));
    }

    @Override
    public BinaryValue create(int value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public BinaryValue create(long value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public BinaryValue create(boolean value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public BinaryValue create(float value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public BinaryValue create(double value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public BinaryValue create(BigDecimal value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public BinaryValue create(Calendar value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public BinaryValue create(Date value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public BinaryValue create(DateTime value) throws ValueFormatException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public BinaryValue create(Name value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public BinaryValue create(Path value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public BinaryValue create(Path.Segment value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public BinaryValue create(Reference value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public BinaryValue create(URI value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public BinaryValue create(UUID value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public BinaryValue create(NodeKey value) throws ValueFormatException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public BinaryValue create(BinaryValue value) throws ValueFormatException, IoException {
        return value;
    }

    @Override
    public BinaryValue create(byte[] value) throws ValueFormatException {
        if (value == null) {
            return null;
        }
        if ((long)value.length <= this.store.getMinimumBinarySizeInBytes()) {
            return new InMemoryBinaryValue(this.store, value);
        }
        try {
            return this.store.storeValue(new ByteArrayInputStream(value));
        }
        catch (BinaryStoreException e) {
            throw new ValueFormatException(PropertyType.BINARY, GraphI18n.errorConvertingType.text(new Object[]{byte[].class.getSimpleName(), BinaryValue.class.getSimpleName(), value}), (Throwable)((Object)e));
        }
    }

    @Override
    public BinaryValue create(InputStream stream) throws IoException {
        if (stream == null) {
            return null;
        }
        try {
            return this.store.storeValue(stream);
        }
        catch (BinaryStoreException e) {
            throw new ValueFormatException(PropertyType.BINARY, GraphI18n.errorConvertingIo.text(new Object[]{InputStream.class.getSimpleName(), BinaryValue.class.getSimpleName()}), (Throwable)((Object)e));
        }
    }

    @Override
    public BinaryValue create(InputStream stream, String hint) throws IoException {
        if (stream == null) {
            return null;
        }
        try {
            return this.store.storeValue(stream, hint);
        }
        catch (BinaryStoreException e) {
            throw new ValueFormatException(PropertyType.BINARY, GraphI18n.errorConvertingIo.text(new Object[]{InputStream.class.getSimpleName(), BinaryValue.class.getSimpleName()}), (Throwable)((Object)e));
        }
    }

    @Override
    public BinaryValue find(BinaryKey secureHash, long size) throws BinaryStoreException {
        return new StoredBinaryValue(this.store, secureHash, size);
    }
}

