/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.cnd;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.OnParentVersionAction;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.CndImporter;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.api.PropertyType;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.jcr.value.NamespaceRegistry;

public class CndSequencer
extends Sequencer {
    private static final String RESIDUAL_ITEM_NAME = "*";
    private static final Logger LOGGER = Logger.getLogger(CndSequencer.class);

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        super.registerNodeTypes("sequencer-cnd.cnd", nodeTypeManager, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        if (this.outputIsSystemNodeTypes(outputNode, binaryValue)) {
            return true;
        }
        CndImporter cndImporter = null;
        try (InputStream stream = binaryValue.getStream();){
            cndImporter = this.importNodesFromCND(stream);
            if (cndImporter == null) {
                boolean bl = false;
                return bl;
            }
        }
        assert (cndImporter != null);
        this.registerImportedNamespaces(outputNode, cndImporter);
        this.processNodeTypeDefinitions(outputNode, cndImporter);
        return true;
    }

    private void processNodeTypeDefinitions(Node outputNode, CndImporter cndImporter) throws RepositoryException {
        List<NodeTypeDefinition> importedNodeTypes = cndImporter.getNodeTypeDefinitions();
        for (NodeTypeDefinition nodeTypeDefinition : importedNodeTypes) {
            this.storeNodeTypeDefinition(outputNode, nodeTypeDefinition);
        }
    }

    private void registerImportedNamespaces(Node outputNode, CndImporter cndImporter) throws RepositoryException {
        NamespaceRegistry namespaceRegistry = outputNode.getSession().getWorkspace().getNamespaceRegistry();
        for (NamespaceRegistry.Namespace namespace : cndImporter.getNamespaces()) {
            super.registerNamespace(namespace.getPrefix(), namespace.getNamespaceUri(), namespaceRegistry);
        }
    }

    private CndImporter importNodesFromCND(InputStream cndInputStream) throws IOException {
        SimpleProblems problemsDuringImport = new SimpleProblems();
        CndImporter cndImporter = new CndImporter(new ExecutionContext());
        cndImporter.importFrom(cndInputStream, (Problems)problemsDuringImport, null);
        if (problemsDuringImport.hasErrors()) {
            problemsDuringImport.writeTo(LOGGER);
            return null;
        }
        return cndImporter;
    }

    private boolean outputIsSystemNodeTypes(Node outputNode, Binary binaryValue) throws RepositoryException, IOException {
        String systemNodesPath = JcrLexicon.SYSTEM.getString() + "/" + JcrLexicon.NODE_TYPES.getString();
        if (outputNode.getPath().contains(systemNodesPath)) {
            NodeTypeManager nodeTypeManager = (NodeTypeManager)outputNode.getSession().getWorkspace().getNodeTypeManager();
            nodeTypeManager.registerNodeTypes(binaryValue.getStream(), true);
            return true;
        }
        return false;
    }

    private void storeNodeTypeDefinition(Node outputNode, NodeTypeDefinition nodeTypeDefinition) throws RepositoryException {
        NodeDefinition[] declaredChildNodeDefinitions;
        Node nodeTypeNode = this.processNodeTypeDefinition(outputNode, nodeTypeDefinition);
        PropertyDefinition[] declaredPropertyDefinitions = nodeTypeDefinition.getDeclaredPropertyDefinitions();
        if (declaredPropertyDefinitions != null) {
            for (PropertyDefinition propertyDefinition : declaredPropertyDefinitions) {
                this.processPropertyDefinition(nodeTypeNode, propertyDefinition);
            }
        }
        if ((declaredChildNodeDefinitions = nodeTypeDefinition.getDeclaredChildNodeDefinitions()) != null) {
            for (NodeDefinition childNodeDefinition : declaredChildNodeDefinitions) {
                this.processChildNodeDefinition(nodeTypeNode, childNodeDefinition);
            }
        }
    }

    private void processChildNodeDefinition(Node nodeTypeNode, NodeDefinition childNodeDefinition) throws RepositoryException {
        Node childNode = nodeTypeNode.addNode("cnd:childNodeDefinition", "cnd:childNodeDefinition");
        if (!RESIDUAL_ITEM_NAME.equals(childNodeDefinition.getName())) {
            childNode.setProperty("cnd:name", childNodeDefinition.getName());
        }
        childNode.setProperty("cnd:autoCreated", childNodeDefinition.isAutoCreated());
        childNode.setProperty("cnd:mandatory", childNodeDefinition.isMandatory());
        childNode.setProperty("cnd:onParentVersion", OnParentVersionAction.nameFromValue((int)childNodeDefinition.getOnParentVersion()));
        childNode.setProperty("cnd:protected", childNodeDefinition.isProtected());
        String[] requiredPrimaryTypeNames = childNodeDefinition.getRequiredPrimaryTypeNames();
        childNode.setProperty("cnd:requiredPrimaryTypes", requiredPrimaryTypeNames != null ? requiredPrimaryTypeNames : new String[]{});
        childNode.setProperty("cnd:sameNameSiblings", childNodeDefinition.allowsSameNameSiblings());
        childNode.setProperty("cnd:defaultPrimaryType", childNodeDefinition.getDefaultPrimaryTypeName());
    }

    private void processPropertyDefinition(Node nodeTypeNode, PropertyDefinition propertyDefinition) throws RepositoryException {
        Node propertyDefinitionNode = nodeTypeNode.addNode("cnd:propertyDefinition", "cnd:propertyDefinition");
        if (!RESIDUAL_ITEM_NAME.equals(propertyDefinition.getName())) {
            propertyDefinitionNode.setProperty("cnd:name", propertyDefinition.getName());
        }
        propertyDefinitionNode.setProperty("cnd:autoCreated", propertyDefinition.isAutoCreated());
        propertyDefinitionNode.setProperty("cnd:mandatory", propertyDefinition.isMandatory());
        propertyDefinitionNode.setProperty("cnd:multiple", propertyDefinition.isMultiple());
        propertyDefinitionNode.setProperty("cnd:protected", propertyDefinition.isProtected());
        propertyDefinitionNode.setProperty("cnd:onParentVersion", OnParentVersionAction.nameFromValue((int)propertyDefinition.getOnParentVersion()));
        propertyDefinitionNode.setProperty("cnd:requiredType", PropertyType.nameFromValue((int)propertyDefinition.getRequiredType()).toUpperCase());
        String[] availableQueryOperators = propertyDefinition.getAvailableQueryOperators();
        propertyDefinitionNode.setProperty("cnd:availableQueryOperators", availableQueryOperators != null ? availableQueryOperators : new String[]{});
        Value[] defaultValues = propertyDefinition.getDefaultValues();
        propertyDefinitionNode.setProperty("cnd:defaultValues", defaultValues != null ? defaultValues : new Value[]{});
        String[] valueConstraints = propertyDefinition.getValueConstraints();
        propertyDefinitionNode.setProperty("cnd:valueConstraints", valueConstraints != null ? valueConstraints : new String[]{});
        propertyDefinitionNode.setProperty("cnd:isFullTextSearchable", propertyDefinition.isFullTextSearchable());
        propertyDefinitionNode.setProperty("cnd:isQueryOrderable", propertyDefinition.isQueryOrderable());
    }

    private Node processNodeTypeDefinition(Node outputNode, NodeTypeDefinition nodeTypeDefinition) throws RepositoryException {
        Node nodeTypeNode = outputNode.addNode(nodeTypeDefinition.getName(), "cnd:nodeType");
        nodeTypeNode.setProperty("cnd:isMixin", nodeTypeDefinition.isMixin());
        nodeTypeNode.setProperty("cnd:isAbstract", nodeTypeDefinition.isAbstract());
        nodeTypeNode.setProperty("cnd:isQueryable", nodeTypeDefinition.isQueryable());
        nodeTypeNode.setProperty("cnd:nodeTypeName", nodeTypeDefinition.getName());
        nodeTypeNode.setProperty("cnd:hasOrderableChildNodes", nodeTypeDefinition.hasOrderableChildNodes());
        String[] declaredSupertypeNames = nodeTypeDefinition.getDeclaredSupertypeNames();
        nodeTypeNode.setProperty("cnd:supertypes", declaredSupertypeNames != null ? declaredSupertypeNames : new String[]{});
        if (nodeTypeDefinition.getPrimaryItemName() != null) {
            nodeTypeNode.setProperty("cnd:primaryItemName", nodeTypeDefinition.getPrimaryItemName());
        }
        return nodeTypeNode;
    }
}

