/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.infinispan.Cache;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicDb;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.util.concurrent.TimeoutException;
import org.modeshape.common.SystemFailureException;
import org.modeshape.jcr.InfinispanUtil;
import org.modeshape.jcr.cache.document.DocumentStore;
import org.modeshape.jcr.cache.document.SessionNode;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.binary.ExternalBinaryValue;

public class LocalDocumentStore
implements DocumentStore {
    private final SchematicDb database;
    private String localSourceKey;

    public LocalDocumentStore(SchematicDb database) {
        this.database = database;
    }

    @Override
    public boolean containsKey(String key) {
        return this.database.containsKey(key);
    }

    @Override
    public SchematicEntry get(String key) {
        return this.database.get(key);
    }

    @Override
    public SchematicEntry storeDocument(String key, Document document) {
        return this.putIfAbsent(key, document);
    }

    @Override
    public void updateDocument(String key, Document document, SessionNode sessionNode) {
    }

    @Override
    public String newDocumentKey(String parentKey, Name documentName, Name documentPrimaryType) {
        return null;
    }

    public SchematicEntry putIfAbsent(String key, Document document) {
        return this.database.putIfAbsent(key, document);
    }

    public void put(String key, Document document) {
        this.database.put(key, document);
    }

    public void put(Document entryDocument) {
        this.database.put(entryDocument);
    }

    public void replace(String key, Document document) {
        this.database.replace(key, document);
    }

    @Override
    public boolean remove(String key) {
        return this.database.remove(key) != null;
    }

    @Override
    public boolean prepareDocumentsForUpdate(Collection<String> keys) {
        return this.database.lock(keys);
    }

    @Override
    public EditableDocument edit(String key, boolean createIfMissing) {
        return this.database.editContent(key, createIfMissing);
    }

    @Override
    public EditableDocument edit(String key, boolean createIfMissing, boolean acquireLock) {
        return this.database.editContent(key, createIfMissing, acquireLock);
    }

    @Override
    public LocalDocumentStore localStore() {
        return this;
    }

    @Override
    public TransactionManager transactionManager() {
        return this.localCache().getAdvancedCache().getTransactionManager();
    }

    @Override
    public XAResource xaResource() {
        return this.localCache().getAdvancedCache().getXAResource();
    }

    @Override
    public void setLocalSourceKey(String sourceKey) {
        this.localSourceKey = sourceKey;
    }

    @Override
    public String getLocalSourceKey() {
        return this.localSourceKey;
    }

    @Override
    public String createExternalProjection(String projectedNodeKey, String sourceName, String externalPath, String alias) {
        throw new UnsupportedOperationException("External projections are not supported in the local document store");
    }

    @Override
    public Document getChildrenBlock(String key) {
        SchematicEntry entry = this.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getContent();
    }

    @Override
    public Document getChildReference(String parentKey, String childKey) {
        return null;
    }

    public Cache<String, SchematicEntry> localCache() {
        return this.database.getCache();
    }

    @Override
    public ExternalBinaryValue getExternalBinary(String sourceName, String id) {
        throw new UnsupportedOperationException("External binaries are only supported by the federated document store");
    }

    public DocumentOperationResults performOnEachDocument(DocumentOperation operation) throws InterruptedException, ExecutionException {
        DistributedOperation distOp = new DistributedOperation(operation);
        return InfinispanUtil.execute(this.database.getCache(), InfinispanUtil.Location.LOCALLY, distOp, distOp);
    }

    protected static class DistributedOperation
    implements DistributedCallable<String, SchematicEntry, DocumentOperationResults>,
    Serializable,
    InfinispanUtil.Combiner<DocumentOperationResults> {
        private static final long serialVersionUID = 1L;
        private transient SchematicDb db;
        private transient Set<String> inputKeys;
        private transient TransactionManager txnMgr;
        private transient DocumentOperation operation;

        protected DistributedOperation(DocumentOperation operation) {
            this.operation = operation;
        }

        public void setEnvironment(Cache<String, SchematicEntry> cache, Set<String> inputKeys) {
            assert (cache != null);
            assert (inputKeys != null);
            this.db = Schematic.get(cache);
            this.inputKeys = inputKeys;
            this.txnMgr = cache.getAdvancedCache().getTransactionManager();
            this.operation.setEnvironment(cache);
        }

        public DocumentOperationResults call() throws Exception {
            DocumentOperationResults results = new DocumentOperationResults();
            for (String key : this.inputKeys) {
                try {
                    this.txnMgr.begin();
                    EditableDocument doc = this.db.editContent(key, false, true);
                    if (doc != null) {
                        if (this.operation.execute(key, doc)) {
                            results.recordModified();
                        } else {
                            results.recordUnmodified();
                        }
                    }
                    this.txnMgr.commit();
                }
                catch (TimeoutException e) {
                    results.recordSkipped();
                }
                catch (NotSupportedException err) {
                    results.recordFailure();
                    throw new SystemFailureException((Throwable)err);
                }
                catch (SecurityException err) {
                    results.recordFailure();
                    throw new SystemFailureException((Throwable)err);
                }
                catch (IllegalStateException err) {
                    results.recordFailure();
                    throw new SystemFailureException((Throwable)err);
                }
                catch (RollbackException err) {
                    results.recordFailure();
                }
                catch (HeuristicMixedException err) {
                    results.recordFailure();
                }
                catch (HeuristicRollbackException err) {
                    results.recordFailure();
                }
                catch (SystemException err) {
                    results.recordFailure();
                    throw new SystemFailureException((Throwable)err);
                }
                catch (Throwable t) {
                    this.txnMgr.rollback();
                    results.recordFailure();
                }
            }
            return results;
        }

        @Override
        public DocumentOperationResults combine(DocumentOperationResults priorResult, DocumentOperationResults newResult) {
            return priorResult.combine(newResult);
        }
    }

    public static class DocumentOperationResults
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private long modifiedCount;
        private long unmodifiedCount;
        private long skipCount;
        private long failureCount;

        public long getModifiedCount() {
            return this.modifiedCount;
        }

        public long getUnmodifiedCount() {
            return this.unmodifiedCount;
        }

        public long getFailureCount() {
            return this.failureCount;
        }

        public long getSkipCount() {
            return this.skipCount;
        }

        protected void recordModified() {
            ++this.modifiedCount;
        }

        protected void recordUnmodified() {
            ++this.unmodifiedCount;
        }

        protected void recordFailure() {
            ++this.failureCount;
        }

        protected void recordSkipped() {
            ++this.skipCount;
        }

        protected DocumentOperationResults combine(DocumentOperationResults other) {
            if (other != null) {
                this.modifiedCount += other.modifiedCount;
                this.unmodifiedCount += other.unmodifiedCount;
                this.skipCount += other.skipCount;
                this.failureCount += other.failureCount;
            }
            return this;
        }

        public String toString() {
            return "" + this.modifiedCount + " documents changed, " + this.unmodifiedCount + " unchanged, " + this.skipCount + " skipped, and " + this.failureCount + " resulted in errors or failures";
        }
    }

    public static abstract class DocumentOperation
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected Cache<String, SchematicEntry> cache;

        public void setEnvironment(Cache<String, SchematicEntry> cache) {
            this.cache = cache;
        }

        public abstract boolean execute(String var1, EditableDocument var2);
    }
}

