/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.journal;

import java.io.Serializable;
import java.util.List;
import org.joda.time.DateTime;
import org.modeshape.jcr.journal.JournalRecord;

abstract class DeltaMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String journalId;

    protected DeltaMessage(String journalId) {
        this.journalId = journalId;
    }

    protected String getJournalId() {
        return this.journalId;
    }

    static DeltaRequest request(String journalId, DateTime lastChangeSetTimeMillis) {
        return new DeltaRequest(journalId, lastChangeSetTimeMillis);
    }

    static DeltaStillReconciling stillReconciling(String journalId) {
        return new DeltaStillReconciling(journalId);
    }

    static DeltaResponse response(String journalId, List<JournalRecord> records) {
        return new DeltaResponse(journalId, records);
    }

    protected static final class DeltaStillReconciling
    extends DeltaMessage {
        private static final long serialVersionUID = 1L;

        protected DeltaStillReconciling(String journalId) {
            super(journalId);
        }
    }

    protected static final class DeltaResponse
    extends DeltaMessage {
        private static final long serialVersionUID = 1L;
        private final List<JournalRecord> records;

        protected DeltaResponse(String journalId, List<JournalRecord> records) {
            super(journalId);
            this.records = records;
        }

        protected List<JournalRecord> getRecords() {
            return this.records;
        }
    }

    protected static final class DeltaRequest
    extends DeltaMessage {
        private static final long serialVersionUID = 1L;
        private final DateTime lastChangeSetTime;

        public DeltaRequest(String journalId, DateTime lastChangeSetTime) {
            super(journalId);
            this.lastChangeSetTime = lastChangeSetTime;
        }

        protected DateTime getLastChangeSetTime() {
            return this.lastChangeSetTime;
        }
    }
}

