/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Set;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.query.model.NullOrder;
import org.modeshape.jcr.query.model.Order;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueFormatException;

@Immutable
public abstract class TypeSystem {
    public abstract TypeFactory<?> getTypeFactory(String var1);

    public abstract TypeFactory<?> getTypeFactory(Object var1);

    public abstract TypeFactory<Boolean> getBooleanFactory();

    public abstract TypeFactory<Long> getLongFactory();

    public abstract TypeFactory<String> getStringFactory();

    public abstract TypeFactory<Double> getDoubleFactory();

    public abstract TypeFactory<BigDecimal> getDecimalFactory();

    public abstract TypeFactory<?> getDateTimeFactory();

    public abstract TypeFactory<Path> getPathFactory();

    public abstract TypeFactory<Name> getNameFactory();

    public abstract TypeFactory<Reference> getReferenceFactory();

    public abstract TypeFactory<NodeKey> getNodeKeyFactory();

    public abstract TypeFactory<BinaryValue> getBinaryFactory();

    public abstract String getDefaultType();

    public abstract Comparator<Object> getDefaultComparator();

    public abstract Set<String> getTypeNames();

    public abstract String asString(Object var1);

    public abstract String getCompatibleType(String var1, String var2);

    public abstract TypeFactory<?> getCompatibleType(TypeFactory<?> var1, TypeFactory<?> var2);

    public static <T> TypeFactory<T> withComparator(final TypeFactory<T> original, final Comparator<T> comparator) {
        if (comparator == null) {
            return original;
        }
        return new TypeFactory<T>(){

            @Override
            public Class<T> getType() {
                return original.getType();
            }

            @Override
            public Comparator<T> getComparator() {
                return comparator;
            }

            @Override
            public String getTypeName() {
                return original.getTypeName();
            }

            @Override
            public T create(String value) throws ValueFormatException {
                return original.create(value);
            }

            @Override
            public T create(Object value) throws ValueFormatException {
                return original.create(value);
            }

            @Override
            public String asString(Object value) {
                return original.asString(value);
            }

            @Override
            public long length(Object value) {
                return original.length(value);
            }

            @Override
            public String asReadableString(Object value) {
                return original.asReadableString(value);
            }

            public String toString() {
                return original.toString() + " with comparator " + comparator;
            }
        };
    }

    public static <T> TypeFactory<T> withOppositeComparator(TypeFactory<T> original) {
        final Comparator<T> comparator = original.getComparator();
        SerializableComparator inverted = new SerializableComparator<T>(){
            private static final long serialVersionUID = 1L;

            @Override
            public int compare(T arg0, T arg1) {
                return comparator.compare(arg1, arg0);
            }
        };
        return TypeSystem.withComparator(original, inverted);
    }

    public static <T> TypeFactory<T> with(TypeFactory<T> original, Order order, NullOrder nullOrder) {
        final Comparator<T> comparator = original.getComparator();
        final String toString = "Comparator<" + original.getTypeName() + ">(" + order + " " + nullOrder + ")";
        switch (order) {
            case ASCENDING: {
                switch (nullOrder) {
                    case NULLS_FIRST: {
                        SerializableComparator nullFirst = new SerializableComparator<T>(){
                            private static final long serialVersionUID = 1L;

                            @Override
                            public int compare(T o1, T o2) {
                                if (o1 == null) {
                                    return -1;
                                }
                                if (o2 == null) {
                                    return 1;
                                }
                                assert (o1 != null);
                                assert (o2 != null);
                                return comparator.compare(o1, o2);
                            }

                            public String toString() {
                                return toString;
                            }
                        };
                        return TypeSystem.withComparator(original, nullFirst);
                    }
                    case NULLS_LAST: {
                        SerializableComparator nullLast = new SerializableComparator<T>(){
                            private static final long serialVersionUID = 1L;

                            @Override
                            public int compare(T o1, T o2) {
                                if (o1 == null) {
                                    return 1;
                                }
                                if (o2 == null) {
                                    return -1;
                                }
                                assert (o1 != null);
                                assert (o2 != null);
                                return comparator.compare(o1, o2);
                            }

                            public String toString() {
                                return toString;
                            }
                        };
                        return TypeSystem.withComparator(original, nullLast);
                    }
                }
                assert (false);
                break;
            }
            case DESCENDING: {
                switch (nullOrder) {
                    case NULLS_FIRST: {
                        SerializableComparator nullFirst = new SerializableComparator<T>(){
                            private static final long serialVersionUID = 1L;

                            @Override
                            public int compare(T o1, T o2) {
                                if (o1 == null) {
                                    return -1;
                                }
                                if (o2 == null) {
                                    return 1;
                                }
                                assert (o1 != null);
                                assert (o2 != null);
                                return comparator.compare(o2, o1);
                            }

                            public String toString() {
                                return toString;
                            }
                        };
                        return TypeSystem.withComparator(original, nullFirst);
                    }
                    case NULLS_LAST: {
                        SerializableComparator nullLast = new SerializableComparator<T>(){
                            private static final long serialVersionUID = 1L;

                            @Override
                            public int compare(T o1, T o2) {
                                if (o1 == null) {
                                    return 1;
                                }
                                if (o2 == null) {
                                    return -1;
                                }
                                assert (o1 != null);
                                assert (o2 != null);
                                return comparator.compare(o2, o1);
                            }

                            public String toString() {
                                return toString;
                            }
                        };
                        return TypeSystem.withComparator(original, nullLast);
                    }
                }
            }
        }
        assert (false);
        return null;
    }

    public static interface SerializableComparator<T>
    extends Comparator<T>,
    Serializable {
    }

    public static interface TypeFactory<T> {
        public Class<T> getType();

        public Comparator<T> getComparator();

        public String getTypeName();

        public T create(String var1) throws ValueFormatException;

        public T create(Object var1) throws ValueFormatException;

        public String asString(Object var1);

        public long length(Object var1);

        public String asReadableString(Object var1);
    }
}

