/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.text.StringCharacterIterator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.text.XmlNameEncoder;
import org.modeshape.common.util.Base64;
import org.modeshape.common.util.IoUtil;
import org.modeshape.jcr.AbstractJcrExporter;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrSharedNode;
import org.modeshape.jcr.JcrSingleValueProperty;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.api.PropertyType;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@NotThreadSafe
class JcrDocumentViewExporter
extends AbstractJcrExporter {
    static final TextEncoder NAME_ENCODER;
    static final TextEncoder VALUE_ENCODER;
    static final TextDecoder NAME_DECODER;
    static final TextDecoder VALUE_DECODER;
    private final ValueFactory<String> stringFactory;

    JcrDocumentViewExporter(JcrSession session) {
        super(session, Collections.emptyList());
        this.stringFactory = session.stringFactory();
    }

    @Override
    public void exportNode(Node node, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws RepositoryException, SAXException {
        ExecutionContext executionContext = this.session.context();
        JcrSharedNode sharedNode = this.asSharedNode(node);
        if (sharedNode != null) {
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, JcrLexicon.PRIMARY_TYPE, 7, JcrNtLexicon.SHARE);
            this.addAttribute(atts, JcrLexicon.UUID, 1, node.getIdentifier());
            Name name = sharedNode.segment().getName();
            this.startElement(contentHandler, name, atts);
            this.endElement(contentHandler, name);
            return;
        }
        this.exporting(node);
        if (node.getDepth() > 0 && this.isXmlTextNode(node)) {
            String xmlCharacters = this.getXmlCharacters(node);
            contentHandler.characters(xmlCharacters.toCharArray(), 0, xmlCharacters.length());
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        AbstractJcrProperty primaryType = ((AbstractJcrNode)node).getProperty(JcrLexicon.PRIMARY_TYPE);
        if (primaryType != null) {
            this.addAttribute(atts, (Property)primaryType, skipBinary, false);
        }
        PropertyIterator properties = node.getProperties();
        while (properties.hasNext()) {
            Property prop = properties.nextProperty();
            if (prop == primaryType) continue;
            this.addAttribute(atts, prop, skipBinary, true);
        }
        Name name = null;
        ValueFactories valueFactories = executionContext.getValueFactories();
        name = node.getDepth() == 0 ? JcrLexicon.ROOT : (Name)valueFactories.getNameFactory().create(node.getName());
        this.startElement(contentHandler, name, atts);
        if (!noRecurse) {
            NodeIterator nodes = node.getNodes();
            while (nodes.hasNext()) {
                Node child = nodes.nextNode();
                if (child.isNodeType(ModeShapeLexicon.ACCESS_LIST_NODE_TYPE_STRING)) continue;
                this.exportNode(child, contentHandler, skipBinary, noRecurse);
            }
        }
        this.endElement(contentHandler, name);
    }

    protected void addAttribute(AttributesImpl atts, Name propertyName, int propertyType, Object value) {
        String valueAsString = VALUE_ENCODER.encode(this.stringFactory.create(value));
        String localPropName = this.getPrefixedName(propertyName);
        atts.addAttribute(propertyName.getNamespaceUri(), propertyName.getLocalName(), localPropName, PropertyType.nameFromValue((int)propertyType), valueAsString);
    }

    protected void addAttribute(AttributesImpl atts, Property prop, boolean skipBinary, boolean skipPrimaryType) throws RepositoryException {
        Value[] values;
        Name propName = ((AbstractJcrProperty)prop).name();
        if (skipPrimaryType && JcrLexicon.PRIMARY_TYPE.equals(propName)) {
            return;
        }
        String localPropName = this.getPrefixedName(propName);
        if (skipBinary && 2 == prop.getType()) {
            atts.addAttribute(propName.getNamespaceUri(), propName.getLocalName(), localPropName, PropertyType.nameFromValue((int)prop.getType()), "");
            return;
        }
        Value value = null;
        value = prop instanceof JcrSingleValueProperty ? prop.getValue() : ((values = prop.getValues()).length > 0 ? values[0] : null);
        String valueAsString = "";
        if (value != null) {
            if (2 == prop.getType()) {
                try {
                    Base64.InputStream is = new Base64.InputStream(value.getBinary().getStream(), 1);
                    valueAsString = IoUtil.read((InputStream)is);
                }
                catch (IOException ioe) {
                    throw new RepositoryException((Throwable)ioe);
                }
            } else {
                valueAsString = VALUE_ENCODER.encode(value.getString());
            }
        }
        atts.addAttribute(propName.getNamespaceUri(), NAME_ENCODER.encode(propName.getLocalName()), NAME_ENCODER.encode(localPropName), PropertyType.nameFromValue((int)prop.getType()), valueAsString);
    }

    private boolean isXmlTextNode(Node node) throws RepositoryException {
        if (this.getPrefixedName(JcrLexicon.XMLTEXT).equals(node.getName()) && node.getNodes().getSize() == 0L) {
            PropertyIterator properties = node.getProperties();
            boolean xmlCharactersFound = false;
            while (properties.hasNext()) {
                Property property = properties.nextProperty();
                if (this.getPrefixedName(JcrLexicon.PRIMARY_TYPE).equals(property.getName())) continue;
                if (this.getPrefixedName(JcrLexicon.XMLCHARACTERS).equals(property.getName())) {
                    xmlCharactersFound = true;
                    continue;
                }
                return false;
            }
            return xmlCharactersFound;
        }
        return false;
    }

    private String getXmlCharacters(Node node) throws RepositoryException {
        assert (this.isXmlTextNode(node));
        Property xmlCharacters = node.getProperty(this.getPrefixedName(JcrLexicon.XMLCHARACTERS));
        assert (xmlCharacters != null);
        if (xmlCharacters.getDefinition().isMultiple()) {
            StringBuilder bf = new StringBuilder();
            for (Value value : xmlCharacters.getValues()) {
                bf.append(value.getString());
            }
            return bf.toString();
        }
        return xmlCharacters.getValue().getString();
    }

    static {
        VALUE_ENCODER = NAME_ENCODER = new JcrDocumentViewPropertyEncoder(' ', '\r', '\n', '\t');
        NAME_DECODER = (TextDecoder)NAME_ENCODER;
        VALUE_DECODER = (TextDecoder)NAME_ENCODER;
    }

    protected static class JcrDocumentViewPropertyEncoder
    extends XmlNameEncoder {
        private final Set<Character> mappedCharacters = new HashSet<Character>();

        protected JcrDocumentViewPropertyEncoder(char ... chars) {
            for (char c : chars) {
                this.mappedCharacters.add(Character.valueOf(c));
            }
        }

        public String encode(String text) {
            if (text == null) {
                return null;
            }
            if (text.length() == 0) {
                return text;
            }
            StringBuilder sb = new StringBuilder();
            String hex = null;
            StringCharacterIterator iter = new StringCharacterIterator(text);
            char first = iter.first();
            boolean isDigit = Character.isDigit(first);
            char c = first;
            while (c != '\uffff') {
                if (c != first && isDigit && !Character.isDigit(c)) {
                    isDigit = false;
                }
                if (c == '_') {
                    char next = iter.next();
                    if (next == '\uffff') {
                        sb.append(c);
                        break;
                    }
                    if (next != 'x') {
                        sb.append(c).append(next);
                    } else {
                        sb.append("_x005f_");
                        sb.append(next);
                    }
                } else if (!this.mappedCharacters.contains(Character.valueOf(c)) && !isDigit) {
                    sb.append(c);
                } else {
                    hex = Integer.toHexString(c);
                    if (c >= '\u0000' && c <= '\u000f') {
                        sb.append("_x000").append(hex);
                    } else if (c >= '\u0010' && c <= '\u00ff') {
                        sb.append("_x00").append(hex);
                    } else if (c >= '\u0100' && c <= '\u0fff') {
                        sb.append("_x0").append(hex);
                    } else {
                        sb.append("_x").append(hex);
                    }
                    sb.append('_');
                }
                c = iter.next();
            }
            return sb.toString();
        }

        public String decode(String encodedText) {
            return super.decode(encodedText);
        }
    }
}

