/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.modeshape.common.collection.Collections;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.value.PropertyType;

public final class PseudoColumns {
    protected static final Set<String> PSEUDO_COLUMNS = Collections.unmodifiableSet((Object[])new String[]{"jcr:score", "jcr:path", "jcr:name", "jcr:uuid", "mode:localName", "mode:depth", "mode:id"});
    protected static final Set<String> PSEUDO_COLUMNS_WITHOUT_UUID = Collections.unmodifiableSet((Object[])new String[]{"jcr:score", "jcr:path", "jcr:name", "mode:localName", "mode:depth", "mode:id"});
    protected static final Map<org.modeshape.jcr.value.Name, Info> PSEUDO_COLUMN_INFOS;
    protected static final Map<org.modeshape.jcr.value.Name, Info> PSEUDO_COLUMN_INFOS_WITHOUT_UUID;

    public static Set<String> allNames() {
        return PSEUDO_COLUMNS;
    }

    public static Set<String> allNamesExceptJcrUuid() {
        return PSEUDO_COLUMNS_WITHOUT_UUID;
    }

    public static Collection<Info> allColumns() {
        return PSEUDO_COLUMN_INFOS.values();
    }

    public static Collection<Info> allColumnsExceptJcrUuid() {
        return PSEUDO_COLUMN_INFOS_WITHOUT_UUID.values();
    }

    public static boolean contains(String columnName, boolean includeJcrUuid) {
        if (includeJcrUuid) {
            return PSEUDO_COLUMNS.contains(columnName);
        }
        return PSEUDO_COLUMNS_WITHOUT_UUID.contains(columnName);
    }

    public static boolean contains(org.modeshape.jcr.value.Name columnName, boolean includeJcrUuid) {
        if (includeJcrUuid) {
            return PSEUDO_COLUMN_INFOS.containsKey(columnName);
        }
        return PSEUDO_COLUMN_INFOS_WITHOUT_UUID.containsKey(columnName);
    }

    public static boolean isPath(String columnName) {
        return "jcr:path".equals(columnName);
    }

    public static boolean isPath(org.modeshape.jcr.value.Name columnName) {
        return QualifiedName.JCR_PATH.equals(columnName);
    }

    public static boolean isName(String columnName) {
        return "jcr:name".equals(columnName);
    }

    public static boolean isName(org.modeshape.jcr.value.Name columnName) {
        return QualifiedName.JCR_NAME.equals(columnName);
    }

    public static boolean isUuid(String columnName) {
        return "jcr:uuid".equals(columnName);
    }

    public static boolean isUuid(org.modeshape.jcr.value.Name columnName) {
        return QualifiedName.JCR_UUID.equals(columnName);
    }

    public static boolean isScore(String columnName) {
        return "jcr:score".equals(columnName);
    }

    public static boolean isScore(org.modeshape.jcr.value.Name columnName) {
        return QualifiedName.JCR_SCORE.equals(columnName);
    }

    public static boolean isLocalName(String columnName) {
        return "mode:localName".equals(columnName);
    }

    public static boolean isLocalName(org.modeshape.jcr.value.Name columnName) {
        return QualifiedName.MODE_LOCALNAME.equals(columnName);
    }

    public static boolean isDepth(String columnName) {
        return "mode:depth".equals(columnName);
    }

    public static boolean isDepth(org.modeshape.jcr.value.Name columnName) {
        return QualifiedName.MODE_DEPTH.equals(columnName);
    }

    public static boolean isId(String columnName) {
        return "mode:id".equals(columnName);
    }

    public static boolean isId(org.modeshape.jcr.value.Name columnName) {
        return QualifiedName.MODE_ID.equals(columnName);
    }

    private PseudoColumns() {
    }

    static {
        HashMap<org.modeshape.jcr.value.Name, Info> infos = new HashMap<org.modeshape.jcr.value.Name, Info>();
        infos.put(QualifiedName.JCR_SCORE, new Info("jcr:score", QualifiedName.JCR_SCORE, 4));
        infos.put(QualifiedName.JCR_PATH, new Info("jcr:path", QualifiedName.JCR_PATH, 1));
        infos.put(QualifiedName.JCR_NAME, new Info("jcr:name", QualifiedName.JCR_NAME, 1));
        infos.put(QualifiedName.JCR_UUID, new Info("jcr:uuid", QualifiedName.JCR_UUID, 1));
        infos.put(QualifiedName.MODE_LOCALNAME, new Info("mode:localName", QualifiedName.MODE_LOCALNAME, 1));
        infos.put(QualifiedName.MODE_DEPTH, new Info("mode:depth", QualifiedName.MODE_DEPTH, 3));
        infos.put(QualifiedName.MODE_ID, new Info("mode:id", QualifiedName.MODE_ID, 1));
        HashMap infosWithoutUuid = new HashMap(infos);
        infosWithoutUuid.remove(QualifiedName.JCR_UUID);
        PSEUDO_COLUMN_INFOS = java.util.Collections.unmodifiableMap(infos);
        PSEUDO_COLUMN_INFOS_WITHOUT_UUID = java.util.Collections.unmodifiableMap(infosWithoutUuid);
    }

    public static final class Info {
        private final org.modeshape.jcr.value.Name name;
        private final String stringName;
        private final int type;
        private final PropertyType propType;

        protected Info(String stringName, org.modeshape.jcr.value.Name jcrScore, int type) {
            this.name = jcrScore;
            this.stringName = stringName;
            this.type = type;
            this.propType = PropertyType.valueFor(type);
        }

        public org.modeshape.jcr.value.Name getQualifiedName() {
            return this.name;
        }

        public String getStringName() {
            return this.stringName;
        }

        public int getType() {
            return this.type;
        }

        public PropertyType getTypeAsEnum() {
            return this.propType;
        }
    }

    public static final class Type {
        public static final int JCR_SCORE = 4;
        public static final int JCR_PATH = 1;
        public static final int JCR_NAME = 1;
        public static final int JCR_UUID = 1;
        public static final int MODE_LOCALNAME = 1;
        public static final int MODE_DEPTH = 3;
        public static final int MODE_ID = 1;
    }

    public static final class QualifiedName {
        public static final org.modeshape.jcr.value.Name JCR_SCORE = JcrLexicon.SCORE;
        public static final org.modeshape.jcr.value.Name JCR_PATH = JcrLexicon.PATH;
        public static final org.modeshape.jcr.value.Name JCR_NAME = JcrLexicon.NAME;
        public static final org.modeshape.jcr.value.Name JCR_UUID = JcrLexicon.UUID;
        public static final org.modeshape.jcr.value.Name MODE_LOCALNAME = ModeShapeLexicon.LOCALNAME;
        public static final org.modeshape.jcr.value.Name MODE_DEPTH = ModeShapeLexicon.DEPTH;
        public static final org.modeshape.jcr.value.Name MODE_ID = ModeShapeLexicon.ID;
    }

    public static final class Name {
        public static final String JCR_SCORE = "jcr:score";
        public static final String JCR_PATH = "jcr:path";
        public static final String JCR_NAME = "jcr:name";
        public static final String JCR_UUID = "jcr:uuid";
        public static final String MODE_LOCALNAME = "mode:localName";
        public static final String MODE_DEPTH = "mode:depth";
        public static final String MODE_ID = "mode:id";
    }
}

