/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.optimize;

import java.util.LinkedList;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.optimize.OptimizerRule;
import org.modeshape.jcr.query.plan.PlanNode;

@Immutable
public class RemoveEmptyAccessNodes
implements OptimizerRule {
    public static final RemoveEmptyAccessNodes INSTANCE = new RemoveEmptyAccessNodes();

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        for (PlanNode access : plan.findAllAtOrBelow(PlanNode.Type.ACCESS)) {
            if (!access.getProperty(PlanNode.Property.ACCESS_NO_RESULTS, Boolean.class).booleanValue()) continue;
        }
        return plan;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

