/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value;

import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.UUID;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.SecureHash;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.basic.StringValueFactory;

@Immutable
public final class ValueComparators {
    public static final Comparator<String> STRING_COMPARATOR = new StringComparator();
    public static final Comparator<Long> LONG_COMPARATOR = new LongComparator();
    public static final Comparator<Double> DOUBLE_COMPARATOR = new DoubleComparator();
    public static final Comparator<BigDecimal> DECIMAL_COMPARATOR = new DecimalComparator();
    public static final Comparator<Boolean> BOOLEAN_COMPARATOR = new BooleanComparator();
    public static final Comparator<BinaryValue> BINARY_COMPARATOR = new BinaryValueComparator();
    public static final Comparator<DateTime> DATE_TIME_COMPARATOR = new DateTimeComparator();
    public static final Comparator<Date> DATE_COMPARATOR = new DateComparator();
    public static final Comparator<Calendar> CALENDAR_COMPARATOR = new CalendarComparator();
    public static final Comparator<Name> NAME_COMPARATOR = new NameComparator();
    public static final Comparator<Path> PATH_COMPARATOR = new PathComparator();
    public static final Comparator<Path.Segment> PATH_SEGMENT_COMPARATOR = new PathSegmentComparator();
    public static final Comparator<Path.Segment> PATH_SEGMENT_NAME_COMPARATOR = new PathSegmentNameComparator();
    public static final Comparator<URI> URI_COMPARATOR = new UriComparator();
    public static final Comparator<UUID> UUID_COMPARATOR = new UuidComparator();
    public static final Comparator<Reference> REFERENCE_COMPARATOR = new ReferenceComparator();
    public static final Comparator<Object> OBJECT_COMPARATOR = new ObjectComparator();
    private static ValueFactory<String> STRING_VALUE_FACTORY;

    protected static final ValueFactory<String> getStringValueFactory() {
        if (STRING_VALUE_FACTORY == null) {
            STRING_VALUE_FACTORY = new StringValueFactory(Path.NO_OP_DECODER, Path.NO_OP_ENCODER);
        }
        return STRING_VALUE_FACTORY;
    }

    protected static final class BinaryValueComparator
    implements Comparator<BinaryValue>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected BinaryValueComparator() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public int compare(BinaryValue o1, BinaryValue o2) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 40[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof BinaryValueComparator;
        }

        public int hashCode() {
            return 1;
        }
    }

    protected static final class ObjectComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected ObjectComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            PropertyType type1 = PropertyType.discoverType(o1);
            PropertyType type2 = PropertyType.discoverType(o2);
            o1 = type1.getCanonicalValue(o1);
            o2 = type2.getCanonicalValue(o2);
            if (type1 != PropertyType.OBJECT && type2 != PropertyType.OBJECT) {
                if (type1 == type2) {
                    return type1.getComparator().compare(o1, o2);
                }
                if (type1.getValueClass().isAssignableFrom(type2.getValueClass())) {
                    return type1.getComparator().compare(o1, o2);
                }
                if (type2.getValueClass().isAssignableFrom(type1.getValueClass())) {
                    return type2.getComparator().compare(o1, o2);
                }
            }
            ValueFactory<String> stringFactory = ValueComparators.getStringValueFactory();
            String value1 = null;
            String value2 = null;
            if (type1 == PropertyType.BINARY || type2 == PropertyType.BINARY) {
                try {
                    byte[] hash1 = null;
                    byte[] hash2 = null;
                    if (type1 == PropertyType.BINARY) {
                        value2 = stringFactory.create(o2);
                        hash2 = SecureHash.getHash((SecureHash.Algorithm)SecureHash.Algorithm.SHA_1, (byte[])value2.getBytes());
                        hash1 = ((BinaryValue)o1).getHash();
                    } else {
                        assert (type2 == PropertyType.BINARY);
                        value1 = stringFactory.create(o1);
                        hash1 = SecureHash.getHash((SecureHash.Algorithm)SecureHash.Algorithm.SHA_1, (byte[])value1.getBytes());
                        hash2 = ((BinaryValue)o2).getHash();
                    }
                    if (hash1.length == hash2.length) {
                        for (int i = 0; i != hash1.length; ++i) {
                            int diff = hash1[i] - hash2[i];
                            if (diff == 0) continue;
                            return diff;
                        }
                        return 0;
                    }
                }
                catch (Throwable error) {
                    // empty catch block
                }
            }
            if (value1 == null) {
                value1 = stringFactory.create(o1);
            }
            if (value2 == null) {
                value2 = stringFactory.create(o2);
            }
            return value1.compareTo(value2);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ObjectComparator;
        }

        public int hashCode() {
            return 1;
        }
    }

    protected static final class ReferenceComparator
    implements Comparator<Reference>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected ReferenceComparator() {
        }

        @Override
        public int compare(Reference o1, Reference o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ReferenceComparator;
        }

        public int hashCode() {
            return 1;
        }
    }

    protected static final class UuidComparator
    implements Comparator<UUID>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected UuidComparator() {
        }

        @Override
        public int compare(UUID o1, UUID o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof UuidComparator;
        }

        public int hashCode() {
            return 1;
        }
    }

    protected static final class UriComparator
    implements Comparator<URI>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected UriComparator() {
        }

        @Override
        public int compare(URI o1, URI o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof UriComparator;
        }

        public int hashCode() {
            return 1;
        }
    }

    protected static final class PathSegmentNameComparator
    implements Comparator<Path.Segment>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected PathSegmentNameComparator() {
        }

        @Override
        public int compare(Path.Segment o1, Path.Segment o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof PathSegmentNameComparator;
        }

        public int hashCode() {
            return 1;
        }
    }

    protected static final class PathSegmentComparator
    implements Comparator<Path.Segment>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected PathSegmentComparator() {
        }

        @Override
        public int compare(Path.Segment o1, Path.Segment o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof PathSegmentComparator;
        }

        public int hashCode() {
            return 1;
        }
    }

    protected static final class PathComparator
    implements Comparator<Path>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected PathComparator() {
        }

        @Override
        public int compare(Path o1, Path o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof PathComparator;
        }

        public int hashCode() {
            return 1;
        }
    }

    protected static final class NameComparator
    implements Comparator<Name>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected NameComparator() {
        }

        @Override
        public int compare(Name o1, Name o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof NameComparator;
        }

        public int hashCode() {
            return 1;
        }
    }

    protected static final class CalendarComparator
    implements Comparator<Calendar>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected CalendarComparator() {
        }

        @Override
        public int compare(Calendar o1, Calendar o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof CalendarComparator;
        }

        public int hashCode() {
            return 1;
        }
    }

    protected static final class DateComparator
    implements Comparator<Date>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected DateComparator() {
        }

        @Override
        public int compare(Date o1, Date o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof DateComparator;
        }

        public int hashCode() {
            return 1;
        }
    }

    protected static final class DateTimeComparator
    implements Comparator<DateTime>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected DateTimeComparator() {
        }

        @Override
        public int compare(DateTime o1, DateTime o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo((Object)o2);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof DateTimeComparator;
        }

        public int hashCode() {
            return 1;
        }
    }

    protected static final class DecimalComparator
    implements Comparator<BigDecimal>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected DecimalComparator() {
        }

        @Override
        public int compare(BigDecimal o1, BigDecimal o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof DecimalComparator;
        }

        public int hashCode() {
            return 1;
        }
    }

    protected static final class DoubleComparator
    implements Comparator<Double>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected DoubleComparator() {
        }

        @Override
        public int compare(Double o1, Double o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof DoubleComparator;
        }

        public int hashCode() {
            return 1;
        }
    }

    protected static final class LongComparator
    implements Comparator<Long>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected LongComparator() {
        }

        @Override
        public int compare(Long o1, Long o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof LongComparator;
        }

        public int hashCode() {
            return 1;
        }
    }

    protected static final class BooleanComparator
    implements Comparator<Boolean>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected BooleanComparator() {
        }

        @Override
        public int compare(Boolean o1, Boolean o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof BooleanComparator;
        }

        public int hashCode() {
            return 1;
        }
    }

    protected static final class StringComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected StringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof StringComparator;
        }

        public int hashCode() {
            return 1;
        }
    }
}

