/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.File;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.FileUtil;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.FileSystemBinaryStore;

@ThreadSafe
public final class TransientBinaryStore
extends FileSystemBinaryStore {
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private static final String JBOSS_SERVER_DATA_DIR = "jboss.server.data.dir";
    private static final TransientBinaryStore INSTANCE = new TransientBinaryStore();
    protected static final File TRANSIENT_STORE_DIRECTORY = INSTANCE.getDirectory();
    private static boolean printedLocation = false;

    public static TransientBinaryStore get() {
        return INSTANCE;
    }

    private static File newTempDirectory() {
        String tempDirName = System.getProperty(JAVA_IO_TMPDIR);
        if (tempDirName == null) {
            throw new SystemFailureException(JcrI18n.tempDirectorySystemPropertyMustBeSet.text(new Object[]{JAVA_IO_TMPDIR}));
        }
        File tempDir = new File(tempDirName);
        return new File(tempDir, "modeshape-binary-store");
    }

    private TransientBinaryStore() {
        super(TransientBinaryStore.newTempDirectory());
    }

    @Override
    public void start() {
        if (!printedLocation && System.getProperty(JBOSS_SERVER_DATA_DIR) == null) {
            Logger logger = Logger.getLogger(this.getClass());
            logger.debug("ModeShape repositories will use the following directory for transient storage of binary values unless repository configurations specify otherwise: {0}", new Object[]{this.getDirectory().getAbsolutePath()});
            printedLocation = true;
        }
        super.start();
    }

    @Override
    protected void initializeStorage(File directory) throws BinaryStoreException {
        FileUtil.delete((File)directory);
        if (!directory.exists()) {
            Logger.getLogger(this.getClass()).debug("Creating temporary directory for transient binary store: {0}", new Object[]{directory.getAbsolutePath()});
            directory.mkdirs();
        }
        if (!directory.canRead()) {
            throw new BinaryStoreException(JcrI18n.unableToReadTemporaryDirectory.text(new Object[]{directory.getAbsolutePath(), JAVA_IO_TMPDIR}));
        }
        if (!directory.canWrite()) {
            throw new BinaryStoreException(JcrI18n.unableToWriteTemporaryDirectory.text(new Object[]{directory.getAbsolutePath(), JAVA_IO_TMPDIR}));
        }
    }

    @Override
    protected void moveFileExclusively(File original, File destination, BinaryKey key) throws BinaryStoreException {
        super.moveFileExclusively(original, destination, key);
        destination.deleteOnExit();
    }
}

