/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary.infinispan;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class Metadata
implements Externalizable {
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private long length;
    private int numberChunks;
    private long modificationTime;
    private long unusedSince;
    private String mimeType;
    private int numberTextChunks;
    private int chunkSize;

    public Metadata() {
    }

    protected Metadata(long modificationTime, long length, int numberOfChunks, int chunkSize) {
        this(modificationTime, length, numberOfChunks, 0L, null, 0, chunkSize);
    }

    protected Metadata(long modificationTime, long length, int numberOfChunks, long unusedSince, String mimeType, int numberTextChunks, int chunkSize) {
        this.length = length;
        this.modificationTime = modificationTime;
        this.numberChunks = numberOfChunks;
        this.unusedSince = unusedSince;
        this.mimeType = mimeType;
        this.numberTextChunks = numberTextChunks;
        this.chunkSize = chunkSize;
    }

    protected long getLength() {
        return this.length;
    }

    protected String getMimeType() {
        return this.mimeType;
    }

    protected Metadata withMimeType(String mimeType) {
        return new Metadata(this.modificationTime, this.length, this.numberChunks, this.unusedSince, mimeType, this.numberTextChunks, this.chunkSize);
    }

    protected int getNumberTextChunks() {
        return this.numberTextChunks;
    }

    protected Metadata withNumberOfTextChunks(int numberTextChunks) {
        return new Metadata(this.modificationTime, this.length, this.numberChunks, this.unusedSince, this.mimeType, numberTextChunks, this.chunkSize);
    }

    protected int getNumberChunks() {
        return this.numberChunks;
    }

    protected boolean isUnused() {
        return this.unusedSince > 0L;
    }

    protected void markAsUnusedSince(long unusedSince) {
        this.unusedSince = unusedSince;
    }

    protected void markAsUsed() {
        this.unusedSince = 0L;
    }

    protected int getChunkSize() {
        return this.chunkSize;
    }

    protected long unusedSince() {
        return this.unusedSince;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(2);
        out.writeLong(this.length);
        out.writeInt(this.numberChunks);
        out.writeLong(this.modificationTime);
        out.writeLong(this.unusedSince);
        out.writeInt(this.numberTextChunks);
        if (this.mimeType != null) {
            out.writeBoolean(true);
            out.writeUTF(this.mimeType);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.chunkSize);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        short version = in.readShort();
        this.length = in.readLong();
        this.numberChunks = in.readInt();
        this.modificationTime = in.readLong();
        this.unusedSince = in.readLong();
        this.numberTextChunks = in.readInt();
        if (in.readBoolean()) {
            this.mimeType = in.readUTF();
        }
        switch (version) {
            case 1: {
                this.chunkSize = 0x100000;
                break;
            }
            case 2: {
                this.chunkSize = in.readInt();
            }
        }
    }
}

