/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.modeshape.common.collection.SingleIterator;
import org.modeshape.common.collection.Supplier;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.index.local.MapDB;
import org.modeshape.jcr.query.Tuples;
import org.modeshape.jcr.query.model.TypeSystem;
import org.modeshape.jcr.value.ValueFactories;

public class BufferManager
implements MapDB.Serializers,
AutoCloseable {
    private static final Supplier<DB> OFF_HEAP_DB_SUPPLIER = new Supplier<DB>(){

        public DB get() {
            return DBMaker.newMemoryDirectDB().make();
        }
    };
    private static final Supplier<DB> ON_HEAP_DB_SUPPLIER = new Supplier<DB>(){

        public DB get() {
            return DBMaker.newMemoryDB().make();
        }
    };
    private final MapDB.Serializers serializers;
    private final DbHolder offheap;
    private final DbHolder onheap;
    private final AtomicLong dbCounter = new AtomicLong();

    public BufferManager(ExecutionContext context) {
        this(context, OFF_HEAP_DB_SUPPLIER, ON_HEAP_DB_SUPPLIER);
    }

    protected BufferManager(ExecutionContext context, Supplier<DB> offheapDbSupplier, Supplier<DB> onheapDbSupplier) {
        this.offheap = new DbHolder(offheapDbSupplier);
        this.onheap = new DbHolder(onheapDbSupplier);
        ValueFactories factories = context.getValueFactories();
        this.serializers = MapDB.serializers(factories);
    }

    @Override
    public void close() {
        block11: {
            RuntimeException error = null;
            try {
                this.onheap.close();
            }
            catch (RuntimeException e) {
                error = e;
            }
            finally {
                block12: {
                    try {
                        this.offheap.close();
                    }
                    catch (RuntimeException e) {
                        if (error != null) break block12;
                        error = e;
                    }
                }
                if (error == null) break block11;
                throw error;
            }
        }
    }

    public <T> QueueBufferMaker<T> createQueueBuffer(Serializer<T> serializer) {
        return new MakeOrderedBuffer<T>("buffer-" + this.dbCounter.incrementAndGet(), serializer);
    }

    public <T> DistinctBufferMaker<T> createDistinctBuffer(Serializer<T> distinctSerializer) {
        return new MakeDistinctBuffer<T>("buffer-" + this.dbCounter.incrementAndGet(), distinctSerializer);
    }

    public <K, V> SortingBufferMaker<K, V> createSortingBuffer(BTreeKeySerializer<K> keySerializer, Serializer<V> valueSerializer) {
        return new MakeSortingBuffer<K, V>("buffer-" + this.dbCounter.incrementAndGet(), keySerializer, valueSerializer);
    }

    public <K extends Comparable<K>, V> SortingBufferMaker<K, V> createSortingWithDuplicatesBuffer(Serializer<K> keySerializer, Comparator<?> keyComparator, Serializer<V> valueSerializer) {
        return new MakeSortingWithDuplicatesBuffer<K, V>("buffer-" + this.dbCounter.incrementAndGet(), keySerializer, keyComparator, valueSerializer);
    }

    @Override
    public Serializer<?> serializerFor(Class<?> type) {
        return null;
    }

    @Override
    public BTreeKeySerializer<?> bTreeKeySerializerFor(Class<?> type, Comparator<?> comparator, boolean pack) {
        return null;
    }

    @Override
    public Serializer<?> nullSafeSerializerFor(Class<?> type) {
        return null;
    }

    public Serializer<?> serializerFor(TypeSystem.TypeFactory<?> type) {
        if (type instanceof Tuples.TupleFactory) {
            return ((Tuples.TupleFactory)((Object)type)).getSerializer(this);
        }
        return this.serializers.serializerFor(type.getType());
    }

    public Serializer<?> nullSafeSerializerFor(TypeSystem.TypeFactory<?> type) {
        if (type instanceof Tuples.TupleFactory) {
            return ((Tuples.TupleFactory)((Object)type)).getSerializer(this);
        }
        return this.serializers.nullSafeSerializerFor(type.getType());
    }

    public BTreeKeySerializer<?> bTreeKeySerializerFor(TypeSystem.TypeFactory<?> type, boolean pack) {
        return this.serializers.bTreeKeySerializerFor(type.getType(), type.getComparator(), pack);
    }

    protected final DB db(boolean useHeap) {
        return useHeap ? this.onheap.get() : this.offheap.get();
    }

    protected final void delete(String name, boolean onHeap) {
        this.db(onHeap).delete(name);
    }

    protected final class MakeSortingWithDuplicatesBuffer<K extends Comparable<K>, V>
    implements SortingBufferMaker<K, V> {
        private final String name;
        private boolean useHeap = true;
        private boolean keepsize = false;
        private final Serializer<K> keySerializer;
        private final Serializer<V> valueSerializer;
        private final Comparator<K> keyComparator;

        protected MakeSortingWithDuplicatesBuffer(String name, Serializer<K> keySerializer, Comparator<?> keyComparator, Serializer<V> valueSerializer) {
            this.name = name;
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.keyComparator = keyComparator;
        }

        @Override
        public SortingBufferMaker<K, V> keepSize(boolean keepBufferSize) {
            this.keepsize = keepBufferSize;
            return this;
        }

        @Override
        public SortingBufferMaker<K, V> useHeap(boolean useHeap) {
            this.useHeap = useHeap;
            return this;
        }

        @Override
        public SortingBuffer<K, V> make() {
            Comparator comparator = (Comparator)((Object)(this.keyComparator != null ? new MapDB.UniqueKeyComparator<K>(this.keyComparator) : new MapDB.ComparableUniqueKeyComparator()));
            MapDB.UniqueKeyBTreeSerializer<K> uniqueKeySerializer = new MapDB.UniqueKeyBTreeSerializer<K>(this.keySerializer, comparator);
            DB.BTreeMapMaker maker = BufferManager.this.db(this.useHeap).createTreeMap(this.name).keySerializer(uniqueKeySerializer).valueSerializer(this.valueSerializer);
            if (this.keepsize) {
                maker = maker.counterEnable();
            }
            BTreeMap buffer = maker.make();
            return new CloseableSortingBufferWithDuplicates(this.name, this.useHeap, buffer);
        }
    }

    protected final class MakeSortingBuffer<K, V>
    implements SortingBufferMaker<K, V> {
        private final String name;
        private boolean useHeap = true;
        private boolean keepsize = false;
        private final BTreeKeySerializer<K> keySerializer;
        private final Serializer<V> valueSerializer;

        protected MakeSortingBuffer(String name, BTreeKeySerializer<K> keySerializer, Serializer<V> valueSerializer) {
            this.name = name;
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
        }

        @Override
        public SortingBufferMaker<K, V> keepSize(boolean keepBufferSize) {
            this.keepsize = keepBufferSize;
            return this;
        }

        @Override
        public SortingBufferMaker<K, V> useHeap(boolean useHeap) {
            this.useHeap = useHeap;
            return this;
        }

        @Override
        public SortingBuffer<K, V> make() {
            DB.BTreeMapMaker maker = BufferManager.this.db(this.useHeap).createTreeMap(this.name).keySerializer(this.keySerializer).valueSerializer(this.valueSerializer);
            if (this.keepsize) {
                maker = maker.counterEnable();
            }
            BTreeMap buffer = maker.make();
            return new CloseableSortingBuffer(this.name, this.useHeap, buffer);
        }
    }

    protected final class MakeDistinctBuffer<T>
    implements DistinctBufferMaker<T> {
        private final String name;
        private boolean useHeap = true;
        private boolean keepsize = false;
        private final Serializer<T> serializer;

        protected MakeDistinctBuffer(String name, Serializer<T> serializer) {
            assert (name != null);
            assert (serializer != null);
            this.name = name;
            this.serializer = serializer;
        }

        @Override
        public DistinctBufferMaker<T> keepSize(boolean keepBufferSize) {
            this.keepsize = keepBufferSize;
            return this;
        }

        @Override
        public DistinctBufferMaker<T> useHeap(boolean useHeap) {
            this.useHeap = useHeap;
            return this;
        }

        @Override
        public DistinctBuffer<T> make() {
            DB.HTreeSetMaker maker = BufferManager.this.db(this.useHeap).createHashSet(this.name).serializer(this.serializer);
            if (this.keepsize) {
                maker = maker.counterEnable();
            }
            Set buffer = maker.make();
            return new CloseableDistinctBuffer(this.name, this.useHeap, buffer);
        }
    }

    protected final class MakeOrderedBuffer<T>
    implements QueueBufferMaker<T> {
        private final String name;
        private boolean useHeap = true;
        private final Serializer<T> serializer;

        protected MakeOrderedBuffer(String name, Serializer<T> serializer) {
            assert (name != null);
            assert (serializer != null);
            this.name = name;
            this.serializer = serializer;
        }

        @Override
        public MakeOrderedBuffer<T> useHeap(boolean useHeap) {
            this.useHeap = useHeap;
            return this;
        }

        @Override
        public QueueBuffer<T> make() {
            HTreeMap values = BufferManager.this.db(this.useHeap).createHashMap(this.name).valueSerializer(this.serializer).counterEnable().make();
            return new CloseableQueueBuffer(this.name, this.useHeap, values);
        }
    }

    protected final class CloseableSortingBufferWithDuplicates<K extends Comparable<K>, V>
    extends CloseableBuffer
    implements SortingBuffer<K, V> {
        private final NavigableMap<MapDB.UniqueKey<K>, V> buffer;
        private final AtomicLong counter;

        protected CloseableSortingBufferWithDuplicates(String name, boolean onHeap, NavigableMap<MapDB.UniqueKey<K>, V> buffer) {
            super(name, onHeap);
            this.counter = new AtomicLong();
            this.buffer = buffer;
        }

        @Override
        public boolean isEmpty() {
            return this.buffer.isEmpty();
        }

        @Override
        public long size() {
            return this.buffer.size();
        }

        @Override
        public void put(K sortable, V record) {
            this.buffer.put(new MapDB.UniqueKey<K>(sortable, this.counter.incrementAndGet()), record);
        }

        @Override
        public Iterator<V> getAll(K key) {
            MapDB.UniqueKey<K> lowest = new MapDB.UniqueKey<K>(key, 0L);
            MapDB.UniqueKey<K> pastHighest = new MapDB.UniqueKey<K>(key, Long.MAX_VALUE);
            SortedMap<MapDB.UniqueKey<K>, V> map = this.buffer.subMap(lowest, pastHighest);
            if (map == null || map.isEmpty()) {
                return null;
            }
            final Iterator<Map.Entry<MapDB.UniqueKey<K>, V>> entryIter = map.entrySet().iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return entryIter.hasNext();
                }

                @Override
                public V next() {
                    return ((Map.Entry)entryIter.next()).getValue();
                }

                @Override
                public void remove() {
                    entryIter.remove();
                }
            };
        }

        @Override
        public Iterator<V> getAll(K lowerKey, boolean includeLowerKey, K upperKey, boolean includeUpperKey) {
            MapDB.UniqueKey<K> highest;
            MapDB.UniqueKey<K> lowest = includeLowerKey ? new MapDB.UniqueKey<K>(lowerKey, 0L) : new MapDB.UniqueKey<K>(lowerKey, Long.MAX_VALUE);
            MapDB.UniqueKey<K> uniqueKey = highest = includeUpperKey ? new MapDB.UniqueKey<K>(upperKey, Long.MAX_VALUE) : new MapDB.UniqueKey<K>(upperKey, 0L);
            if (upperKey == null) {
                if (lowerKey == null) {
                    return Collections.emptyList().iterator();
                }
                return this.buffer.tailMap(lowest, includeLowerKey).values().iterator();
            }
            if (lowerKey == null) {
                assert (upperKey != null);
                return this.buffer.headMap(highest, includeUpperKey).values().iterator();
            }
            assert (lowerKey != null);
            assert (upperKey != null);
            return this.buffer.subMap(lowest, includeLowerKey, highest, includeUpperKey).values().iterator();
        }

        @Override
        public Iterator<V> ascending() {
            final Iterator entryIter = this.buffer.entrySet().iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return entryIter.hasNext();
                }

                @Override
                public V next() {
                    return ((Map.Entry)entryIter.next()).getValue();
                }

                @Override
                public void remove() {
                    entryIter.remove();
                }
            };
        }

        @Override
        public Iterator<V> descending() {
            final Iterator entryIter = this.buffer.descendingMap().entrySet().iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return entryIter.hasNext();
                }

                @Override
                public V next() {
                    return ((Map.Entry)entryIter.next()).getValue();
                }

                @Override
                public void remove() {
                    entryIter.remove();
                }
            };
        }

        public String toString() {
            return "SortingBufferWithDuplicateKeys(" + this.name + ")";
        }
    }

    protected final class CloseableSortingBuffer<K, V>
    extends CloseableBuffer
    implements SortingBuffer<K, V> {
        private final NavigableMap<K, V> buffer;

        protected CloseableSortingBuffer(String name, boolean onHeap, NavigableMap<K, V> buffer) {
            super(name, onHeap);
            this.buffer = buffer;
        }

        @Override
        public boolean isEmpty() {
            return this.buffer.isEmpty();
        }

        @Override
        public long size() {
            return this.buffer.size();
        }

        @Override
        public void put(K sortable, V record) {
            this.buffer.put(sortable, record);
        }

        @Override
        public Iterator<V> getAll(K key) {
            Object value = this.buffer.get(key);
            return value == null ? null : new SingleIterator(value);
        }

        @Override
        public Iterator<V> getAll(K lowerKey, boolean includeLowerKey, K upperKey, boolean includeUpperKey) {
            if (lowerKey == null) {
                if (upperKey == null) {
                    return this.buffer.values().iterator();
                }
                return this.buffer.headMap(upperKey, includeUpperKey).values().iterator();
            }
            assert (lowerKey != null);
            if (upperKey == null) {
                return this.buffer.tailMap(lowerKey, includeLowerKey).values().iterator();
            }
            return this.buffer.subMap(lowerKey, includeLowerKey, upperKey, includeUpperKey).values().iterator();
        }

        @Override
        public Iterator<V> ascending() {
            final Iterator entryIter = this.buffer.entrySet().iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return entryIter.hasNext();
                }

                @Override
                public V next() {
                    return ((Map.Entry)entryIter.next()).getValue();
                }

                @Override
                public void remove() {
                    entryIter.remove();
                }
            };
        }

        @Override
        public Iterator<V> descending() {
            final Iterator entryIter = this.buffer.descendingMap().entrySet().iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return entryIter.hasNext();
                }

                @Override
                public V next() {
                    return ((Map.Entry)entryIter.next()).getValue();
                }

                @Override
                public void remove() {
                    entryIter.remove();
                }
            };
        }

        public String toString() {
            return "SortingBuffer(" + this.name + ")";
        }
    }

    protected final class CloseableDistinctBuffer<T>
    extends CloseableBuffer
    implements DistinctBuffer<T> {
        private final Set<T> buffer;

        protected CloseableDistinctBuffer(String name, boolean onHeap, Set<T> buffer) {
            super(name, onHeap);
            this.buffer = buffer;
        }

        @Override
        public boolean isEmpty() {
            return this.buffer.isEmpty();
        }

        @Override
        public long size() {
            return this.buffer.size();
        }

        @Override
        public boolean addIfAbsent(T value) {
            return this.buffer.add(value);
        }

        @Override
        public Iterator<T> iterator() {
            return this.buffer.iterator();
        }

        public String toString() {
            return "DistinctBuffer(" + this.name + ")";
        }
    }

    protected final class CloseableQueueBuffer<T>
    extends CloseableBuffer
    implements QueueBuffer<T> {
        protected final Map<Long, T> buffer;
        private final AtomicLong size;

        protected CloseableQueueBuffer(String name, boolean onHeap, Map<Long, T> buffer) {
            super(name, onHeap);
            this.size = new AtomicLong();
            this.buffer = buffer;
        }

        @Override
        public boolean isEmpty() {
            return this.buffer.isEmpty();
        }

        @Override
        public long size() {
            return this.size.get();
        }

        @Override
        public void append(T value) {
            this.buffer.put(this.size.getAndIncrement(), value);
        }

        @Override
        public Iterator<T> iterator() {
            final AtomicLong counter = new AtomicLong(0L);
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return counter.get() < (long)CloseableQueueBuffer.this.buffer.size();
                }

                @Override
                public T next() {
                    Long key = counter.getAndIncrement();
                    if (key.intValue() < CloseableQueueBuffer.this.buffer.size()) {
                        return CloseableQueueBuffer.this.buffer.get(key);
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public String toString() {
            return "QueueBuffer(" + this.name + ",size=" + this.size.get() + ")";
        }
    }

    protected abstract class CloseableBuffer
    implements Buffer {
        protected final String name;
        protected final boolean onHeap;

        protected CloseableBuffer(String name, boolean onHeap) {
            this.name = name;
            this.onHeap = onHeap;
        }

        @Override
        public void close() {
            BufferManager.this.delete(this.name, this.onHeap);
        }
    }

    protected static final class DbHolder
    implements AutoCloseable {
        private final AtomicReference<DB> reference = new AtomicReference();
        private final Lock lock = new ReentrantLock();
        private final Supplier<DB> supplier;

        protected DbHolder(Supplier<DB> supplier) {
            this.supplier = supplier;
        }

        public DB get() {
            DB db = this.reference.get();
            if (db == null) {
                try {
                    this.lock.lock();
                    db = (DB)this.supplier.get();
                    this.reference.set(db);
                }
                finally {
                    this.lock.unlock();
                }
            }
            return db;
        }

        @Override
        public void close() {
            DB db = this.reference.getAndSet(null);
            if (db != null) {
                db.close();
            }
        }
    }

    public static interface SortingBufferMaker<SortType, RecordType> {
        public SortingBufferMaker<SortType, RecordType> useHeap(boolean var1);

        public SortingBufferMaker<SortType, RecordType> keepSize(boolean var1);

        public SortingBuffer<SortType, RecordType> make();
    }

    public static interface DistinctBufferMaker<T> {
        public DistinctBufferMaker<T> useHeap(boolean var1);

        public DistinctBufferMaker<T> keepSize(boolean var1);

        public DistinctBuffer<T> make();
    }

    public static interface QueueBufferMaker<T> {
        public QueueBufferMaker<T> useHeap(boolean var1);

        public QueueBuffer<T> make();
    }

    public static interface SortingBuffer<SortType, RecordType>
    extends Buffer {
        public void put(SortType var1, RecordType var2);

        public Iterator<RecordType> ascending();

        public Iterator<RecordType> descending();

        public Iterator<RecordType> getAll(SortType var1);

        public Iterator<RecordType> getAll(SortType var1, boolean var2, SortType var3, boolean var4);
    }

    public static interface DistinctBuffer<T>
    extends Buffer,
    Iterable<T>,
    Predicate<T> {
        @Override
        public Iterator<T> iterator();
    }

    public static interface Predicate<T> {
        public boolean addIfAbsent(T var1);
    }

    public static interface QueueBuffer<T>
    extends Buffer,
    Iterable<T> {
        public void append(T var1);

        @Override
        public Iterator<T> iterator();
    }

    public static interface Buffer
    extends AutoCloseable {
        public boolean isEmpty();

        public long size();

        @Override
        public void close();
    }
}

